/*
 * Decompiled with CFR 0.152.
 */
package com.edb.copy;

import com.edb.copy.CopyIn;
import com.edb.copy.CopyOperation;
import com.edb.copy.CopyOut;
import com.edb.core.BaseConnection;
import com.edb.core.Encoding;
import com.edb.core.QueryExecutor;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;

public class CopyManager {
    static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Encoding encoding;
    private final QueryExecutor queryExecutor;

    public CopyManager(BaseConnection connection) throws SQLException {
        this.encoding = connection.getEncoding();
        this.queryExecutor = connection.getQueryExecutor();
    }

    public CopyIn copyIn(String sql) throws SQLException {
        CopyOperation op = null;
        try {
            op = this.queryExecutor.startCopy(sql);
            return (CopyIn)op;
        }
        catch (ClassCastException cce) {
            op.cancelCopy();
            throw new PSQLException(GT.tr("Requested CopyIn but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE, (Throwable)cce);
        }
    }

    public CopyOut copyOut(String sql) throws SQLException {
        CopyOperation op = null;
        try {
            op = this.queryExecutor.startCopy(sql);
            return (CopyOut)op;
        }
        catch (ClassCastException cce) {
            op.cancelCopy();
            throw new PSQLException(GT.tr("Requested CopyOut but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE, (Throwable)cce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyOut(String sql, Writer to) throws SQLException, IOException {
        CopyOut cp = this.copyOut(sql);
        try {
            byte[] buf;
            while ((buf = cp.readFromCopy()) != null) {
                to.write(this.encoding.decode(buf));
            }
            long l = cp.getHandledRowCount();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyOut(String sql, OutputStream to) throws SQLException, IOException {
        CopyOut cp = this.copyOut(sql);
        try {
            byte[] buf;
            while ((buf = cp.readFromCopy()) != null) {
                to.write(buf);
            }
            long l = cp.getHandledRowCount();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    public long copyIn(String sql, Reader from) throws SQLException, IOException {
        return this.copyIn(sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String sql, Reader from, int bufferSize) throws SQLException, IOException {
        char[] cbuf = new char[bufferSize];
        CopyIn cp = this.copyIn(sql);
        try {
            int len;
            while ((len = from.read(cbuf)) > 0) {
                byte[] buf = this.encoding.encode(new String(cbuf));
                cp.writeToCopy(buf, 0, buf.length);
            }
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    public long copyIn(String sql, InputStream from) throws SQLException, IOException {
        return this.copyIn(sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String sql, InputStream from, int bufferSize) throws SQLException, IOException {
        byte[] buf = new byte[bufferSize];
        CopyIn cp = this.copyIn(sql);
        try {
            int len;
            while ((len = from.read(buf)) > 0) {
                cp.writeToCopy(buf, 0, len);
            }
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }

    public void copyOut(String table, OutputStream os, char copyDelimiter) throws SQLException, IOException {
        this.copyOut("COPY " + table + " TO STDOUT WITH DELIMITER AS '" + copyDelimiter + "'", os);
    }

    public void copyIn(String table, InputStream is, char copyDelimiter) throws SQLException, IOException {
        this.copyIn("COPY " + table + " FROM STDIN WITH DELIMITER AS '" + copyDelimiter + "'", is);
    }
}

