/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.StreamGobbler;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbGateway {
    private static final String VAR_NODEHOST = "dbhost";
    private static final String VAR_NODEPORT = "dbport";
    private static final String VAR_NODEDB = "database";
    private static final String VAR_DBUSERNAME = "dbusername";
    private static final String VAR_DBPASSWORD = "dbpassword";
    private static final String VAR_PSQLUTILNAME = "psql-util-name";
    private boolean force = false;

    private void executeTemplateOnNodes(String string, HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        this.executeTemplateOnNodes(string, hashMap, nodeDBConnectionInfoArray, true);
    }

    private void executeTemplateOnNodes(String string, HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        String[] stringArray = new String[nodeDBConnectionInfoArray.length];
        for (int i = 0; i < nodeDBConnectionInfoArray.length; ++i) {
            stringArray[i] = ParseCmdLine.substitute((String)string, this.populateValueMap(nodeDBConnectionInfoArray[i], hashMap));
        }
        if (bl) {
            this.executeList(stringArray);
        } else {
            String[] stringArray2 = new String[1];
            String[] stringArray3 = stringArray;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                stringArray2[0] = string2 = stringArray3[i];
                this.executeList(stringArray2);
            }
        }
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void createDbOnNodes(HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        this.executeTemplateOnNodes(Props.XDB_GATEWAY_CREATEDB, hashMap, nodeDBConnectionInfoArray, false);
    }

    public void startDbOnNodes(HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        this.executeTemplateOnNodes(Props.XDB_GATEWAY_STARTDB, hashMap, nodeDBConnectionInfoArray);
    }

    public void stopDbOnNodes(HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        this.executeTemplateOnNodes(Props.XDB_GATEWAY_STOPDB, hashMap, nodeDBConnectionInfoArray);
    }

    public void dropDbOnNodes(HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        try {
            this.stopDbOnNodes(hashMap, nodeDBConnectionInfoArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeTemplateOnNodes(Props.XDB_GATEWAY_DROPDB, hashMap, nodeDBConnectionInfoArray);
    }

    public void dropDbOnNode(HashMap<String, String> hashMap, NodeDBConnectionInfo nodeDBConnectionInfo) throws IOException {
        NodeDBConnectionInfo[] nodeDBConnectionInfoArray = new NodeDBConnectionInfo[]{nodeDBConnectionInfo};
        this.dropDbOnNodes(hashMap, nodeDBConnectionInfoArray);
    }

    public void execScriptOnNodes(HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        this.executeTemplateOnNodes(Props.XDB_GATEWAY_EXECSCRIPT, hashMap, nodeDBConnectionInfoArray);
    }

    public void execOnNodes(String string, HashMap<String, String> hashMap, NodeDBConnectionInfo[] nodeDBConnectionInfoArray) throws IOException {
        this.executeTemplateOnNodes(string, hashMap, nodeDBConnectionInfoArray, true);
    }

    private void executeList(String[] stringArray) throws IOException {
        int n;
        Process[] processArray = new Process[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && stringArray[n].length() > 0) {
                String string = Props.XDB_GATEWAY_PATH != null && Props.XDB_GATEWAY_PATH.length() > 0 ? Props.XDB_GATEWAY_PATH + Props.XDB_GATEWAY_PATH_SEPARATOR + stringArray[n] : stringArray[n];
                Process process = Runtime.getRuntime().exec(string);
                StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), null, null);
                StreamGobbler streamGobbler2 = new StreamGobbler(process.getErrorStream(), null, null);
                streamGobbler.start();
                streamGobbler2.start();
                processArray[n] = process;
                continue;
            }
            processArray[n] = null;
        }
        for (n = 0; n < processArray.length; ++n) {
            try {
                int n2;
                if (processArray[n] == null || (n2 = processArray[n].waitFor()) == 0 || this.force) continue;
                throw new IOException("Failed to execute command \"" + stringArray[n] + "\": exit code was " + n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Map<String, String> populateValueMap(NodeDBConnectionInfo nodeDBConnectionInfo, Map<String, String> map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(VAR_NODEHOST, nodeDBConnectionInfo.getDbHost());
        if (nodeDBConnectionInfo.getDbPort() > 0) {
            map.put(VAR_NODEPORT, "" + nodeDBConnectionInfo.getDbPort());
        }
        map.put(VAR_NODEDB, nodeDBConnectionInfo.getDbName());
        map.put(VAR_DBUSERNAME, nodeDBConnectionInfo.getDbUser());
        map.put(VAR_DBPASSWORD, nodeDBConnectionInfo.getDbPassword());
        for (Map.Entry entry : nodeDBConnectionInfo.getProperties().entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        map.put(VAR_PSQLUTILNAME, Props.XDB_PSQL_UTIL_NAME);
        return map;
    }
}

