/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.CommandLog;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.server.Server;
import com.edb.gridsql.util.DbGateway;
import com.edb.gridsql.util.ParseArgs;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class XdbServer {
    private static final XLogger logger = XLogger.getLogger(XdbServer.class);
    private static final String USAGE = "Parameters:  [-d database_list] [-x] [-m]\nwhere <database_list> is a space-separated list of Nodes to launch\n -x Start node databases -m Start Metadata database";

    private static void printUsage() {
        System.out.println(USAGE);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            if (Property.get((String)"log4j.configuration") != null && new File(Property.get((String)"log4j.configuration")).exists()) {
                PropertyConfigurator.configure((String)Property.get((String)"log4j.configuration"));
            } else if (new File("log4j.properties").exists()) {
                PropertyConfigurator.configure((String)"log4j.properties");
            } else {
                PropertyConfigurator.configure((Properties)Property.getProperties());
            }
            Map<String, List<String>> map = null;
            try {
                map = ParseArgs.parse(stringArray, "dmx");
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
                XdbServer.printUsage();
                System.exit(-1);
            }
            CommandLog.setAdditivity((boolean)false);
            boolean bl = map.containsKey("-x");
            boolean bl2 = map.containsKey("-m");
            if (bl2) {
                object = new DbGateway();
                ((DbGateway)object).startDbOnNodes(new HashMap<String, String>(), new NodeDBConnectionInfo[]{MetaData.getMetadataDBConnectionInfo()});
            }
            object = new Server();
            if (bl) {
                DbGateway dbGateway = new DbGateway();
                dbGateway.startDbOnNodes(new HashMap<String, String>(), ((Server)object).getNodeDBConnectionInfos((Collection<String>)map.get("-d")));
            }
            ((Server)object).initDatabases((Collection<String>)map.get("-d"));
            ((Server)object).open();
            new Thread((Runnable)object).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

