/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gss;

import com.edb.core.Logger;
import com.edb.core.PGStream;
import com.edb.gss.GSSCallbackHandler;
import com.edb.gss.GssAction;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class MakeGSS {
    public static void authenticate(PGStream pgStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, Logger logger) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" <=BE AuthenticationReqGSS");
        }
        Object result = null;
        if (jaasApplicationName == null) {
            jaasApplicationName = "pgjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
            lc.login();
            Subject sub = lc.getSubject();
            GssAction action = new GssAction(pgStream, host, user, password, kerberosServerName, logger);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

