/*
 * Decompiled with CFR 0.152.
 */
package com.edb.geometric;

import com.edb.geometric.PGpoint;
import com.edb.util.GT;
import com.edb.util.PGobject;
import com.edb.util.PGtokenizer;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGbox
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGbox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new PGpoint(x1, y1);
        this.point[1] = new PGpoint(x2, y2);
    }

    public PGbox(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGbox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGbox() {
        this.setType("box");
    }

    public void setValue(String value) throws SQLException {
        PGtokenizer t = new PGtokenizer(value, ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion of box failed: {0}.", value), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGbox) {
            PGbox p = (PGbox)obj;
            if (p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1])) {
                return true;
            }
            if (p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0])) {
                return true;
            }
            if (p.point[0].x == this.point[0].x && p.point[0].y == this.point[1].y && p.point[1].x == this.point[1].x && p.point[1].y == this.point[0].y) {
                return true;
            }
            if (p.point[0].x == this.point[1].x && p.point[0].y == this.point[0].y && p.point[1].x == this.point[0].x && p.point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        PGbox newPGbox = (PGbox)super.clone();
        if (newPGbox.point != null) {
            newPGbox.point = (PGpoint[])newPGbox.point.clone();
            for (int i = 0; i < newPGbox.point.length; ++i) {
                if (newPGbox.point[i] == null) continue;
                newPGbox.point[i] = (PGpoint)newPGbox.point[i].clone();
            }
        }
        return newPGbox;
    }

    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }
}

