/*
 * Decompiled with CFR 0.152.
 */
package com.edb.geometric;

import com.edb.geometric.PGpoint;
import com.edb.util.PGobject;
import com.edb.util.PGtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new PGpoint(t.getToken(p));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p = (PGpolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    public Object clone() throws CloneNotSupportedException {
        PGpolygon newPGpolygon = (PGpolygon)super.clone();
        if (newPGpolygon.points != null) {
            newPGpolygon.points = (PGpoint[])newPGpolygon.points.clone();
            for (int i = 0; i < newPGpolygon.points.length; ++i) {
                if (newPGpolygon.points[i] == null) continue;
                newPGpolygon.points[i] = (PGpoint)newPGpolygon.points[i].clone();
            }
        }
        return newPGpolygon;
    }

    public String getValue() {
        StringBuffer b = new StringBuffer();
        b.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

