/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.misc.Timer;
import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import jline.ConsoleReader;

class CmdLine {
    static boolean echoMode = false;
    static String inFileName = null;
    static boolean formatOutput = true;
    static String delim = "|";
    static boolean printTrailingDelimiter;
    static boolean useTimer;

    CmdLine() {
    }

    private static void printUsageAndExit() {
        System.out.println("Parameters:  <connect> [-e] [-t] [-f inputfile]\n\twhere <connect> is -j jdbc:edb://<host>:<port>/<database>?user=<username>&password=<password>\n\tor [-h <host>] [-s <port>] -d <database> -u <user> [-p <password>]\n\t-h <host> : Host name or IP address where XDBServer is running. Default is localhost\n\t-s <port> : XDBServer's port. Default is 6453\n\t-d <database> : Name of database to connect to.\n\t-u <user>, -p <password> : Login to the database\n\t-e : echo mode. Echos any statements as it executes them\n\t-t : has effect of SET OUPUT NORMAL\n\t-f : input file to be executed, instead of interactive mode\t-b : buffer command line history\t-a : print trailing delimiter\t-z : print query time");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        Map<String, List<String>> map = null;
        boolean bl = true;
        try {
            map = ParseArgs.parse(stringArray, "jhsdupetfbaz");
        }
        catch (Exception exception) {
            CmdLine.printUsageAndExit();
        }
        useTimer = map.containsKey("-z");
        echoMode = map.containsKey("-e");
        bl = map.containsKey("-b");
        if (map.containsKey("-t")) {
            formatOutput = false;
            delim = ";";
        }
        inFileName = ParseArgs.getStrArg(map, "f");
        printTrailingDelimiter = map.containsKey("-a");
        String string = "";
        String string2 = "";
        boolean bl2 = false;
        BufferedReader bufferedReader = null;
        Timer timer = new Timer();
        String string3 = "";
        ConsoleReader consoleReader = null;
        if (inFileName == null && bl) {
            try {
                System.out.flush();
                consoleReader = new ConsoleReader();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                bl = false;
                System.out.println("HISTORY COMMAND IS OFF (jline.jar is not found)");
                System.out.flush();
            }
        }
        try {
            Object object;
            Connection connection = Util.connect(map);
            if (connection == null) {
                throw new SQLException("Can not connect to server");
            }
            Statement statement = connection.createStatement();
            string = "";
            PrintWriter printWriter = new PrintWriter(System.out);
            if (inFileName != null) {
                object = new FileReader(inFileName);
                bufferedReader = new BufferedReader((Reader)object);
            } else if (bl) {
                consoleReader = new ConsoleReader();
            } else {
                bufferedReader = new BufferedReader(new InputStreamReader(System.in), 65536);
            }
            while (inFileName == null || inFileName != null && string != null) {
                string2 = "";
                string = "";
                System.out.println("");
                while (string != null && (string.indexOf(";") < 0 || string.startsWith("#") || string.startsWith("--"))) {
                    if (inFileName == null) {
                        System.out.print("GridSQL -> ");
                        string = bl ? consoleReader.readLine() : bufferedReader.readLine();
                    } else {
                        string = bufferedReader.readLine();
                    }
                    if (string != null && (string.startsWith("#") || string.startsWith("--"))) continue;
                    if (string2.length() > 0) {
                        string2 = string2 + " ";
                    }
                    string2 = string2 + string;
                }
                if (string == null || (string2 = string2.trim()).length() >= 4 && string2.toUpperCase().trim().substring(0, 4).compareTo("EXIT") == 0) break;
                if (echoMode) {
                    System.out.println(string2);
                }
                try {
                    if (string2.toUpperCase().matches("SET[ ]*OUTPUT[ ]*TABLE.*")) {
                        formatOutput = true;
                        delim = "|";
                        continue;
                    }
                    if (string2.toUpperCase().matches("SET[ ]*OUTPUT[ ]*NORMAL.*")) {
                        formatOutput = false;
                        delim = ";";
                        continue;
                    }
                    if (string2.toUpperCase().matches("BEGIN[ ]*BATCH.*")) {
                        bl2 = true;
                        continue;
                    }
                    if (string2.toUpperCase().matches("EXECUTE[ ]*BATCH.*")) {
                        bl2 = false;
                        if (useTimer) {
                            timer = new Timer();
                        }
                        object = statement.executeBatch();
                        if (useTimer) {
                            timer.stopTimer();
                        }
                        System.out.println("Batch Results:");
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            System.out.println(i + 1 + ": " + (int)object[i]);
                        }
                        if (!useTimer) continue;
                        System.out.println(" Response time: " + timer.getDuration());
                        continue;
                    }
                    if (bl2) {
                        statement.addBatch(string2);
                        continue;
                    }
                    if (string2.toUpperCase().matches("BEGIN.*")) {
                        connection.setAutoCommit(false);
                        continue;
                    }
                    if (string2.toUpperCase().matches("COMMIT.*") || string2.toUpperCase().matches("END.*")) {
                        connection.commit();
                        connection.setAutoCommit(true);
                        continue;
                    }
                    if (string2.toUpperCase().matches("ROLLBACK.*")) {
                        connection.rollback();
                        connection.setAutoCommit(true);
                        continue;
                    }
                    if (useTimer) {
                        timer = new Timer();
                    }
                    statement.setFetchSize(1000);
                    boolean bl3 = statement.execute(string2);
                    if (useTimer) {
                        timer.stopTimer();
                        string3 = " Response time: " + timer.getDuration();
                        timer.startTimer();
                    }
                    boolean bl4 = false;
                    while (true) {
                        if (bl3) {
                            ResultSet resultSet = statement.getResultSet();
                            try {
                                if (formatOutput) {
                                    Util.dumpRsTable(resultSet, printWriter, delim);
                                }
                                Util.dumpRs(resultSet, printWriter, delim, printTrailingDelimiter);
                            }
                            finally {
                                resultSet.close();
                            }
                        } else {
                            int n = statement.getUpdateCount();
                            if (n > 0) {
                                System.out.println(n + " row(s) affected");
                            } else {
                                if (n == 0 || !bl4) {
                                    System.out.println("OK");
                                }
                                if (n < 0) break;
                            }
                        }
                        bl3 = statement.getMoreResults();
                        bl4 = true;
                    }
                    if (!useTimer) continue;
                    timer.stopTimer();
                    System.out.println(string3 + "  Total time: " + timer.getDuration());
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().equals("08006")) {
                        System.out.println("SQLException: " + sQLException.getMessage());
                        for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                            System.out.println("Next SQLException: " + sQLException2.getMessage());
                        }
                        continue;
                    }
                    System.out.println("Connection error.");
                }
                catch (Exception exception) {
                    System.out.println("Exception: " + exception.getMessage());
                }
            }
            connection.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static {
        useTimer = false;
    }
}

