/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

public class ExecDb {
    private static Connection oConn;
    private static String commandString;

    private static void terminate(String string) {
        System.err.println(string);
        System.err.println("Parameters:  <connect> -c <command>\n\twhere <connect> is -j jdbc:edb://<host>:<port>/<database>?user=<username>&password=<password>\n\tor [-h <host>] [-s <port>] -d <database> -u <user> [-p <password>]\n\t-h <host> : Host name or IP address where XDBServer is running. Default is localhost\n\t-s <port> : XDBServer's port. Default is 6453\n\t-d <database> : Name of target database.\n\t-u <user>, -p <password> : Login to the database\n\t-c <command> : Command to be executed.");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = ParseArgs.parse(stringArray, "jhsdupc");
            commandString = ParseArgs.getStrArg(object, "-c");
            if (commandString == null || commandString.length() == 0) {
                ExecDb.terminate("No command specified");
            }
            oConn = Util.connect((Map<String, List<String>>)object, false);
        }
        catch (Exception exception) {
            ExecDb.terminate(exception.getMessage());
        }
        try {
            object = oConn.createStatement();
            String string = "EXEC DIRECT ON ALL '" + commandString + "'";
            PrintWriter printWriter = new PrintWriter(System.out);
            boolean bl = object.execute(string);
            while (true) {
                if (bl) {
                    Util.dumpRsTable(object.getResultSet(), printWriter, "|");
                } else {
                    int n = object.getUpdateCount();
                    if (n == -1) break;
                    if (n == -2) {
                        printWriter.println("OK");
                    } else {
                        printWriter.println(n + " row(s) affected");
                    }
                }
                bl = object.getMoreResults();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

