/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class XdbDbStart {
    private static void terminate(String string) {
        System.err.println(string);
        System.err.println("Parameters: <connect> -d <database> [-w <waittimeout>]\n\twhere <connect> is -j jdbc:edb://<host>:<port>/<database>?user=<username>&password=<password>\n\tor [-h <host>] [-s <port>] -d <database> -u <user> [-p <password>]\n\t-h <host> : Host name or IP address where XDBServer is running. Default is localhost\n\t-s <port> : XDBServer's port. Default is 6453\n\t-d <database> : Name of databases to start.\n\t-u <user>, -p <password> : Login to the database\n\t-w <waittimeout> : Timeout (seconds) to wait for database is online. Default is 60.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        Statement statement = null;
        String string = null;
        try {
            Map<String, List<String>> map = ParseArgs.parse(stringArray, "jhsdupw");
            String string2 = ParseArgs.getStrArg(map, "-d");
            String string3 = ParseArgs.getStrArg(map, "-w");
            connection = Util.connect(map, true);
            statement = connection.createStatement();
            string = "START DATABASE " + string2;
            if (string3 != null) {
                string = string + " WAITTIMEOUT " + string3;
            }
            statement.execute(string);
            System.out.println("Database(s) " + string2 + " started.");
        }
        catch (Exception exception) {
            if (string != null) {
                System.err.println("The following command was sent: " + string);
            }
            XdbDbStart.terminate(exception.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        System.exit(0);
    }
}

