/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.wrapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    private static final String prefix = "jdbc:wrapper";
    private static final String[] versions = new String[]{"4", "3", "2"};
    private static final Map driverPreload = new HashMap();
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$util$Properties;

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(prefix);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            throw new SQLException("Wrapper driver does not accept this URL:" + url);
        }
        int cut = url.indexOf(58, prefix.length());
        if (cut == -1) {
            throw new SQLException("Format: jdbc:wrapper:<your driver connection string>");
        }
        String driverConnURL = url.substring(cut);
        String wrapperParamsStr = url.substring(0, cut);
        Properties wrapperParams = this.extractWrapperParameters(wrapperParamsStr);
        Iterator iterator = driverPreload.keySet().iterator();
        while (iterator.hasNext()) {
            String wrappedDriverUrlPrefix = (String)iterator.next();
            if (!driverConnURL.startsWith(wrappedDriverUrlPrefix)) continue;
            String wrappedDriverClass = (String)driverPreload.get(wrappedDriverUrlPrefix);
            try {
                Class.forName(wrappedDriverClass);
            }
            catch (ClassNotFoundException e) {}
            break;
        }
        if (!driverConnURL.startsWith("jdbc")) {
            driverConnURL = "jdbc" + driverConnURL;
        }
        Connection wrappedConnection = DriverManager.getConnection(driverConnURL);
        for (int i = 0; i < versions.length; ++i) {
            try {
                return this.startWrapper(versions[i], wrappedConnection, wrapperParams);
            }
            catch (SecurityException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        throw new SQLException("No suitable Connection version found");
    }

    private final Properties extractWrapperParameters(String wrapperParamsStr) {
        Properties properties = new Properties();
        if (wrapperParamsStr.indexOf(91) == -1 || wrapperParamsStr.indexOf(93) == -1) {
            return properties;
        }
        StringTokenizer paramTokenizer = new StringTokenizer(wrapperParamsStr.substring(wrapperParamsStr.indexOf(91) + 1, wrapperParamsStr.indexOf(93) - 1), ";");
        while (paramTokenizer.hasMoreTokens()) {
            String propStr = paramTokenizer.nextToken();
            ((Hashtable)properties).put(propStr.substring(0, propStr.indexOf(61)), propStr.substring(propStr.indexOf(61) + 1));
        }
        return properties;
    }

    private Connection startWrapper(String version, Connection connection, Properties wrapperProperties) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> connectionClass = Class.forName("org.postgresql.wrapper.jdbc" + version + ".WrapperConnection");
        Constructor<?> constr = connectionClass.getConstructor(class$java$sql$Connection == null ? (class$java$sql$Connection = Driver.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$util$Properties == null ? (class$java$util$Properties = Driver.class$("java.util.Properties")) : class$java$util$Properties);
        return (Connection)constr.newInstance(connection, wrapperProperties);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[]{new DriverPropertyInfo("", "")};
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        driverPreload.put("jdbc:postgresql", "org.postgresql.Driver");
        driverPreload.put(":postgresql", "org.postgresql.Driver");
        driverPreload.put("jdbc:derby", "org.apache.derby.jdbc.EmbeddedDriver");
        driverPreload.put(":derby", "org.apache.derby.jdbc.EmbeddedDriver");
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

