/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.wrapper.jdbc2a;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.postgresql.wrapper.jdbc2a.AbstractWrapperPreparedStatement;
import org.postgresql.wrapper.jdbc2a.pool.Factory;
import org.postgresql.wrapper.jdbc2a.pool.Jdbc2PreparedStatementKey;
import org.postgresql.wrapper.jdbc2a.pool.PreparedStatementPool;

public abstract class AbstractWrapperConnection
implements Connection,
PreparedStatementPool,
Factory {
    protected final Connection connection;
    private HashMap preparedStatementPool = new HashMap();
    private int poolSize = 0;
    private int poolMax;

    public AbstractWrapperConnection(Connection connection, Properties wrapperProperties) {
        this.connection = connection;
        this.poolMax = Integer.parseInt(wrapperProperties.getProperty("preparedStatementCacheSize", "64"));
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.acquirePreparedStatement(new Jdbc2PreparedStatementKey(sql));
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public PreparedStatement acquirePreparedStatement(String sql) throws SQLException {
        return this.acquirePreparedStatement(new Jdbc2PreparedStatementKey(sql));
    }

    public PreparedStatement acquirePreparedStatement(Jdbc2PreparedStatementKey key) throws SQLException {
        PreparedStatement preparedStatement = this.doAcquirePreparedStatement(key);
        if (this.poolMax != -1 && this.poolSize > this.poolMax) {
            Jdbc2PreparedStatementKey candidateKey = null;
            int candidateSize = 0;
            Iterator iterator = this.preparedStatementPool.keySet().iterator();
            while (iterator.hasNext()) {
                Jdbc2PreparedStatementKey tmpKey = (Jdbc2PreparedStatementKey)iterator.next();
                if (candidateKey != null && ((LinkedList)this.preparedStatementPool.get(tmpKey)).size() <= candidateSize) continue;
                candidateKey = tmpKey;
                candidateSize = ((LinkedList)this.preparedStatementPool.get(tmpKey)).size();
            }
            LinkedList listForKey = (LinkedList)this.preparedStatementPool.get(candidateKey);
            if (candidateKey != null && !listForKey.isEmpty()) {
                AbstractWrapperPreparedStatement wrapperPreparedStatement = (AbstractWrapperPreparedStatement)listForKey.removeFirst();
                wrapperPreparedStatement.closeWrapped();
                --this.poolSize;
            }
        }
        return preparedStatement;
    }

    private PreparedStatement doAcquirePreparedStatement(Jdbc2PreparedStatementKey key) throws SQLException {
        LinkedList<PreparedStatement> listForKey = (LinkedList<PreparedStatement>)this.preparedStatementPool.get(key);
        if (listForKey == null) {
            listForKey = new LinkedList<PreparedStatement>();
            this.preparedStatementPool.put(key, listForKey);
            PreparedStatement wrappedStatement = this.connection.prepareStatement(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency());
            PreparedStatement wrappingStatement = this.createWrapperPreparedStatement(wrappedStatement, key);
            listForKey.add(wrappingStatement);
            return wrappingStatement;
        }
        if (listForKey.isEmpty()) {
            PreparedStatement wrappedStatement = this.connection.prepareStatement(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency());
            return this.createWrapperPreparedStatement(wrappedStatement, key);
        }
        PreparedStatement statement = (PreparedStatement)listForKey.removeFirst();
        --this.poolSize;
        return statement;
    }

    public PreparedStatement acquirePreparedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.acquirePreparedStatement(new Jdbc2PreparedStatementKey(sql, resultSetType, resultSetConcurrency));
    }

    public void releasePreparedStatement(PreparedStatement statement) {
        LinkedList<PreparedStatement> list = (LinkedList<PreparedStatement>)this.preparedStatementPool.get(((AbstractWrapperPreparedStatement)statement).key);
        if (list == null) {
            list = new LinkedList<PreparedStatement>();
            this.preparedStatementPool.put(((AbstractWrapperPreparedStatement)statement).key, list);
        }
        list.add(statement);
        ++this.poolSize;
    }
}

