/*
 * Decompiled with CFR 0.152.
 */
package mssql2pgsql;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class ColorRenderer
extends DefaultTableCellRenderer
implements ActionListener {
    private JTable table;
    private AbstractTableModel model;
    private Map colors;
    private boolean isBlinking = true;
    private Timer timer;
    private Point location;

    public ColorRenderer(JTable table) {
        this.table = table;
        this.model = (AbstractTableModel)table.getModel();
        this.colors = new HashMap();
        this.location = new Point();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (hasFocus || !this.isBlinking) {
            this.setBackground(table.getBackground());
        } else {
            this.setBackground(this.getCellColor(row, column));
        }
        return this;
    }

    public Color getCellColor(int row, int column) {
        Object key = this.getKey(row, column = this.table.convertColumnIndexToModel(column));
        Object o = this.colors.get(key);
        if (o != null) {
            return (Color)o;
        }
        key = this.getKey(row, -1);
        o = this.colors.get(key);
        if (o != null) {
            return (Color)o;
        }
        key = this.getKey(-1, column);
        o = this.colors.get(key);
        if (o != null) {
            return (Color)o;
        }
        return null;
    }

    public void setCellColor(int row, int column, Color color) {
        Point key = new Point(row, column);
        this.colors.put(key, color);
    }

    public void setColumnColor(int column, Color color) {
        this.setCellColor(-1, column, color);
    }

    public void setRowColor(int row, Color color) {
        this.setCellColor(row, -1, color);
    }

    private Object getKey(int row, int column) {
        this.location.x = row;
        this.location.y = column;
        return this.location;
    }

    public void startBlinking(int interval) {
        this.timer = new Timer(interval, this);
        this.timer.start();
    }

    public void stopBlinking() {
        this.timer.stop();
    }

    public void actionPerformed(ActionEvent e) {
        this.isBlinking = !this.isBlinking;
        for (Point key : this.colors.keySet()) {
            int row = key.x;
            int column = key.y;
            if (column == -1) {
                this.model.fireTableRowsUpdated(row, row);
                continue;
            }
            if (row == -1) {
                int rows = this.table.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    this.model.fireTableCellUpdated(i, column);
                }
                continue;
            }
            this.model.fireTableCellUpdated(row, column);
        }
    }
}

