/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.sourceforge.jtds.jdbc.CachedResultSet;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.JtdsResultSet;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.TypeInfo;

public class JtdsDatabaseMetaData
implements DatabaseMetaData {
    static final int sqlStateXOpen = 1;
    int tdsVersion;
    int serverType;
    ConnectionJDBC2 connection;
    int sysnameLength = 30;
    Boolean caseSensitive = null;

    public JtdsDatabaseMetaData(ConnectionJDBC2 connection) {
        this.connection = connection;
        this.tdsVersion = connection.getTdsVersion();
        this.serverType = connection.getServerType();
        if (this.tdsVersion >= 3) {
            this.sysnameLength = 128;
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.connection.getServerType() == 1;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String[] colNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] colTypes = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        String query = "sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "R");
        s.setString(5, "T");
        s.setString(6, "U");
        s.setInt(7, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        int colCnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            int i = 1;
            while (i <= colCnt) {
                if (i == 3) {
                    int type = TypeInfo.normalizeDataType(rs.getInt(i));
                    rsTmp.updateInt(i, type);
                } else {
                    rsTmp.updateObject(i, rs.getObject(i));
                }
                ++i;
            }
            rsTmp.insertRow();
        }
        rs.close();
        s.close();
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        return rsTmp;
    }

    public ResultSet getCatalogs() throws SQLException {
        String query = "exec sp_tables '', '', '%', NULL";
        Statement s = this.connection.createStatement();
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery(query);
        rs.setColumnCount(1);
        rs.setColLabel(1, "TABLE_CAT");
        JtdsDatabaseMetaData.upperCaseColumnNames(rs);
        return rs;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String query = "sp_column_privileges ?, ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColLabel(2, "TABLE_SCHEM");
        JtdsDatabaseMetaData.upperCaseColumnNames(rs);
        return rs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String[] colNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] colTypes = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5};
        String query = "sp_columns ?, ?, ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        s.setInt(5, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColumnCount(18);
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        int colCnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            int i;
            if (this.serverType == 2) {
                i = 1;
                while (i <= 4) {
                    rsTmp.updateObject(i, rs.getObject(i));
                    ++i;
                }
                rsTmp.updateInt(5, TypeInfo.normalizeDataType(rs.getInt(5)));
                String typeName = rs.getString(6);
                rsTmp.updateString(6, typeName);
                int i2 = 8;
                while (i2 <= 12) {
                    rsTmp.updateObject(i2, rs.getObject(i2));
                    ++i2;
                }
                if (colCnt >= 20) {
                    rsTmp.updateObject(13, rs.getObject(15));
                    rsTmp.updateObject(16, rs.getObject(18));
                    rsTmp.updateObject(17, rs.getObject(17));
                    rsTmp.updateObject(18, rs.getObject(20));
                } else {
                    rsTmp.updateObject(17, rs.getObject(14));
                    rsTmp.updateObject(16, rs.getObject(8));
                }
                if (typeName.equals("image") || typeName.equals("text")) {
                    rsTmp.updateInt(7, Integer.MAX_VALUE);
                    rsTmp.updateInt(16, Integer.MAX_VALUE);
                } else if (typeName.equals("univarchar") || typeName.equals("unichar")) {
                    rsTmp.updateInt(7, rs.getInt(7) / 2);
                    rsTmp.updateObject(16, rs.getObject(7));
                } else {
                    rsTmp.updateInt(7, rs.getInt(7));
                }
            } else {
                i = 1;
                while (i <= colCnt) {
                    if (i == 5) {
                        int type = TypeInfo.normalizeDataType(rs.getInt(i));
                        rsTmp.updateInt(i, type);
                    } else {
                        rsTmp.updateObject(i, rs.getObject(i));
                    }
                    ++i;
                }
            }
            rsTmp.insertRow();
        }
        rs.close();
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        return rsTmp;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String[] colNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] colTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        String query = "sp_fkeys ?, ?, ?, ?, ?, ?";
        if (primaryCatalog != null) {
            query = this.syscall(primaryCatalog, query);
        } else if (foreignCatalog != null) {
            query = this.syscall(foreignCatalog, query);
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, primaryTable);
        s.setString(2, primarySchema);
        s.setString(3, primaryCatalog);
        s.setString(4, foreignTable);
        s.setString(5, foreignSchema);
        s.setString(6, foreignCatalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        int colCnt = rs.getMetaData().getColumnCount();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        while (rs.next()) {
            int i = 1;
            while (i <= colCnt) {
                rsTmp.updateObject(i, rs.getObject(i));
                ++i;
            }
            if (colCnt < 14) {
                rsTmp.updateShort(14, (short)7);
            }
            rsTmp.insertRow();
        }
        rs.close();
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        return rsTmp;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.connection.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDatabaseProductVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public String getDriverName() throws SQLException {
        return "jTDS Type 4 JDBC Driver for MS SQL Server and Sybase";
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getVersion();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(catalog, schema, table, null, null, null);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$#@";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(null, null, null, catalog, schema, table);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String[] colNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] colTypes = new int[]{12, 12, 12, -7, 12, 12, 5, 5, 12, 12, 4, 4, 12};
        String query = "sp_statistics ?, ?, ?, ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "%");
        s.setString(5, unique ? "Y" : "N");
        s.setString(6, approximate ? "Q" : "E");
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        int colCnt = rs.getMetaData().getColumnCount();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        while (rs.next()) {
            int i = 1;
            while (i <= colCnt) {
                rsTmp.updateObject(i, rs.getObject(i));
                ++i;
            }
            rsTmp.insertRow();
        }
        rs.close();
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        return rsTmp;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.tdsVersion >= 3 ? 0 : 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.tdsVersion >= 3 ? 0 : 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.tdsVersion >= 3 ? 1024 : 250;
    }

    public int getMaxConnections() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxIndexLength() throws SQLException {
        return this.tdsVersion >= 3 ? 900 : 255;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxRowSize() throws SQLException {
        return this.tdsVersion >= 3 ? 8060 : 1962;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.tdsVersion > 2 ? 256 : 16;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan";
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String[] colNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] colTypes = new int[]{12, 12, 12, 12, 5, 12};
        String query = "sp_pkeys ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        int colCnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            int i = 1;
            while (i <= colCnt) {
                rsTmp.updateObject(i, rs.getObject(i));
                ++i;
            }
            rsTmp.insertRow();
        }
        rs.close();
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        return rsTmp;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String[] colNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
        int[] colTypes = new int[]{12, 12, 12, 12, 5, 4, 12, 4, 4, 5, 5, 5, 12};
        String query = "sp_sproc_columns ?, ?, ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, procedureNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        s.setInt(5, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        while (rs.next()) {
            int offset = 0;
            int i = 1;
            while (i + offset <= colNames.length) {
                if (i == 5 && !rsmd.getColumnName(i).equalsIgnoreCase("column_type")) {
                    rsTmp.updateInt(i, 0);
                    offset = 1;
                }
                if (i == 3) {
                    int pos;
                    String name = rs.getString(i);
                    if (name != null && name.length() > 0 && (pos = name.lastIndexOf(59)) >= 0) {
                        name = name.substring(0, pos);
                    }
                    rsTmp.updateString(i + offset, name);
                } else if (rsmd.getColumnName(i).equalsIgnoreCase("data_type")) {
                    int type = TypeInfo.normalizeDataType(rs.getInt(i));
                    rsTmp.updateInt(i + offset, type);
                } else {
                    rsTmp.updateObject(i + offset, rs.getObject(i));
                }
                ++i;
            }
            rsTmp.insertRow();
        }
        rs.close();
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        return rsTmp;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String[] colNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVED_1", "RESERVED_2", "RESERVED_3", "REMARKS", "PROCEDURE_TYPE"};
        int[] colTypes = new int[]{12, 12, 12, 4, 4, 4, 12, 5};
        String query = "sp_stored_procedures ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, procedureNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        int colCnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            rsTmp.updateString(1, rs.getString(1));
            rsTmp.updateString(2, rs.getString(2));
            String name = rs.getString(3);
            if (name != null && name.endsWith(";1")) {
                name = name.substring(0, name.length() - 2);
            }
            rsTmp.updateString(3, name);
            int i = 4;
            while (i <= colCnt) {
                rsTmp.updateObject(i, rs.getObject(i));
                ++i;
            }
            if (colCnt < 8) {
                rsTmp.updateShort(8, (short)2);
            }
            rsTmp.insertRow();
        }
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        rs.close();
        return rsTmp;
    }

    public String getProcedureTerm() throws SQLException {
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        String sql = Driver.JDBC3 ? "SELECT name AS TABLE_SCHEM, NULL as TABLE_CATALOG FROM dbo.sysusers" : "SELECT name AS TABLE_SCHEM FROM dbo.sysusers";
        sql = this.tdsVersion >= 3 ? sql + " WHERE islogin=1" : sql + " WHERE uid>0";
        sql = sql + " ORDER BY TABLE_SCHEM";
        return statement.executeQuery(sql);
    }

    public String getSchemaTerm() throws SQLException {
        return "owner";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "ARITH_OVERFLOW,BREAK,BROWSE,BULK,CHAR_CONVERT,CHECKPOINT,CLUSTERED,COMPUTE,CONFIRM,CONTROLROW,DATA_PGS,DATABASE,DBCC,DISK,DUMMY,DUMP,ENDTRAN,ERRLVL,ERRORDATA,ERROREXIT,EXIT,FILLFACTOR,HOLDLOCK,IDENTITY_INSERT,IF,INDEX,KILL,LINENO,LOAD,MAX_ROWS_PER_PAGE,MIRROR,MIRROREXIT,NOHOLDLOCK,NONCLUSTERED,NUMERIC_TRUNCATION,OFF,OFFSETS,ONCE,ONLINE,OVER,PARTITION,PERM,PERMANENT,PLAN,PRINT,PROC,PROCESSEXIT,RAISERROR,READ,READTEXT,RECONFIGURE,REPLACE,RESERVED_PGS,RETURN,ROLE,ROWCNT,ROWCOUNT,RULE,SAVE,SETUSER,SHARED,SHUTDOWN,SOME,STATISTICS,STRIPE,SYB_IDENTITY,SYB_RESTREE,SYB_TERMINATE,TEMP,TEXTSIZE,TRAN,TRIGGER,TRUNCATE,TSEQUAL,UNPARTITION,USE,USED_PGS,USER_OPTION,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLException {
        if (this.connection.getServerType() == 1) {
            return "ascii,char,concat,difference,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,soundex,space,substring,ucase";
        }
        return "ascii,char,concat,difference,insert,lcase,length,ltrim,repeat,right,rtrim,soundex,space,substring,ucase";
    }

    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user,convert";
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String query = "sp_table_privileges ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColLabel(2, "TABLE_SCHEM");
        JtdsDatabaseMetaData.upperCaseColumnNames(rs);
        return rs;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String[] colNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
        int[] colTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        String query = "sp_tables ?, ?, ?, ?";
        CallableStatement cstmt = this.connection.prepareCall(this.syscall(catalog, query));
        cstmt.setString(1, tableNamePattern);
        cstmt.setString(2, schemaPattern);
        cstmt.setString(3, catalog);
        if (types == null) {
            cstmt.setString(4, null);
        } else {
            StringBuffer buf = new StringBuffer(64);
            buf.append('\"');
            int i = 0;
            while (i < types.length) {
                buf.append('\'').append(types[i]).append("',");
                ++i;
            }
            if (buf.length() > 1) {
                buf.setLength(buf.length() - 1);
            }
            buf.append('\"');
            cstmt.setString(4, buf.toString());
        }
        JtdsResultSet rs = (JtdsResultSet)cstmt.executeQuery();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)cstmt), colNames, colTypes);
        rsTmp.moveToInsertRow();
        int colCnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            int i = 1;
            while (i <= colCnt) {
                rsTmp.updateObject(i, rs.getObject(i));
                ++i;
            }
            rsTmp.insertRow();
        }
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        rs.close();
        return rsTmp;
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = "select 'SYSTEM TABLE' TABLE_TYPE union select 'TABLE' TABLE_TYPE union select 'VIEW' TABLE_TYPE order by TABLE_TYPE";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(sql);
    }

    public String getTimeDateFunctions() throws SQLException {
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,timestampadd,timestampdiff,second,week,year";
    }

    public ResultSet getTypeInfo() throws SQLException {
        CachedResultSet cachedResultSet;
        JtdsResultSet rs;
        Statement s = this.connection.createStatement();
        try {
            rs = (JtdsResultSet)s.executeQuery("exec sp_datatype_info @ODBCVer=3");
        }
        catch (SQLException ex) {
            s.close();
            throw ex;
        }
        try {
            cachedResultSet = JtdsDatabaseMetaData.createTypeInfoResultSet(rs);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
        return cachedResultSet;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String[] colNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        int[] colTypes = new int[]{12, 12, 12, 12, 4, 12, 5};
        JtdsStatement dummyStmt = (JtdsStatement)this.connection.createStatement();
        CachedResultSet rs = new CachedResultSet(dummyStmt, colNames, colTypes);
        rs.setConcurrency(1007);
        return rs;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        String result;
        Statement s;
        block6: {
            s = null;
            ResultSet rs = null;
            result = "";
            try {
                s = this.connection.createStatement();
                rs = this.connection.getServerType() == 2 ? s.executeQuery("select suser_name()") : s.executeQuery("select system_user");
                if (!rs.next()) {
                    throw new SQLException(Messages.get("error.dbmeta.nouser"), "HY000");
                }
                result = rs.getString(1);
                Object var5_4 = null;
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (rs != null) {
                    rs.close();
                }
                if (s != null) {
                    s.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (s != null) {
            s.close();
        }
        return result;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String[] colNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] colTypes = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        String query = "sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        CallableStatement s = this.connection.prepareCall(this.syscall(catalog, query));
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "V");
        s.setString(5, "C");
        s.setString(6, "O");
        s.setInt(7, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        CachedResultSet rsTmp = new CachedResultSet((JtdsStatement)((Object)s), colNames, colTypes);
        rsTmp.moveToInsertRow();
        int colCnt = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            int i = 1;
            while (i <= colCnt) {
                rsTmp.updateObject(i, rs.getObject(i));
                ++i;
            }
            rsTmp.insertRow();
        }
        rsTmp.moveToCurrentRow();
        rsTmp.setConcurrency(1007);
        rs.close();
        return rsTmp;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (fromType == toType) {
            return true;
        }
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return toType != -1 && toType != -4 && toType != 2004 && toType != 2005;
            }
            case -3: 
            case -2: {
                return toType != 6 && toType != 7 && toType != 8;
            }
            case -4: 
            case 2004: {
                return toType == -2 || toType == -3 || toType == 2004 || toType == -4;
            }
            case -1: 
            case 2005: {
                return toType == 1 || toType == 12 || toType == 2005 || toType == -1;
            }
            case 0: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        if (this.connection.getServerType() == 2) {
            return this.getDatabaseMajorVersion() >= 12;
        }
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.connection.getServerType() == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return true;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return type == 1005;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    private void setCaseSensitiveFlag() throws SQLException {
        if (this.caseSensitive == null) {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("sp_server_info 16");
            rs.next();
            this.caseSensitive = rs.getString(3).equalsIgnoreCase("MIXED") ? Boolean.FALSE : Boolean.TRUE;
            s.close();
        }
    }

    public ResultSet getAttributes(String str, String str1, String str2, String str3) throws SQLException {
        String[] colNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] colTypes = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5};
        JtdsStatement dummyStmt = (JtdsStatement)this.connection.createStatement();
        CachedResultSet rs = new CachedResultSet(dummyStmt, colNames, colTypes);
        rs.setConcurrency(1007);
        return rs;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getDatabaseMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getDatabaseMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public ResultSet getSuperTables(String str, String str1, String str2) throws SQLException {
        String[] colNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        int[] colTypes = new int[]{12, 12, 12, 12};
        JtdsStatement dummyStmt = (JtdsStatement)this.connection.createStatement();
        CachedResultSet rs = new CachedResultSet(dummyStmt, colNames, colTypes);
        rs.setConcurrency(1007);
        return rs;
    }

    public ResultSet getSuperTypes(String str, String str1, String str2) throws SQLException {
        String[] colNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        int[] colTypes = new int[]{12, 12, 12, 12, 12, 12};
        JtdsStatement dummyStmt = (JtdsStatement)this.connection.createStatement();
        CachedResultSet rs = new CachedResultSet(dummyStmt, colNames, colTypes);
        rs.setConcurrency(1007);
        return rs;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsResultSetHoldability(int param) throws SQLException {
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    private String syscall(String catalog, String call) {
        StringBuffer sql = new StringBuffer();
        sql.append("{call ");
        if (catalog != null) {
            if (this.tdsVersion >= 3) {
                sql.append('[').append(catalog).append(']');
            } else {
                sql.append(catalog);
            }
            sql.append("..");
        }
        sql.append(call).append('}');
        return sql.toString();
    }

    private static void upperCaseColumnNames(JtdsResultSet results) throws SQLException {
        ResultSetMetaData rsmd = results.getMetaData();
        int cnt = rsmd.getColumnCount();
        int i = 1;
        while (i <= cnt) {
            String name = rsmd.getColumnLabel(i);
            if (name != null && name.length() > 0) {
                results.setColLabel(i, name.toUpperCase());
            }
            ++i;
        }
    }

    private static CachedResultSet createTypeInfoResultSet(JtdsResultSet rs) throws SQLException {
        CachedResultSet result = new CachedResultSet(rs);
        result.setColumnCount(18);
        result.setColLabel(3, "PRECISION");
        result.setColLabel(11, "FIXED_PREC_SCALE");
        JtdsDatabaseMetaData.upperCaseColumnNames(result);
        result.moveToInsertRow();
        Iterator iter = JtdsDatabaseMetaData.getSortedTypes(rs).iterator();
        while (iter.hasNext()) {
            TypeInfo ti = (TypeInfo)iter.next();
            ti.update(result);
            result.insertRow();
        }
        result.moveToCurrentRow();
        result.setConcurrency(1007);
        return result;
    }

    private static Collection getSortedTypes(ResultSet rs) throws SQLException {
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(40);
        while (rs.next()) {
            types.add(new TypeInfo(rs));
        }
        Collections.sort(types);
        return types;
    }
}

