/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.ssl.TdsTlsInputStream;
import net.sourceforge.jtds.ssl.TdsTlsSocket;
import net.sourceforge.jtds.ssl.Util;
import net.sourceforge.jtds.util.Logger;

public class SocketFactories {
    public static SocketFactory getSocketFactory(String ssl, String instance) {
        return new TdsTlsSocketFactory(ssl, instance);
    }

    private static boolean requestEncryption(Socket socket, String instance) throws IOException {
        byte[] buf = new byte[instance.length() + 39];
        buf[2] = 26;
        buf[4] = 6;
        buf[5] = 1;
        buf[7] = 32;
        buf[9] = 1;
        buf[10] = 2;
        buf[12] = 33;
        buf[14] = (byte)(instance.length() + 1);
        buf[15] = 3;
        buf[17] = (byte)(instance.length() + 34);
        buf[19] = 4;
        buf[20] = 4;
        buf[22] = (byte)(instance.length() + 38);
        buf[24] = 1;
        buf[25] = -1;
        buf[26] = 9;
        System.arraycopy(instance.getBytes(), 0, buf, 33, instance.length());
        buf[32 + instance.length()] = 1;
        buf[34 + instance.length()] = -60;
        buf[35 + instance.length()] = 15;
        buf[38 + instance.length()] = 1;
        Util.putPacket(socket.getOutputStream(), buf);
        int read = new TdsTlsInputStream(socket.getInputStream()).read(buf);
        if (read < 29) {
            throw new EOFException("Server returned " + read + " bytes; expected " + 29);
        }
        return buf[(buf[2] & 0xFF) + 6] != 2;
    }

    static /* synthetic */ boolean access$000(Socket x0, String x1) throws IOException {
        return SocketFactories.requestEncryption(x0, x1);
    }

    private static class TdsTlsSocketFactory
    extends SocketFactory {
        private String ssl;
        private String instance;
        private static SSLSocketFactory factorySingleton;

        public TdsTlsSocketFactory(String ssl, String instance) {
            this.ssl = ssl;
            this.instance = instance;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.createSocket(new Socket(host, port));
        }

        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.createSocket(host.getHostName(), port);
        }

        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.createSocket(new Socket(host, port, localHost, localPort));
        }

        public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.createSocket(host.getHostName(), port, localHost, localPort);
        }

        private Socket createSocket(Socket socket) throws IOException {
            boolean sslOK = SocketFactories.requestEncryption(socket, this.instance);
            if (!sslOK) {
                if (this.ssl.equals("request")) {
                    return socket;
                }
                throw new IOException(Messages.get("error.ssl.encryptionoff"));
            }
            SSLSocket tlsSocket = (SSLSocket)this.getFactory().createSocket(new TdsTlsSocket(socket), socket.getInetAddress().getHostName(), socket.getPort(), true);
            tlsSocket.startHandshake();
            return tlsSocket;
        }

        private SSLSocketFactory getFactory() throws IOException {
            try {
                if (this.ssl.equals("authenticate")) {
                    return (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                return TdsTlsSocketFactory.factory();
            }
            catch (GeneralSecurityException e) {
                Logger.logException(e);
                throw new IOException(e.getMessage());
            }
        }

        private static SSLSocketFactory factory() throws NoSuchAlgorithmException, KeyManagementException {
            if (factorySingleton == null) {
                SSLContext ctx = SSLContext.getInstance((String)"TLS");
                ctx.init(null, TdsTlsSocketFactory.trustManagers(), null);
                factorySingleton = ctx.getSocketFactory();
            }
            return factorySingleton;
        }

        private static TrustManager[] trustManagers() {
            X509TrustManager tm = new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                public boolean isClientTrusted(X509Certificate[] chain) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] chain) {
                    return true;
                }
            };
            return new X509TrustManager[]{tm};
        }
    }
}

