/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.jdbc2.TimestampUtils;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AbstractJdbc2Array {
    private BaseConnection conn = null;
    private Field field = null;
    private BaseResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public AbstractJdbc2Array(BaseConnection conn, int idx, Field field, BaseResultSet rs) throws SQLException {
        this.conn = conn;
        this.field = field;
        this.rs = rs;
        this.idx = idx;
        this.rawString = rs.getFixedString(idx);
    }

    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    public Object getArrayImpl(long index, int count, Map map) throws SQLException {
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
        }
        Object[] retVal = null;
        ArrayList<String> array = new ArrayList<String>();
        if (this.rawString != null && !this.rawString.equals("{}")) {
            char[] chars = this.rawString.toCharArray();
            StringBuffer sbuf = new StringBuffer();
            boolean foundOpen = false;
            boolean insideString = false;
            int startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            for (int i = startOffset; i < chars.length; ++i) {
                if (chars[i] == '\\') {
                    ++i;
                } else {
                    if (!insideString && chars[i] == '{') {
                        if (foundOpen) {
                            throw new PSQLException("Multi-dimensional arrays are currently not supported.");
                        }
                        foundOpen = true;
                        continue;
                    }
                    if (chars[i] == '\"') {
                        insideString = !insideString;
                        continue;
                    }
                    if (!insideString && (chars[i] == ',' || chars[i] == '}') || i == chars.length - 1) {
                        if (chars[i] != '\"' && chars[i] != '}' && chars[i] != ',') {
                            sbuf.append(chars[i]);
                        }
                        array.add(sbuf.toString());
                        sbuf = new StringBuffer();
                        continue;
                    }
                }
                sbuf.append(chars[i]);
            }
        }
        String[] arrayContents = array.toArray(new String[array.size()]);
        if (count == 0) {
            count = arrayContents.length;
        }
        if (--index + (long)count > (long)arrayContents.length) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(arrayContents.length)}), PSQLState.DATA_ERROR);
        }
        int i = 0;
        switch (this.getBaseType()) {
            case -7: {
                retVal = new boolean[count];
                while (count > 0) {
                    retVal[i++] = AbstractJdbc2ResultSet.toBoolean(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                retVal = new int[count];
                while (count > 0) {
                    ((int[])retVal)[i++] = AbstractJdbc2ResultSet.toInt(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case -5: {
                retVal = new long[count];
                while (count > 0) {
                    ((long[])retVal)[i++] = AbstractJdbc2ResultSet.toLong(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 2: {
                retVal = new BigDecimal[count];
                while (count > 0) {
                    ((BigDecimal[])retVal)[i++] = AbstractJdbc2ResultSet.toBigDecimal(arrayContents[(int)index++], -1);
                    --count;
                }
                break;
            }
            case 7: {
                retVal = new float[count];
                while (count > 0) {
                    ((float[])retVal)[i++] = AbstractJdbc2ResultSet.toFloat(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 8: {
                retVal = new double[count];
                while (count > 0) {
                    ((double[])retVal)[i++] = AbstractJdbc2ResultSet.toDouble(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 1: 
            case 12: {
                retVal = new String[count];
                while (count > 0) {
                    ((String[])retVal)[i++] = arrayContents[(int)index++];
                    --count;
                }
                break;
            }
            case 91: {
                retVal = new Date[count];
                while (count > 0) {
                    ((Date[])retVal)[i++] = AbstractJdbc2ResultSet.toDate(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 92: {
                retVal = new Time[count];
                while (count > 0) {
                    ((Time[])retVal)[i++] = TimestampUtils.toTime(arrayContents[(int)index++], this.getBaseTypeName());
                    --count;
                }
                break;
            }
            case 93: {
                retVal = new Timestamp[count];
                while (count > 0) {
                    ((Timestamp[])retVal)[i++] = TimestampUtils.toTimestamp(arrayContents[(int)index++], this.getBaseTypeName());
                    --count;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return retVal;
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String fType = this.conn.getPGType(this.field.getOID());
        if (fType.charAt(0) == '_') {
            fType = fType.substring(1);
        }
        return fType;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    public ResultSet getResultSetImpl(Map map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public ResultSet getResultSetImpl(long index, int count, Map map) throws SQLException {
        Object array = this.getArrayImpl(index, count, map);
        Vector<byte[][]> rows = new Vector<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field("INDEX", 21, 2);
        switch (this.getBaseType()) {
            case -7: {
                boolean[] booleanArray = (boolean[])array;
                fields[1] = new Field("VALUE", 16, 1);
                for (int i = 0; i < booleanArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(booleanArray[i] ? "YES" : "NO");
                    rows.addElement(tuple);
                }
            }
            case 5: {
                fields[1] = new Field("VALUE", 21, 2);
            }
            case 4: {
                int[] intArray = (int[])array;
                if (fields[1] == null) {
                    fields[1] = new Field("VALUE", 23, 4);
                }
                for (int i = 0; i < intArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Integer.toString(intArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case -5: {
                long[] longArray = (long[])array;
                fields[1] = new Field("VALUE", 20, 8);
                for (int i = 0; i < longArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Long.toString(longArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field("VALUE", 1700, -1);
                for (int i = 0; i < bdArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(bdArray[i].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 7: {
                float[] floatArray = (float[])array;
                fields[1] = new Field("VALUE", 700, 4);
                for (int i = 0; i < floatArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Float.toString(floatArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 8: {
                double[] doubleArray = (double[])array;
                fields[1] = new Field("VALUE", 701, 8);
                for (int i = 0; i < doubleArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Double.toString(doubleArray[i]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 1: {
                fields[1] = new Field("VALUE", 1042, 1);
            }
            case 12: {
                String[] strArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field("VALUE", 1043, -1);
                }
                for (int i = 0; i < strArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(strArray[i]);
                    rows.addElement(tuple);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                fields[1] = new Field("VALUE", 1082, 4);
                for (int i = 0; i < dateArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(dateArray[i].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array;
                fields[1] = new Field("VALUE", 1083, 8);
                for (int i = 0; i < timeArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(timeArray[i].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field("VALUE", 1114, 8);
                for (int i = 0; i < timestampArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(timestampArray[i].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        BaseStatement stat = (BaseStatement)this.conn.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public String toString() {
        return this.rawString;
    }
}

