/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.ResultWrapper;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Statement
implements BaseStatement {
    protected ArrayList batchStatements = null;
    protected ArrayList batchParameters = null;
    protected final int resultsettype;
    protected final int concurrency;
    protected int fetchdirection = 1000;
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected ResultWrapper firstUnclosedResult = null;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTERJOIN = 5;
    private StringBuffer sbuf = new StringBuffer(32);
    protected final Query preparedQuery;
    protected final ParameterList preparedParameters;
    protected int m_prepareThreshold;
    protected int m_useCount = 0;
    private boolean isFunction;
    private int functionReturnType;
    private int testReturn;
    private boolean returnTypeSet;
    protected Object callResult;
    protected int maxfieldSize = 0;
    private boolean isClosed = false;

    public ResultSet createDriverResultSet(Field[] fields, Vector tuples) throws SQLException {
        return this.createResultSet(null, fields, tuples, null);
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection c, int rsType, int rsConcurrency) throws SQLException {
        this.connection = c;
        this.preparedQuery = null;
        this.preparedParameters = null;
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency) throws SQLException {
        this.connection = connection;
        String parsed_sql = this.replaceProcessing(sql);
        if (isCallable) {
            parsed_sql = this.modifyJdbcCall(parsed_sql);
        }
        this.preparedQuery = connection.getQueryExecutor().createParameterizedQuery(parsed_sql);
        this.preparedParameters = this.preparedQuery.createParameterList();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
    }

    public abstract ResultSet createResultSet(Query var1, Field[] var2, Vector var3, ResultCursor var4) throws SQLException;

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    public ResultSet executeQuery(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can't use query methods that take a query string on a PreparedStatement."));
        }
        if (!this.executeWithFlags(p_sql, 0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."));
        }
        return this.result.getResultSet();
    }

    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new PSQLException(GT.tr("Multiple ResultSets were returned by the query."));
        }
        return this.result.getResultSet();
    }

    public int executeUpdate(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can't use query methods that take a query string on a PreparedStatement."));
        }
        if (this.executeWithFlags(p_sql, 4)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."));
        }
        return this.getUpdateCount();
    }

    public int executeUpdate() throws SQLException {
        if (this.executeWithFlags(4)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."));
        }
        return this.getUpdateCount();
    }

    public boolean execute(String p_sql) throws SQLException {
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can't use query methods that take a query string on a PreparedStatement."));
        }
        return this.executeWithFlags(p_sql, 0);
    }

    public boolean executeWithFlags(String p_sql, int flags) throws SQLException {
        this.checkClosed();
        p_sql = this.replaceProcessing(p_sql);
        Query simpleQuery = this.connection.getQueryExecutor().createSimpleQuery(p_sql);
        this.execute(simpleQuery, null, 1 | flags);
        return this.result != null && this.result.getResultSet() != null;
    }

    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    public boolean executeWithFlags(int flags) throws SQLException {
        this.checkClosed();
        if (this.isFunction && !this.returnTypeSet) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.execute(this.preparedQuery, this.preparedParameters, flags);
        if (this.isFunction) {
            if (this.result == null || this.result.getResultSet() == null) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            ResultSet rs = this.result.getResultSet();
            if (!rs.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned."), PSQLState.NO_DATA);
            }
            this.callResult = rs.getObject(1);
            int columnType = rs.getMetaData().getColumnType(1);
            if (columnType != this.functionReturnType) {
                throw new PSQLException(GT.tr("A CallableStatement function was executed and the return was of type {0} however type {1} was registered.", new Object[]{"java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType}), PSQLState.DATA_TYPE_MISMATCH);
            }
            rs.close();
            this.result = null;
            return false;
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    protected void execute(Query queryToExecute, ParameterList queryParameters, int flags) throws SQLException {
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.fetchSize > 0 && !this.wantsScrollableResultSet() && !this.connection.getAutoCommit()) {
            flags |= 8;
        }
        if (this.preparedQuery != null) {
            ++this.m_useCount;
            if (this.m_prepareThreshold == 0 || this.m_useCount < this.m_prepareThreshold) {
                flags |= 1;
            }
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        StatementResultHandler handler = new StatementResultHandler();
        this.result = null;
        this.connection.getQueryExecutor().execute(queryToExecute, queryParameters, (ResultHandler)handler, this.maxrows, this.fetchSize, flags);
        this.result = this.firstUnclosedResult = handler.getResults();
    }

    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return -1;
        }
        if (this.isFunction) {
            return 1;
        }
        if (this.result.getResultSet() != null) {
            return -1;
        }
        return this.result.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        while (this.firstUnclosedResult != this.result) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0."));
        }
        this.maxrows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw new PSQLException(GT.tr("Query timeout must be a value greater than or equals to 0."));
        }
        this.timeout = seconds;
    }

    public void addWarning(SQLWarning warn) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warn);
        } else {
            this.warnings = warn;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0."));
        }
        this.maxfieldSize = max;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return null;
        }
        return this.result.getResultSet();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        if (this.preparedQuery != null) {
            this.preparedQuery.close();
        }
        this.firstUnclosedResult = null;
        this.result = null;
        this.isClosed = true;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String replaceProcessing(String p_sql) {
        if (this.replaceProcessingEnabled) {
            StringBuffer newsql = new StringBuffer(p_sql.length());
            int state = 0;
            int i = -1;
            int len = p_sql.length();
            while (++i < len) {
                char c = p_sql.charAt(i);
                switch (state) {
                    case 0: {
                        if (c == '\'') {
                            state = 1;
                        } else if (c == '{' && i + 1 < len) {
                            char nextnext;
                            char next = p_sql.charAt(i + 1);
                            char c2 = nextnext = i + 2 < len ? p_sql.charAt(i + 2) : (char)'\u0000';
                            if (next == 'd' || next == 'D') {
                                state = 3;
                                ++i;
                                break;
                            }
                            if (next == 't' || next == 'T') {
                                state = 3;
                                i += nextnext == 's' || nextnext == 'S' ? 2 : 1;
                                break;
                            }
                            if (next == 'f' || next == 'F') {
                                state = 4;
                                i += nextnext == 'n' || nextnext == 'N' ? 2 : 1;
                                break;
                            }
                            if (next == 'o' || next == 'O') {
                                state = 5;
                                i += nextnext == 'j' || nextnext == 'J' ? 2 : 1;
                                break;
                            }
                        }
                        newsql.append(c);
                        break;
                    }
                    case 1: {
                        if (c == '\'') {
                            state = 0;
                        } else if (c == '\\') {
                            state = 2;
                        }
                        newsql.append(c);
                        break;
                    }
                    case 2: {
                        state = 1;
                        newsql.append(c);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (c == '}') {
                            state = 0;
                            break;
                        }
                        newsql.append(c);
                    }
                }
            }
            return newsql.toString();
        }
        return p_sql;
    }

    public int getInsertedOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getInsertOID();
    }

    public long getLastOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0L;
        }
        return this.result.getInsertOID();
    }

    /*
     * WARNING - void declaration
     */
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        void var3_3;
        this.checkClosed();
        switch (sqlType) {
            case 4: {
                int oid = 23;
                break;
            }
            case -6: 
            case 5: {
                int oid = 21;
                break;
            }
            case -5: {
                int oid = 20;
                break;
            }
            case 6: 
            case 7: {
                int oid = 700;
                break;
            }
            case 8: {
                int oid = 701;
                break;
            }
            case 2: 
            case 3: {
                int oid = 1700;
                break;
            }
            case 1: {
                int oid = 1042;
                break;
            }
            case -1: 
            case 12: {
                int oid = 1043;
                break;
            }
            case 91: {
                int oid = 1082;
                break;
            }
            case 92: {
                int oid = 1083;
                break;
            }
            case 93: {
                int oid = 1184;
                break;
            }
            case -7: {
                int oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                int oid;
                if (this.connection.haveMinimumCompatibleVersion("7.2")) {
                    oid = 17;
                    break;
                }
                oid = 26;
                break;
            }
            case 1111: {
                throw new PSQLException(GT.tr("setNull(i,Types.OTHER) is not supported; use setObject(i,nullobject,Types.OTHER) instead."), PSQLState.INVALID_PARAMETER_TYPE);
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value."), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        this.preparedParameters.setNull(this.adjustParamIndex(parameterIndex), (int)var3_3);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.bindString(parameterIndex, x ? "1" : "0", 16);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Float.toString(x), 700);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, 1043);
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.preparedParameters.setNull(this.adjustParamIndex(parameterIndex), oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            byte[] copy = new byte[x.length];
            System.arraycopy(x, 0, copy, 0, x.length);
            this.preparedParameters.setBytea(this.adjustParamIndex(parameterIndex), copy, 0, x.length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            lob.write(x);
            lob.close();
            this.setInt(parameterIndex, oid);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, 91);
        } else {
            this.bindString(parameterIndex, x.toString(), 1082);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, 92);
        } else {
            this.bindString(parameterIndex, x.toString(), 1083);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, 93);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(32);
                int l_year = x.getYear() + 1900;
                int l_yearlen = String.valueOf(l_year).length();
                for (int i = 4; i > l_yearlen; --i) {
                    this.sbuf.append("0");
                }
                this.sbuf.append(l_year);
                this.sbuf.append('-');
                int l_month = x.getMonth() + 1;
                if (l_month < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_month);
                this.sbuf.append('-');
                int l_day = x.getDate();
                if (l_day < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_day);
                this.sbuf.append(' ');
                int l_hours = x.getHours();
                if (l_hours < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_hours);
                this.sbuf.append(':');
                int l_minutes = x.getMinutes();
                if (l_minutes < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_minutes);
                this.sbuf.append(':');
                int l_seconds = x.getSeconds();
                if (l_seconds < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_seconds);
                char[] l_decimal = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
                char[] l_nanos = Integer.toString(x.getNanos()).toCharArray();
                System.arraycopy(l_nanos, 0, l_decimal, l_decimal.length - l_nanos.length, l_nanos.length);
                this.sbuf.append('.');
                if (this.connection.haveMinimumServerVersion("7.2")) {
                    this.sbuf.append(l_decimal, 0, 6);
                } else {
                    this.sbuf.append(l_decimal, 0, 2);
                }
                int l_offset = -x.getTimezoneOffset();
                int l_houros = l_offset / 60;
                if (l_houros >= 0) {
                    this.sbuf.append('+');
                } else {
                    this.sbuf.append('-');
                }
                if (l_houros > -10 && l_houros < 10) {
                    this.sbuf.append('0');
                }
                if (l_houros >= 0) {
                    this.sbuf.append(l_houros);
                } else {
                    this.sbuf.append(-l_houros);
                }
                int l_minos = l_offset - l_houros * 60;
                if (l_minos != 0) {
                    if (l_minos > -10 && l_minos < 10) {
                        this.sbuf.append('0');
                    }
                    if (l_minos >= 0) {
                        this.sbuf.append(l_minos);
                    } else {
                        this.sbuf.append(-l_minos);
                    }
                }
                this.bindString(parameterIndex, this.sbuf.toString(), 1184);
            }
        }
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(length)));
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 1043);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
        catch (IOException l_ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(length)));
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.preparedParameters.setBytea(this.adjustParamIndex(parameterIndex), x, length);
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Provided InputStream failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setInt(parameterIndex, oid);
        }
    }

    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private String numericValueOf(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x != false ? "1" : "0";
        }
        if (x instanceof Integer || x instanceof Long || x instanceof Double || x instanceof Short || x instanceof Number || x instanceof Float) {
            return x.toString();
        }
        return new BigDecimal(x.toString()).toString();
    }

    private void setPGobject(int parameterIndex, PGobject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(parameterIndex, x.getValue(), oid);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 4: {
                this.bindLiteral(parameterIndex, this.numericValueOf(x), 23);
                break;
            }
            case -6: 
            case 5: {
                this.bindLiteral(parameterIndex, this.numericValueOf(x), 21);
                break;
            }
            case -5: {
                this.bindLiteral(parameterIndex, this.numericValueOf(x), 20);
                break;
            }
            case 6: 
            case 7: {
                this.bindLiteral(parameterIndex, this.numericValueOf(x), 700);
                break;
            }
            case 8: {
                this.bindLiteral(parameterIndex, this.numericValueOf(x), 701);
                break;
            }
            case 2: 
            case 3: {
                this.bindLiteral(parameterIndex, this.numericValueOf(x), 1700);
                break;
            }
            case 1: {
                this.setString(parameterIndex, x.toString(), 1042);
            }
            case -1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                break;
            }
            case 91: {
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                Date tmpd = x instanceof java.util.Date ? new Date(((java.util.Date)x).getTime()) : this.dateFromString(x.toString());
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                Time tmpt = x instanceof java.util.Date ? new Time(((java.util.Date)x).getTime()) : this.timeFromString(x.toString());
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                Timestamp tmpts = x instanceof java.util.Date ? new Timestamp(((java.util.Date)x).getTime()) : this.timestampFromString(x.toString());
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case -7: {
                if (x instanceof Boolean) {
                    this.bindString(parameterIndex, (Boolean)x != false ? "1" : "0", 16);
                    break;
                }
                if (x instanceof String) {
                    this.bindString(parameterIndex, Boolean.valueOf(x.toString()) != false ? "1" : "0", 16);
                    break;
                }
                if (x instanceof Number) {
                    this.bindString(parameterIndex, ((Number)x).intValue() != 0 ? "1" : "0", 16);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to Types.BIT", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, x);
                break;
            }
            case 1111: {
                if (x instanceof PGobject) {
                    this.setPGobject(parameterIndex, (PGobject)x);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to Types.OTHER", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", new Integer(targetSqlType)), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            throw new PSQLException(GT.tr("setObject(i,null) is not supported. Instead, use setNull(i,type) or setObject(i,null,type)"), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof PGobject) {
            this.setPGobject(parameterIndex, (PGobject)x);
        } else {
            throw new PSQLException(GT.tr("Can't infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex);
        this.functionReturnType = sqlType;
        this.testReturn = sqlType;
        if (this.functionReturnType == 1 || this.functionReturnType == -1) {
            this.testReturn = 12;
        } else if (this.functionReturnType == 6) {
            this.testReturn = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public boolean wasNull() throws SQLException {
        return this.callResult == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult == null) {
            return false;
        }
        return (Boolean)this.callResult;
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -6, "Byte");
        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR);
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult == null) {
            return 0;
        }
        return (short)((Short)this.callResult).intValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult == null) {
            return 0;
        }
        return (Integer)this.callResult;
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult == null) {
            return 0L;
        }
        return (Long)this.callResult;
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult == null) {
            return 0.0f;
        }
        return ((Float)this.callResult).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult == null) {
            return 0.0;
        }
        return (Double)this.callResult;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult;
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return this.toString();
        }
        return this.preparedQuery.toString(this.preparedParameters);
    }

    private int adjustParamIndex(int paramIndex) throws SQLException {
        if (!this.isFunction) {
            return paramIndex;
        }
        if (paramIndex == 1) {
            throw new PSQLException(GT.tr("Cannot call setXXX(1, ..) on a CallableStatement.  This is an output that must be configured with registerOutParameter instead."));
        }
        return paramIndex - 1;
    }

    private void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setLiteralParameter(this.adjustParamIndex(paramIndex), s, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setStringParameter(this.adjustParamIndex(paramIndex), s, oid);
    }

    private String modifyJdbcCall(String p_sql) throws SQLException {
        this.checkClosed();
        this.isFunction = false;
        int len = p_sql.length();
        int state = 1;
        boolean inQuotes = false;
        boolean inEscape = false;
        int startIndex = -1;
        int endIndex = -1;
        boolean syntaxError = false;
        int i = 0;
        block10: while (i < len && !syntaxError) {
            char ch = p_sql.charAt(i);
            switch (state) {
                case 1: {
                    if (ch == '{') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    i = len;
                    continue block10;
                }
                case 2: {
                    if (ch == '?') {
                        this.isFunction = true;
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (ch == 'c') {
                        state += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 3: {
                    if (ch == '=') {
                        ++i;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 4: {
                    if (ch == 'c' || ch == 'C') {
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 5: {
                    if ((ch == 'c' || ch == 'C') && i + 4 <= len && p_sql.substring(i, i + 4).equalsIgnoreCase("call")) {
                        i += 4;
                        ++state;
                        continue block10;
                    }
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(ch)) {
                        ++state;
                        startIndex = ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
                case 7: {
                    if (ch == '\'') {
                        inQuotes = !inQuotes;
                        ++i;
                        continue block10;
                    }
                    if (inQuotes && ch == '\\') {
                        i += 2;
                        continue block10;
                    }
                    if (!inQuotes && ch == '{') {
                        inEscape = !inEscape;
                        ++i;
                        continue block10;
                    }
                    if (!inQuotes && ch == '}') {
                        if (!inEscape) {
                            endIndex = i++;
                            ++state;
                            continue block10;
                        }
                        inEscape = false;
                        continue block10;
                    }
                    if (!inQuotes && ch == ';') {
                        syntaxError = true;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        continue block10;
                    }
                    syntaxError = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + state);
        }
        if (i == len && !syntaxError) {
            if (state == 1) {
                return p_sql;
            }
            if (state != 8) {
                syntaxError = true;
            }
        }
        if (syntaxError) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", new Integer(i)), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (this.connection.haveMinimumServerVersion("7.3")) {
            return "select * from " + p_sql.substring(startIndex, endIndex) + " as result";
        }
        return "select " + p_sql.substring(startIndex, endIndex) + " as result";
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn && type2 != this.testReturn) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn, getName, "java.sql.Types=" + type1}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", new Object[]{"java.sql.Types=" + this.testReturn, getName, "java.sql.Types=" + type}), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (parameterIndex != 1) {
            throw new PSQLException(GT.tr("PostgreSQL only supports a single OUT function return value at index 1."), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
    }

    public void setPrepareThreshold(int newThreshold) throws SQLException {
        this.checkClosed();
        if (newThreshold < 0) {
            newThreshold = 0;
        }
        this.m_prepareThreshold = newThreshold;
    }

    public int getPrepareThreshold() {
        return this.m_prepareThreshold;
    }

    public void setUseServerPrepare(boolean flag) throws SQLException {
        this.setPrepareThreshold(flag ? 1 : 0);
    }

    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.m_prepareThreshold != 0 && this.m_useCount + 1 >= this.m_prepareThreshold;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("This statement has been closed."));
        }
    }

    private Date dateFromString(String s) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int timezoneLocation = s.indexOf(43) == -1 ? s.lastIndexOf("-") : s.indexOf(43);
        try {
            timezone = timezoneLocation > 7 ? timezoneLocation : s.length();
            millis = Date.valueOf(s.substring(0, timezone)).getTime();
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The given date {0} does not match the format required: {1}.", new Object[]{s, "yyyy-MM-dd[-tz]"}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)e);
        }
        timezone = 0;
        if (timezoneLocation > 7 && timezoneLocation + 3 == s.length()) {
            timezone = Integer.parseInt(s.substring(timezoneLocation + 1, s.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        return new Date(millis);
    }

    private Time timeFromString(String s) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int timezoneLocation = s.indexOf(43) == -1 ? s.lastIndexOf("-") : s.indexOf(43);
        try {
            timezone = timezoneLocation == -1 ? s.length() : timezoneLocation;
            millis = Time.valueOf(s.substring(0, timezone)).getTime();
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The time given {0} does not match the format required: {1}.", new Object[]{s, "HH:mm:ss[-tz]"}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)e);
        }
        timezone = 0;
        if (timezoneLocation != -1 && timezoneLocation + 3 == s.length()) {
            timezone = Integer.parseInt(s.substring(timezoneLocation + 1, s.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        return new Time(millis);
    }

    private Timestamp timestampFromString(String s) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int nanosVal = 0;
        int timezoneLocation = s.indexOf(43) == -1 ? s.lastIndexOf("-") : s.indexOf(43);
        int nanospos = s.indexOf(".");
        try {
            timezone = nanospos != -1 ? nanospos : (timezoneLocation > 8 ? timezoneLocation : s.length());
            millis = Timestamp.valueOf(s.substring(0, timezone)).getTime();
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The timestamp given {0} does not match the format required: {1}.", new Object[]{s, "yyyy-MM-dd HH:mm:ss[.xxxxxx][-tz]"}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)e);
        }
        timezone = 0;
        if (nanospos != -1) {
            int tmploc = timezoneLocation > 8 ? timezoneLocation : s.length();
            nanosVal = Integer.parseInt(s.substring(nanospos + 1, tmploc));
            int diff = 8 - (tmploc - 1 - (nanospos + 1));
            for (int i = 0; i < diff; ++i) {
                nanosVal *= 10;
            }
        }
        if (timezoneLocation > 8 && timezoneLocation + 3 == s.length()) {
            timezone = Integer.parseInt(s.substring(timezoneLocation + 1, s.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        Timestamp tmpts = new Timestamp(millis);
        tmpts.setNanos(nanosVal);
        return tmpts;
    }

    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        if (this.preparedQuery != null) {
            throw new PSQLException(GT.tr("Can't use query methods that take a query string on a PreparedStatement."));
        }
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.connection.getQueryExecutor().createSimpleQuery(p_sql));
        this.batchParameters.add(null);
    }

    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null || this.batchStatements.isEmpty()) {
            return new int[0];
        }
        int size = this.batchStatements.size();
        int[] updateCounts = new int[size];
        Query[] queries = this.batchStatements.toArray(new Query[this.batchStatements.size()]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[this.batchParameters.size()]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        while (this.firstUnclosedResult != null) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        int flags = 4;
        if (this.preparedQuery != null) {
            this.m_useCount += queries.length;
            if (this.m_prepareThreshold == 0 || this.m_useCount < this.m_prepareThreshold) {
                flags |= 1;
            }
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        this.result = null;
        BatchResultHandler handler = new BatchResultHandler(queries, parameterLists, updateCounts);
        this.connection.getQueryExecutor().execute(queries, parameterLists, (ResultHandler)handler, this.maxrows, this.fetchSize, flags);
        return updateCounts;
    }

    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() {
        return this.fetchdirection;
    }

    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    public int getResultSetType() {
        return this.resultsettype;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", new Integer(direction)));
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."));
        }
        this.fetchSize = rows;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchStatements.add(this.preparedQuery);
        this.batchParameters.add(this.preparedParameters.copy());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    public void setArray(int i, Array x) throws SQLException {
        this.checkClosed();
        String typename = "_" + x.getBaseTypeName();
        int oid = this.connection.getPGType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(i, x.toString(), oid);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        InputStream l_inStream = x.getBinaryStream();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.open(oid);
        OutputStream los = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            int bytesRemaining = (int)x.length();
            int numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            while (numRead != -1 && bytesRemaining > 0) {
                bytesRemaining -= numRead;
                if (numRead == buf.length) {
                    los.write(buf);
                } else {
                    los.write(buf, 0, numRead);
                }
                numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            }
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                los.close();
                l_inStream.close();
            }
            catch (Exception e) {}
        }
        this.setInt(i, oid);
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", new Integer(length)));
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            try {
                int n;
                while ((n = x.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
                }
            }
            catch (IOException l_ioe) {
                throw new PSQLException(GT.tr("Provided Reader failed."), PSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
            }
            this.setString(i, new String(l_chars, 0, l_charsRead));
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c = x.read();
                for (int p = 0; c > -1 && p < length; ++p) {
                    los.write(c);
                    c = x.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
            }
            this.setInt(i, oid);
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        InputStream l_inStream = x.getAsciiStream();
        int l_length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.open(oid);
        OutputStream los = lob.getOutputStream();
        try {
            int c = l_inStream.read();
            for (int p = 0; c > -1 && p < l_length; ++p) {
                los.write(c);
                c = l_inStream.read();
            }
            los.close();
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database."), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setInt(i, oid);
    }

    public void setNull(int i, int t, String s) throws SQLException {
        this.checkClosed();
        this.setNull(i, t);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setDate(i, d);
        } else {
            cal = AbstractJdbc2Statement.changeTime(d, cal, true);
            this.setDate(i, new Date(cal.getTime().getTime()));
        }
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setTime(i, t);
        } else {
            cal = AbstractJdbc2Statement.changeTime(t, cal, true);
            this.setTime(i, new Time(cal.getTime().getTime()));
        }
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setTimestamp(i, t);
        } else {
            cal = AbstractJdbc2Statement.changeTime(t, cal, true);
            this.setTimestamp(i, new Timestamp(cal.getTime().getTime()));
        }
    }

    public Array getArray(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult;
    }

    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObjectImpl(int i, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getDate(i);
        }
        Date tmp = this.getDate(i);
        if (tmp == null) {
            return null;
        }
        cal = AbstractJdbc2Statement.changeTime(tmp, cal, false);
        return new Date(cal.getTime().getTime());
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getTime(i);
        }
        Time tmp = this.getTime(i);
        if (tmp == null) {
            return null;
        }
        cal = AbstractJdbc2Statement.changeTime(tmp, cal, false);
        return new Time(cal.getTime().getTime());
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getTimestamp(i);
        }
        Timestamp tmp = this.getTimestamp(i);
        if (tmp == null) {
            return null;
        }
        cal = AbstractJdbc2Statement.changeTime(tmp, cal, false);
        return new Timestamp(cal.getTime().getTime());
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented();
    }

    static Calendar changeTime(java.util.Date t, Calendar cal, boolean Add) {
        long millis = t.getTime();
        int localoffset = t.getTimezoneOffset() * 60 * 1000 * -1;
        int caloffset = cal.getTimeZone().getRawOffset();
        if (cal.getTimeZone().inDaylightTime(t)) {
            millis += 3600000L;
        }
        caloffset = Add ? caloffset - localoffset : -1 * (caloffset - localoffset);
        java.util.Date tmpDate = new java.util.Date();
        tmpDate.setTime(millis - (long)caloffset);
        cal.setTime(tmpDate);
        tmpDate = null;
        return cal;
    }

    private class BatchResultHandler
    implements ResultHandler {
        private BatchUpdateException batchException = null;
        private int resultIndex = 0;
        private final Query[] queries;
        private final ParameterList[] parameterLists;
        private final int[] updateCounts;

        BatchResultHandler(Query[] queries, ParameterList[] parameterLists, int[] updateCounts) {
            this.queries = queries;
            this.parameterLists = parameterLists;
            this.updateCounts = updateCounts;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.handleError(new PSQLException(GT.tr("A result was returned when none was expected.")));
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            if (this.resultIndex >= this.updateCounts.length) {
                this.handleError(new SQLException(GT.tr("Too many update results were returned.")));
                return;
            }
            this.updateCounts[this.resultIndex++] = updateCount;
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.batchException == null) {
                int[] successCounts;
                if (this.resultIndex >= this.updateCounts.length) {
                    successCounts = this.updateCounts;
                } else {
                    successCounts = new int[this.resultIndex];
                    System.arraycopy(this.updateCounts, 0, successCounts, 0, this.resultIndex);
                }
                String queryString = "<unknown>";
                if (this.resultIndex < this.queries.length) {
                    queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
                }
                this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{new Integer(this.resultIndex), queryString}), successCounts);
            }
            this.batchException.setNextException(newError);
        }

        public void handleCompletion() throws SQLException {
            if (this.batchException != null) {
                throw this.batchException;
            }
        }
    }

    public class StatementResultHandler
    implements ResultHandler {
        private SQLException error;
        private ResultWrapper results;

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper newResult) {
            if (this.results == null) {
                this.results = newResult;
            } else {
                this.results.append(newResult);
            }
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            try {
                ResultSet rs = AbstractJdbc2Statement.this.createResultSet(fromQuery, fields, tuples, cursor);
                this.append(new ResultWrapper(rs));
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.append(new ResultWrapper(updateCount, insertOID));
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Statement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

