/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.postgresql.Driver;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TimestampUtils {
    private static StringBuffer sbuf = new StringBuffer();
    private static SimpleDateFormat tstzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static SimpleDateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static Timestamp toTimestamp(String s, String pgDataType) throws SQLException {
        if (s == null) {
            return null;
        }
        s = s.trim();
        StringBuffer stringBuffer = sbuf;
        synchronized (stringBuffer) {
            SimpleDateFormat df = null;
            if (Driver.logDebug) {
                Driver.debug("the data from the DB is " + s);
            }
            sbuf.setLength(0);
            sbuf.append(s);
            int slen = s.length();
            int nanos = 0;
            if (slen > 19) {
                int i = 19;
                sbuf.setLength(i);
                char c = s.charAt(i++);
                if (c == '.') {
                    int start = i;
                    while (Character.isDigit(c = s.charAt(i++))) {
                        if (i != slen) continue;
                        ++i;
                        break;
                    }
                    int end = i - 1;
                    try {
                        nanos = Integer.parseInt(s.substring(start, end));
                    }
                    catch (NumberFormatException e) {
                        throw new PSQLException(GT.tr("Could not extract nanoseconds from {0}.", s.substring(start, end)), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
                    }
                    for (int digitsToNano = 9 - (end - start); digitsToNano > 0; --digitsToNano) {
                        nanos *= 10;
                    }
                }
                if (i < slen) {
                    sbuf.append(" GMT");
                    sbuf.append(c);
                    sbuf.append(s.substring(i, slen));
                    if (slen - i < 5) {
                        sbuf.append(":00");
                    }
                    df = tstzFormat;
                } else if (pgDataType.equals("timestamptz")) {
                    sbuf.append(" GMT");
                    df = tstzFormat;
                } else {
                    df = tsFormat;
                }
            } else if (slen == 19) {
                if (pgDataType.equals("timestamptz")) {
                    sbuf.append(" GMT");
                    df = tstzFormat;
                } else {
                    df = tsFormat;
                }
            } else {
                if (slen == 8 && s.equals("infinity")) {
                    s = "9999-01-01";
                }
                if (slen == 9 && s.equals("-infinity")) {
                    s = "0001-01-01";
                }
                if (pgDataType.compareTo("date") == 0) {
                    df = dateFormat;
                } else {
                    try {
                        df = new SimpleDateFormat();
                        s = TimestampUtils.parseTime(s, df);
                        Date d = df.parse(s);
                        return new Timestamp(d.getTime());
                    }
                    catch (ParseException ex) {
                        throw new PSQLException(GT.tr("The timestamp given {0} does not match the format required: {1}.", new Object[]{s, df}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)ex);
                    }
                }
            }
            try {
                if (Driver.logDebug) {
                    Driver.debug("the data after parsing is " + sbuf.toString() + " with " + nanos + " nanos");
                }
                Timestamp result = new Timestamp(df.parse(sbuf.toString()).getTime());
                result.setNanos(nanos);
                return result;
            }
            catch (ParseException e) {
                throw new PSQLException(GT.tr("The timestamp given {0} does not match the format required: {1}.", new Object[]{sbuf.toString(), df}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)e);
            }
        }
    }

    private static String parseTime(String s, SimpleDateFormat df) throws ParseException {
        StringBuffer sbuf = new StringBuffer(s.substring(0, 8));
        StringBuffer dateFormat = new StringBuffer("HH:mm:ss");
        int msIndex = s.indexOf(46);
        int tzIndex = s.indexOf(45);
        if (tzIndex == -1) {
            tzIndex = s.indexOf(43);
        }
        if (msIndex != -1) {
            String microseconds = s.substring(msIndex + 1, tzIndex != -1 ? tzIndex : s.length());
            int msec = 0;
            for (int i = 0; i < (microseconds.length() > 3 ? 4 : microseconds.length()); ++i) {
                int digit = Character.digit(microseconds.charAt(i), 10);
                if (digit == -1) {
                    throw new ParseException(s, tzIndex);
                }
                if (i == 0) {
                    msec += digit * 100;
                    continue;
                }
                if (i == 1) {
                    msec += digit * 10;
                    continue;
                }
                if (i == 2) {
                    msec += digit;
                    continue;
                }
                if (i != 3 || digit < 5) continue;
                ++msec;
            }
            sbuf.append('.').append(msec);
            dateFormat.append(".SSS");
        }
        if (tzIndex != -1) {
            String tz = s.substring(tzIndex);
            sbuf.append(" GMT").append(tz);
            if (tz.length() < 6) {
                sbuf.append(":00");
            }
            dateFormat.append(" z");
        }
        df.applyPattern(dateFormat.toString());
        return sbuf.toString();
    }

    public static Time toTime(String s, String pgDataType) throws SQLException {
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = null;
        try {
            s = s.trim();
            if (s.length() == 8) {
                return Time.valueOf(s);
            }
            if (!pgDataType.startsWith("timestamp")) {
                df = new SimpleDateFormat();
                s = TimestampUtils.parseTime(s, df);
                Date d = df.parse(s);
                return new Time(d.getTime());
            }
            return new Time(TimestampUtils.toTimestamp(s, pgDataType).getTime());
        }
        catch (ParseException e) {
            throw new PSQLException(GT.tr("The time given {0} does not match the format required: {1}.", new Object[]{s, df}), PSQLState.BAD_DATETIME_FORMAT);
        }
    }
}

