/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc3;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;

public class PSQLSavepoint
implements Savepoint {
    private boolean _isValid = true;
    private boolean _isNamed;
    private int _id;
    private String _name;

    public PSQLSavepoint(int id) {
        this._isNamed = false;
        this._id = id;
    }

    public PSQLSavepoint(String name) {
        this._isNamed = true;
        this._name = name;
    }

    public int getSavepointId() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released."));
        }
        if (this._isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the id of a named savepoint."));
        }
        return this._id;
    }

    public String getSavepointName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released."));
        }
        if (!this._isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint."));
        }
        return this._name;
    }

    public void invalidate() {
        this._isValid = false;
    }

    public String getPGName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released."));
        }
        if (this._isNamed) {
            StringBuffer sb = new StringBuffer(this._name.length() + 2);
            sb.append("\"");
            for (int i = 0; i < this._name.length(); ++i) {
                char c = this._name.charAt(i);
                if (c == '\\' || c == '\"') {
                    sb.append(c);
                }
                sb.append(c);
            }
            sb.append("\"");
            return sb.toString();
        }
        return "JDBC_SAVEPOINT_" + this._id;
    }
}

