/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.JtdsInputStream;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TextPtr;
import net.sourceforge.jtds.util.Logger;

public class BlobImpl
implements Blob {
    private static final byte[] EMPTY_BLOB = new byte[0];
    private ConnectionJDBC2 _connection;
    private byte[] _blob;
    private File _blobFile;
    private JtdsInputStream _jtdsInputStream;

    BlobImpl(Object callerReference) {
        this(callerReference, EMPTY_BLOB);
    }

    BlobImpl(Object callerReference, byte[] blob) {
        if (blob == null) {
            throw new IllegalArgumentException("blob cannot be null.");
        }
        this._connection = Support.getConnection(callerReference);
        this._blob = blob;
    }

    /*
     * WARNING - void declaration
     */
    BlobImpl(Object callerReference, ResponseStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null.");
        }
        this._connection = Support.getConnection(callerReference);
        TextPtr tp = new TextPtr();
        in.read(tp.ptr);
        in.read(tp.ts);
        tp.len = in.readInt();
        if ((long)tp.len < this._connection.getLobBuffer()) {
            this._blob = new byte[tp.len];
            in.read(this._blob);
        } else {
            this._blob = EMPTY_BLOB;
            try {
                int result;
                OutputStream outputStream = this.setBinaryStream(1L);
                byte[] buffer = new byte[1024];
                int length = tp.len;
                while ((result = in.read(buffer, 0, Math.min(length, buffer.length))) != -1 && length != 0) {
                    void var7_8;
                    outputStream.write(buffer, 0, (int)var7_8);
                    length -= var7_8;
                }
                outputStream.close();
                if (length != 0) {
                    throw new IOException(Messages.get("error.generic.ioread", "bytes", "unexpected EOF"));
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        try {
            if (this._blob != null) {
                return new ByteArrayInputStream(this._blob);
            }
            if (this._blobFile != null) {
                return new BufferedInputStream(new FileInputStream(this._blobFile));
            }
            this._jtdsInputStream.reset();
            return this._jtdsInputStream;
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException(Messages.get("error.blobclob.badpos"), "HY090");
        }
        if (length < 0) {
            throw new SQLException(Messages.get("error.blobclob.badlen"), "HY090");
        }
        if (pos - 1L + (long)length > this.length()) {
            length = (int)(this.length() - pos + 1L);
        }
        if (length == 0) {
            return EMPTY_BLOB;
        }
        InputStream inputStream = this.getBinaryStream();
        this.skip(inputStream, pos - 1L);
        try {
            int res;
            byte[] buffer = new byte[length];
            int bytesRead = 0;
            while ((res = inputStream.read(buffer, bytesRead, length - bytesRead)) != -1) {
                void var7_7;
                if ((bytesRead += var7_7) != length) continue;
                return buffer;
            }
            throw new SQLException(Messages.get("error.blobclob.readlen"), "HY000");
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioread", "byte", e.getMessage()), "HY000");
        }
    }

    public synchronized long length() throws SQLException {
        if (this._blob != null) {
            return this._blob.length;
        }
        if (this._blobFile != null) {
            return this._blobFile.length();
        }
        return this._jtdsInputStream.getLength();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        return this.position(new BlobImpl((Object)this._connection, pattern), start);
    }

    /*
     * WARNING - void declaration
     */
    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            throw new SQLException(Messages.get("error.blob.badpattern"), "HY024");
        }
        try {
            InputStream inputStream = this.getBinaryStream();
            long length = this.length() - pattern.length();
            boolean reset = true;
            long i = start;
            while (i < length) {
                int searchValue;
                boolean found = true;
                if (reset) {
                    inputStream = this.getBinaryStream();
                    this.skip(inputStream, i);
                    reset = false;
                }
                int value = inputStream.read();
                InputStream patternInputStream = pattern.getBinaryStream();
                while ((searchValue = patternInputStream.read()) != -1) {
                    void var13_11;
                    if (value != var13_11) {
                        found = false;
                        break;
                    }
                    reset = true;
                }
                if (found) {
                    return i;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioread", "String", e.getMessage()), "HY000");
        }
        return -1L;
    }

    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        long length = this.length();
        if (pos < 1L) {
            throw new SQLException(Messages.get("error.blobclob.badpos"), "HY090");
        }
        if (pos > length && pos != 1L) {
            throw new SQLException(Messages.get("error.blobclob.badposlen"), "HY090");
        }
        return new BlobOutputStream(pos, length);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw new SQLException(Messages.get("error.blob.bytesnull"), "HY024");
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        OutputStream outputStream = this.setBinaryStream(pos);
        try {
            outputStream.write(bytes, offset, len);
            outputStream.close();
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.iowrite", "bytes", e.getMessage()), "HY000");
        }
        return len;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void truncate(long len) throws SQLException {
        long currentLength = this.length();
        if (len < 0L) {
            throw new SQLException(Messages.get("error.blobclob.badlen"), "HY090");
        }
        if (len > currentLength) {
            throw new SQLException(Messages.get("error.blobclob.lentoolong"), "HY090");
        }
        if (len == currentLength) {
            return;
        }
        if (len <= this._connection.getLobBuffer()) {
            this._blob = this.getBytes(1L, (int)len);
            if (this._blobFile != null) {
                this._blobFile.delete();
                this._blobFile = null;
            }
            this._jtdsInputStream = null;
        } else {
            try {
                int result;
                InputStream inputStream = this.getBinaryStream();
                File tmpFile = this._blobFile;
                this._blob = new byte[0];
                this._blobFile = null;
                this._jtdsInputStream = null;
                OutputStream outputStream = this.setBinaryStream(1L);
                byte[] buffer = new byte[1024];
                while ((result = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, len))) > 0) {
                    void var9_8;
                    len -= (long)var9_8;
                    outputStream.write(buffer, 0, (int)var9_8);
                }
                outputStream.close();
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (IOException e) {
                throw new SQLException(Messages.get("error.generic.iowrite", "bytes", e.getMessage()), "HY000");
            }
        }
    }

    private void skip(InputStream inputStream, long skip) throws SQLException {
        try {
            long skipped = inputStream.skip(skip);
            if (skipped != skip) {
                throw new SQLException(Messages.get("error.blobclob.badposlen"), "HY090");
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
        }
    }

    protected void finalize() {
        if (this._blobFile != null) {
            this._blobFile.delete();
        }
    }

    static /* synthetic */ ConnectionJDBC2 access$000(BlobImpl x0) {
        return x0._connection;
    }

    static /* synthetic */ File access$100(BlobImpl x0) {
        return x0._blobFile;
    }

    static /* synthetic */ JtdsInputStream access$200(BlobImpl x0) {
        return x0._jtdsInputStream;
    }

    static /* synthetic */ byte[] access$302(BlobImpl x0, byte[] x1) {
        x0._blob = x1;
        return x1;
    }

    static /* synthetic */ JtdsInputStream access$202(BlobImpl x0, JtdsInputStream x1) {
        x0._jtdsInputStream = x1;
        return x0._jtdsInputStream;
    }

    static /* synthetic */ byte[] access$300(BlobImpl x0) {
        return x0._blob;
    }

    static /* synthetic */ File access$102(BlobImpl x0, File x1) {
        x0._blobFile = x1;
        return x0._blobFile;
    }

    class BlobFileOutputStream
    extends OutputStream {
        RandomAccessFile raf;

        BlobFileOutputStream(long curPos) throws IOException {
            this.raf = new RandomAccessFile(BlobImpl.this._blobFile, "rw");
            this.raf.seek(curPos);
        }

        public void write(int b) throws IOException {
            if (this.raf == null) {
                throw new IOException("stream closed");
            }
            this.raf.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.raf == null) {
                throw new IOException("stream closed");
            }
            this.raf.write(b, off, len);
        }

        public void close() throws IOException {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
        }
    }

    class BlobOutputStream
    extends OutputStream {
        private OutputStream outputStream;
        private long curPos;
        private boolean securityFailure = false;

        /*
         * WARNING - void declaration
         */
        BlobOutputStream(long pos, long length) throws SQLException {
            this.curPos = pos - 1L;
            try {
                if (length > BlobImpl.this._connection.getLobBuffer()) {
                    if (BlobImpl.this._blobFile == null) {
                        this.writeToDisk(BlobImpl.this.getBinaryStream());
                    }
                } else if (BlobImpl.this._jtdsInputStream != null) {
                    int result;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream((int)length);
                    byte[] buffer = new byte[1024];
                    while ((result = BlobImpl.this._jtdsInputStream.read(buffer)) != -1) {
                        void var8_7;
                        baos.write(buffer, 0, (int)var8_7);
                    }
                    BlobImpl.access$302(BlobImpl.this, baos.toByteArray());
                    BlobImpl.this._jtdsInputStream = null;
                }
                this.updateOuputStream();
            }
            catch (IOException e) {
                throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
            }
        }

        public void write(int b) throws IOException {
            BlobImpl blobImpl = BlobImpl.this;
            synchronized (blobImpl) {
                this.checkSize(1L);
                this.outputStream.write(b);
                ++this.curPos;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            BlobImpl blobImpl = BlobImpl.this;
            synchronized (blobImpl) {
                this.checkSize(len);
                this.outputStream.write(b, off, len);
                this.curPos += (long)len;
            }
        }

        private void checkSize(long length) throws IOException {
            if (this.curPos > BlobImpl.this._connection.getLobBuffer()) {
                return;
            }
            if (BlobImpl.this._blobFile != null) {
                return;
            }
            if (this.securityFailure) {
                return;
            }
            if (this.curPos + length <= BlobImpl.this._connection.getLobBuffer()) {
                return;
            }
            if (BlobImpl.this._blob != null) {
                this.writeToDisk(new ByteArrayInputStream(BlobImpl.this._blob));
                this.updateOuputStream();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void writeToDisk(InputStream inputStream) throws IOException {
            OutputStream os;
            block13: {
                try {
                    BlobImpl.this._blobFile = File.createTempFile("jtds", ".tmp");
                    BlobImpl.this._blobFile.deleteOnExit();
                    os = new BufferedOutputStream(new FileOutputStream(BlobImpl.this._blobFile));
                }
                catch (SecurityException e) {
                    this.securityFailure = true;
                    if (BlobImpl.this._blobFile != null) {
                        try {
                            BlobImpl.this._blobFile.delete();
                        }
                        catch (SecurityException ex) {
                            // empty catch block
                        }
                        BlobImpl.this._blobFile = null;
                    }
                    os = new ByteArrayOutputStream();
                    if (!Logger.isActive()) break block13;
                    Logger.println("Blob: Unable to buffer data to disk: " + e.getMessage());
                }
            }
            try {
                byte[] buffer = new byte[1024];
                while (true) {
                    void ex;
                    int result;
                    if ((result = inputStream.read(buffer)) == -1) {
                        Object var6_7 = null;
                        break;
                    }
                    os.write(buffer, 0, (int)ex);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                os.flush();
                if (os instanceof ByteArrayOutputStream) {
                    BlobImpl.access$302(BlobImpl.this, ((ByteArrayOutputStream)os).toByteArray());
                } else {
                    BlobImpl.access$302(BlobImpl.this, null);
                }
                os.close();
                throw throwable;
            }
            os.flush();
            if (os instanceof ByteArrayOutputStream) {
                BlobImpl.access$302(BlobImpl.this, ((ByteArrayOutputStream)os).toByteArray());
            } else {
                BlobImpl.access$302(BlobImpl.this, null);
            }
            os.close();
        }

        void updateOuputStream() throws IOException {
            if (BlobImpl.this._blob != null) {
                long startPos = this.curPos;
                this.outputStream = new OutputStream(this, startPos){
                    int curPos;
                    boolean closed;
                    private final /* synthetic */ long val$startPos;
                    private final /* synthetic */ BlobOutputStream this$1;
                    {
                        this.this$1 = this$1;
                        this.val$startPos = val$startPos;
                        this.curPos = (int)this.val$startPos;
                        this.closed = false;
                    }

                    private void checkOpen() throws IOException {
                        if (this.closed) {
                            throw new IOException("stream closed");
                        }
                        if (BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)) == null) {
                            throw new IOException(Messages.get("error.generic.iowrite", "byte", "_blob = NULL"));
                        }
                    }

                    public void write(int b) throws IOException {
                        this.checkOpen();
                        if (this.curPos + 1 > BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)).length) {
                            byte[] buffer = new byte[this.curPos + 1];
                            System.arraycopy(BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)), 0, buffer, 0, BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)).length);
                            BlobImpl.access$302(BlobOutputStream.access$400(this.this$1), buffer);
                        }
                        BlobImpl.access$300((BlobImpl)BlobOutputStream.access$400((BlobOutputStream)this.this$1))[this.curPos++] = (byte)b;
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                        this.checkOpen();
                        if (b == null) {
                            throw new NullPointerException();
                        }
                        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        if (len == 0) {
                            return;
                        }
                        if (this.curPos + len > BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)).length) {
                            byte[] buffer = new byte[this.curPos + len];
                            System.arraycopy(BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)), 0, buffer, 0, BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)).length);
                            BlobImpl.access$302(BlobOutputStream.access$400(this.this$1), buffer);
                        }
                        System.arraycopy(b, off, BlobImpl.access$300(BlobOutputStream.access$400(this.this$1)), this.curPos, len);
                        this.curPos += len;
                    }

                    public void close() {
                        this.closed = true;
                    }
                };
            } else {
                this.outputStream = new BlobFileOutputStream(this.curPos);
            }
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.close();
        }

        static /* synthetic */ BlobImpl access$400(BlobOutputStream x0) {
            return x0.BlobImpl.this;
        }
    }
}

