/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;

public class TypeInfo
implements Comparable {
    static final int NUM_COLS = 18;
    private String typeName;
    private int dataType;
    private int precision;
    private String literalPrefix;
    private String literalSuffix;
    private String createParams;
    private short nullable;
    private boolean caseSensitive;
    private short searchable;
    private boolean unsigned;
    private boolean fixedPrecScale;
    private boolean autoIncrement;
    private String localTypeName;
    private short minimumScale;
    private short maximumScale;
    private int sqlDataType;
    private int sqlDatetimeSub;
    private int numPrecRadix;
    private int normalizedType;
    private int distanceFromJdbcType;

    public TypeInfo(ResultSet rs) throws SQLException {
        this.typeName = rs.getString(1);
        this.dataType = rs.getInt(2);
        this.precision = rs.getInt(3);
        this.literalPrefix = rs.getString(4);
        this.literalSuffix = rs.getString(5);
        this.createParams = rs.getString(6);
        this.nullable = rs.getShort(7);
        this.caseSensitive = rs.getBoolean(8);
        this.searchable = rs.getShort(9);
        this.unsigned = rs.getBoolean(10);
        this.fixedPrecScale = rs.getBoolean(11);
        this.autoIncrement = rs.getBoolean(12);
        this.localTypeName = rs.getString(13);
        this.minimumScale = rs.getShort(14);
        this.maximumScale = rs.getShort(15);
        this.sqlDataType = rs.getInt(16);
        this.sqlDatetimeSub = rs.getInt(17);
        this.numPrecRadix = rs.getInt(18);
        this.normalizedType = TypeInfo.normalizeDataType(this.dataType);
        this.distanceFromJdbcType = this.determineDistanceFromJdbcType();
    }

    public TypeInfo(String typeName, int dataType, boolean autoIncrement) {
        this.typeName = typeName;
        this.dataType = dataType;
        this.autoIncrement = autoIncrement;
        this.normalizedType = TypeInfo.normalizeDataType(dataType);
        this.distanceFromJdbcType = this.determineDistanceFromJdbcType();
    }

    public boolean equals(Object o) {
        if (o instanceof TypeInfo) {
            return this.compareTo(o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.normalizedType * this.dataType * (this.autoIncrement ? 7 : 11);
    }

    public String toString() {
        return this.typeName + " (" + (this.dataType != this.normalizedType ? this.dataType + "->" : "") + this.normalizedType + ")";
    }

    public void update(ResultSet rs) throws SQLException {
        rs.updateString(1, this.typeName);
        rs.updateInt(2, this.normalizedType);
        rs.updateInt(3, this.precision);
        rs.updateString(4, this.literalPrefix);
        rs.updateString(5, this.literalSuffix);
        rs.updateString(6, this.createParams);
        rs.updateShort(7, this.nullable);
        rs.updateBoolean(8, this.caseSensitive);
        rs.updateShort(9, this.searchable);
        rs.updateBoolean(10, this.unsigned);
        rs.updateBoolean(11, this.fixedPrecScale);
        rs.updateBoolean(12, this.autoIncrement);
        rs.updateString(13, this.localTypeName);
        rs.updateShort(14, this.minimumScale);
        rs.updateShort(15, this.maximumScale);
        rs.updateInt(16, this.sqlDataType);
        rs.updateInt(17, this.sqlDatetimeSub);
        rs.updateInt(18, this.numPrecRadix);
    }

    public int compareTo(Object o) {
        TypeInfo other = (TypeInfo)o;
        return this.compare(this.normalizedType, other.normalizedType) * 10 + this.compare(this.distanceFromJdbcType, other.distanceFromJdbcType);
    }

    private int compare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    private int determineDistanceFromJdbcType() {
        switch (this.dataType) {
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                return 0;
            }
            case -9: {
                return this.typeName.equalsIgnoreCase("sysname") ? 4 : 3;
            }
            case -11: {
                return 9;
            }
            case -150: {
                return 8;
            }
        }
        return this.dataType == this.normalizedType && !this.autoIncrement ? 0 : 5;
    }

    public static int normalizeDataType(int serverDataType) {
        switch (serverDataType) {
            case 35: {
                return 12;
            }
            case 11: {
                return 93;
            }
            case 10: {
                return 92;
            }
            case 9: {
                return 91;
            }
            case 6: {
                return 8;
            }
            case -1: {
                return 2005;
            }
            case -4: {
                return 2004;
            }
            case -8: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -10: {
                return 2005;
            }
            case -11: {
                return 1;
            }
            case -150: {
                return 12;
            }
        }
        return serverDataType;
    }
}

