/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.jtds.jdbc.cache.StatementCache;

abstract class AbstractStatementCache
implements StatementCache {
    private static final Integer INTEGER_ONE = new Integer(1);
    protected int maximumCacheTarget;
    private HashMap latches = new HashMap();

    protected AbstractStatementCache(int maximumCacheTarget) {
        this.maximumCacheTarget = maximumCacheTarget;
    }

    protected void latch(Object handle) {
        Integer latchCount;
        if (handle != null) {
            handle = handle.toString();
        }
        if ((latchCount = (Integer)this.latches.get(handle)) == null) {
            this.latches.put(handle, INTEGER_ONE);
        } else {
            this.latches.put(handle, new Integer(latchCount + 1));
        }
    }

    protected void unlatch(Collection handles) {
        if (handles != null) {
            Iterator iterator = handles.iterator();
            while (iterator.hasNext()) {
                this.unlatch(iterator.next());
            }
        }
    }

    protected void unlatch(Object handle) {
        Integer latchCount;
        if (handle != null) {
            handle = handle.toString();
        }
        if ((latchCount = (Integer)this.latches.get(handle)) == null) {
            return;
        }
        if (latchCount == 1) {
            this.latches.remove(handle);
        } else {
            this.latches.put(handle, new Integer(latchCount - 1));
        }
    }

    protected void removeLatches(Object handle) {
        if (handle != null) {
            handle = handle.toString();
        }
        this.latches.remove(handle);
    }

    protected boolean isLatched(Object handle) {
        if (handle != null) {
            handle = handle.toString();
        }
        return this.latches.containsKey(handle);
    }

    public abstract Collection getObsoleteHandles(Collection var1);

    public abstract void remove(String var1);

    public abstract void put(String var1, Object var2);

    public abstract Object get(String var1);
}

