/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jtds.ssl.Record;
import net.sourceforge.jtds.ssl.RecordFactory;
import net.sourceforge.jtds.ssl.Sslv2ClientHelloRecord;
import net.sourceforge.jtds.ssl.TlsHandshakeBody;
import net.sourceforge.jtds.ssl.TlsHandshakeRecord;
import net.sourceforge.jtds.ssl.TlsRecord;
import net.sourceforge.jtds.ssl.Util;
import net.sourceforge.jtds.util.BytesView;

class TdsTlsOutputStream
extends FilterOutputStream {
    private List bufferedRecords = new ArrayList();

    TdsTlsOutputStream(OutputStream out) {
        super(out);
    }

    private void deferRecord(TlsRecord record) {
        record.detachData();
        this.bufferedRecords.add(record);
    }

    private void flushBufferedRecords() throws IOException {
        Iterator iter = this.bufferedRecords.iterator();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (iter.hasNext()) {
            TlsRecord record = (TlsRecord)iter.next();
            record.write(bos);
        }
        this.putPacket(bos.toByteArray());
        this.bufferedRecords.clear();
    }

    private void putPacket(Record record) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(record.getLength());
        record.write(bos);
        this.putPacket(bos.toByteArray());
    }

    private void putPacket(byte[] data) throws IOException {
        Util.putPacket(this.out, data);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        Record r = RecordFactory.create(new BytesView(b, off, len));
        if (r instanceof Sslv2ClientHelloRecord) {
            this.putPacket(r);
            return;
        }
        TlsRecord record = (TlsRecord)r;
        if (record.getContentType() == 23) {
            record.write(this.out);
            return;
        }
        if (record.getContentType() == 20) {
            this.deferRecord(record);
            return;
        }
        if (record.getContentType() == 22) {
            TlsHandshakeRecord hsrec = (TlsHandshakeRecord)record;
            TlsHandshakeBody hsbody = hsrec.getHandshakeBody();
            if (hsbody == null) {
                this.deferRecord(record);
                this.flushBufferedRecords();
                return;
            }
            if (hsbody.getHandshakeType() == 16) {
                this.deferRecord(record);
                return;
            }
            if (hsbody.getHandshakeType() == 1) {
                this.putPacket(record);
                return;
            }
            this.deferRecord(record);
            this.flushBufferedRecords();
            return;
        }
    }

    public void flush() throws IOException {
        super.flush();
    }
}

