/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BytesView {
    private byte[] b;
    private int off;
    private int len;

    public BytesView(byte[] b, int off, int len) {
        BytesView.checkParams(b.length, off, len);
        this.b = b;
        this.off = off;
        this.len = len;
    }

    public int getLength() {
        return this.len;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.b, this.off, this.len);
    }

    public BytesView getSubset(int off, int len) {
        BytesView.checkParams(this.len, off, len);
        return new BytesView(this.b, this.off + off, len);
    }

    public BytesView getSubset(int off) {
        return this.getSubset(off, this.len - off);
    }

    public BytesView deepClone() {
        byte[] buf = new byte[this.len];
        System.arraycopy(this.b, this.off, buf, 0, this.len);
        return new BytesView(buf, 0, this.len);
    }

    private static void checkParams(int len, int newoff, int newlen) {
        if (newoff < 0 || newlen < 0 || newoff + newlen > len) {
            throw new IndexOutOfBoundsException();
        }
    }
}

