-- Copyright (c) 2007, Andres Olarte
-- All rights reserved.
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--     -- Redistributions of source code must retain the above copyright
--       notice, this list of conditions and the following disclaimer.
--     -- Redistributions in binary form must reproduce the above copyright
--       notice, this list of conditions and the following disclaimer in the
--       documentation and/or other materials provided with the distribution.
--     -- Neither the name of the author nor the
--       names of its contributors may be used to endorse or promote products
--       derived from this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
-- EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
-- WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
-- DISCLAIMED. IN NO EVENT SHALL <copyright holder> BE LIABLE FOR ANY
-- DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
-- (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
-- LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
-- ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
-- (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--
-- PostgreSQL database dump
--
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;
--
-- Name: plu; Type: SCHEMA; Schema: -; Owner: -
--
CREATE SCHEMA plu;
SET search_path = plu, pg_catalog;
--
-- Name: detail; Type: TYPE; Schema: plu; Owner: -
--
CREATE TYPE detail AS (
	test_name text,
	passed boolean,
	msg text
);
--
-- Name: assert(anyelement, anyelement, character varying); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION assert(fix anyelement, var anyelement, msg character varying) RETURNS boolean
    AS $$DECLARE
BEGIN
	IF (fix!=var) THEN
		RAISE EXCEPTION '%, expected % but was %',msg,fix,var;
	END IF;
	IF (var IS NULL) THEN 
		IF (fix IS NOT NULL) THEN
			RAISE EXCEPTION '%, expected % but was %',msg,fix,var;
		END IF;
	END IF;
	IF (fix IS NULL) THEN 
		IF (var IS NOT NULL) THEN
			RAISE EXCEPTION '%, expected % but was %',msg,fix,var;
		END IF;
	END IF;
	RETURN true;
END$$
    LANGUAGE plpgsql;
--
-- Name: assert_exception(character varying, character varying); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION assert_exception(exp character varying, msg character varying) RETURNS void
    AS $$DECLARE
	flag boolean;
BEGIN
	flag := false;
	BEGIN	
		EXECUTE exp;
		flag:=true;
	EXCEPTION WHEN raise_exception THEN
		NULL;
	END;
	
	IF (flag) THEN
		RAISE EXCEPTION 'Exception expected but not raised: %',msg;
	END IF;
END$$
    LANGUAGE plpgsql;
--
-- Name: assert_not_null(anyelement, character varying); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION assert_not_null(var anyelement, msg character varying) RETURNS boolean
    AS $$DECLARE
BEGIN
	IF (var IS NULL) THEN
		RAISE EXCEPTION '%, expected NOT NULL but was NULL',msg;
	END IF;
	RETURN true;
END$$
    LANGUAGE plpgsql;
--
-- Name: assert_null(anyelement, character varying); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION assert_null(var anyelement, msg character varying) RETURNS boolean
    AS $$DECLARE
BEGIN
	IF (var IS NOT NULL) THEN
		RAISE EXCEPTION '%, expected NULL but was %',msg,var;
	END IF;
	RETURN true;
END$$
    LANGUAGE plpgsql;
--
-- Name: get_test_list(name, name); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION get_test_list(schema_prefix name, function_prefix name) RETURNS name[]
    AS $$DECLARE
	schema_name name;
	schema_oid oid;
	table_name name; 	
	ret name[];
BEGIN
	
	FOR schema_name, schema_oid IN SELECT nspname,oid FROM pg_catalog.pg_namespace WHERE nspname LIKE schema_prefix||'%' LOOP
		FOR table_name IN SELECT proname FROM pg_catalog.pg_proc WHERE pronamespace=schema_oid AND proname LIKE function_prefix ||'%' AND proisagg = false AND pronargs=0 LOOP
			ret:=array_append(ret,(schema_name || '.' || table_name)::name);
		END LOOP;
	END LOOP;
	RETURN ret;
END$$
    LANGUAGE plpgsql;
--
-- Name: run_bare(name, name); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION run_bare(schema_prefix name, function_prefix name) RETURNS boolean
    AS $$DECLARE
	targets name[];
	i integer;
	done boolean;
BEGIN
	targets:=plu.get_test_list(schema_prefix,function_prefix);
	FOR i IN array_lower(targets,1) .. array_upper(targets,1) LOOP
		BEGIN
			done=false;
			RAISE NOTICE '---- BEGINING %----',targets[i];
			EXECUTE ('SELECT ' || targets[i] || '();');
			RAISE NOTICE '---- FINISHING %----',targets[i];
			done=true;
			RAISE EXCEPTION 'JUST TO ROLLBACK!!!';
			
			EXCEPTION WHEN raise_exception THEN 
				IF (done=false) THEN
					RAISE EXCEPTION '---- TEST FAILED % ---- MSG: %',targets[i],SQLERRM ;
					RETURN false;
				END IF;
			
		END;
	END LOOP;
	RETURN true;
END$$
    LANGUAGE plpgsql;
--
-- Name: run_detail(name, name); Type: FUNCTION; Schema: plu; Owner: -
--
CREATE FUNCTION run_detail(schema_prefix name, function_prefix name) RETURNS SETOF detail
    AS $$DECLARE
	targets name[];
	i integer;
	done boolean;
	detail_val plu.detail;
BEGIN
	targets:=plu.get_test_list(schema_prefix,function_prefix);
	FOR i IN array_lower(targets,1) .. array_upper(targets,1) LOOP
		BEGIN
			done=false;
			RAISE NOTICE '---- BEGINING %----',targets[i];
			EXECUTE ('SELECT ' || targets[i] || '();');
			RAISE NOTICE '---- FINISHING %----',targets[i];
			done=true;
			detail_val:=ROW(targets[i],true,NULL);
			RETURN NEXT detail_val;
			RAISE EXCEPTION 'JUST TO ROLLBACK!!!';
			EXCEPTION WHEN raise_exception THEN 
				IF (done=false) THEN
					detail_val:=ROW(targets[i],false,SQLERRM);
					RETURN NEXT detail_val;
				END IF;
			
		END;
	END LOOP;
	RETURN;
END$$
    LANGUAGE plpgsql;
--
-- PostgreSQL database dump complete
--
