/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.gui;

import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sf.postgeoolap.gui.ColumnTableModel;
import net.sf.postgeoolap.gui.CriteriaDialog;
import net.sf.postgeoolap.gui.GeographicalCriteriaDialog;
import net.sf.postgeoolap.gui.LayerDisplayFrame;
import net.sf.postgeoolap.gui.MapPanel;
import net.sf.postgeoolap.gui.table.CachingResultSetTableModel;
import net.sf.postgeoolap.gui.table.ResultSetTableModel;
import net.sf.postgeoolap.gui.tree.DimensionTreeCellRenderer;
import net.sf.postgeoolap.locale.Local;
import net.sf.postgeoolap.model.Aggregation;
import net.sf.postgeoolap.model.Attribute;
import net.sf.postgeoolap.model.Cube;

public class DataAnalysisFrame
extends JFrame
implements ErrorHandler {
    private Cube cube;
    private Map dimensionMap;
    private Map attributeMap = new TreeMap();
    private Attribute attribute;
    private Map queryAttributeMap = new TreeMap();
    private Map selectAttributeMap = new TreeMap();
    private String whereString = "";
    private JTree dimensionTree;
    private DefaultTreeModel dimensionTreeModel;
    private DefaultMutableTreeNode rootNode;
    private JPanel queryCriteriaPanel;
    private JTextArea queryCriteriaArea;
    private JCheckBox viewMapCheck;
    private JButton executeButton;
    private JButton newQueryButton;
    private JButton displayButton;
    private JTable resultTable;
    private ResultSetTableModel resultSetTableModel;
    private ColumnTableModel columnTableModel;
    private MapPanel mapPanel;
    private LayerDisplayFrame layerDisplayFrame = null;
    private JPopupMenu popupMenu;
    private JMenuItem criteriaItem;
    private JMenuItem whereItem;

    public DataAnalysisFrame() {
        super(Local.getString("DataAnalysis"));
        this.initialize();
        this.buildForm();
        this.setSize(800, 600);
        this.setPreferredSize(new Dimension(800, 600));
        this.pack();
    }

    private void initialize() {
        this.rootNode = new DefaultMutableTreeNode("RootNode");
        this.dimensionTreeModel = new DefaultTreeModel(this.rootNode);
        this.dimensionTree = new JTree(this.dimensionTreeModel);
        this.dimensionTree.setRootVisible(false);
        this.dimensionTree.getSelectionModel().setSelectionMode(1);
        this.dimensionTree.setCellRenderer(new DimensionTreeCellRenderer());
        this.dimensionTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataAnalysisFrame.this.dimensionTreeDoubleClick();
                }
            }
        });
        this.dimensionTree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DataAnalysisFrame.this.showPopupMenu(e);
            }

            public void mousePressed(MouseEvent e) {
                DataAnalysisFrame.this.showPopupMenu(e);
            }
        });
        this.queryCriteriaPanel = new JPanel();
        this.queryCriteriaPanel.setBorder(BorderFactory.createTitledBorder(Local.getString("QueryCriteria")));
        this.queryCriteriaArea = new JTextArea();
        this.viewMapCheck = new JCheckBox(Local.getString("ShowResultsOnMap"));
        this.executeButton = new JButton(Local.getString("Execute"));
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAnalysisFrame.this.executeQuery();
            }
        });
        this.newQueryButton = new JButton(Local.getString("NewQuery"));
        this.newQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAnalysisFrame.this.newQuery();
            }
        });
        this.displayButton = new JButton(Local.getString("ShowDisplays"));
        this.displayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAnalysisFrame.this.showDisplay();
            }
        });
        this.columnTableModel = new ColumnTableModel();
        this.resultTable = new JTable(this.columnTableModel);
        this.mapPanel = new MapPanel(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                try {
                    DataAnalysisFrame.this.mapPanel.initJUMP();
                }
                catch (Throwable t) {
                    DataAnalysisFrame.this.handleThrowable(t);
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.criteriaItem = new JMenuItem(Local.getString("Criteria") + "...");
        this.criteriaItem.setMnemonic('C');
        this.criteriaItem.setAccelerator(KeyStroke.getKeyStroke(119, 2));
        this.criteriaItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAnalysisFrame.this.criteriaItemClick();
            }
        });
        this.popupMenu.add(this.criteriaItem);
        this.whereItem = new JMenuItem(Local.getString("WhereClause") + "...");
        this.whereItem.setMnemonic('W');
        this.whereItem.setAccelerator(KeyStroke.getKeyStroke(118, 2));
        this.whereItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAnalysisFrame.this.whereItemClick();
            }
        });
        this.popupMenu.add(this.whereItem);
    }

    private void buildForm() {
        Container container = this.getContentPane();
        JPanel panel = new JPanel();
        JScrollPane dimensionTreeScrollPane = new JScrollPane();
        dimensionTreeScrollPane.getViewport().setView(this.dimensionTree);
        dimensionTreeScrollPane.setPreferredSize(new Dimension(194, 344));
        dimensionTreeScrollPane.setSize(194, 344);
        JPanel treePanel = new JPanel();
        treePanel.add(dimensionTreeScrollPane);
        treePanel.setSize(200, 350);
        treePanel.setLocation(0, 0);
        JScrollPane resultTableScrollPane = new JScrollPane();
        resultTableScrollPane.getViewport().setView(this.resultTable);
        resultTableScrollPane.setPreferredSize(new Dimension(574, 194));
        JPanel tablePanel = new JPanel();
        tablePanel.add(resultTableScrollPane);
        tablePanel.setSize(580, 200);
        tablePanel.setLocation(200, 350);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.viewMapCheck);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.executeButton);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.newQueryButton);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.displayButton);
        JPanel mapButtonPanel = new JPanel();
        mapButtonPanel.setLayout(new BorderLayout());
        mapButtonPanel.add((Component)this.mapPanel, "Center");
        mapButtonPanel.add((Component)buttonBox, "South");
        mapButtonPanel.setSize(574, 344);
        mapButtonPanel.setLocation(200, 0);
        JScrollPane criteriaScroll = new JScrollPane();
        criteriaScroll.getViewport().setView(this.queryCriteriaArea);
        this.queryCriteriaArea.setPreferredSize(new Dimension(194, 244));
        this.queryCriteriaArea.setFont(this.viewMapCheck.getFont());
        this.queryCriteriaPanel.add(criteriaScroll);
        this.queryCriteriaPanel.setSize(200, 250);
        this.queryCriteriaPanel.setLocation(0, 350);
        panel.setLayout(null);
        panel.add((Component)treePanel, null);
        panel.add((Component)mapButtonPanel, null);
        panel.add((Component)this.queryCriteriaPanel, null);
        panel.add((Component)tablePanel, null);
        container.add(panel);
    }

    public void handleThrowable(Throwable t) {
        JOptionPane.showMessageDialog(null, "Throwable Error");
        GUIUtil.handleThrowable((Throwable)t, (Component)this);
    }

    private void showDisplay() {
        if (this.layerDisplayFrame == null) {
            this.layerDisplayFrame = new LayerDisplayFrame(this.mapPanel.getLayerNamePanel());
        }
        this.layerDisplayFrame.setVisible(true);
    }

    private void executeQuery() {
        String whereClause = this.whereString;
        if (this.queryAttributeMap.size() == 0) {
            JOptionPane.showMessageDialog(null, Local.getString("TheresNoSelectedAttributes"));
            return;
        }
        Aggregation aggregation = this.cube.queryNavigator(this.queryAttributeMap, true);
        try {
            ResultSet resultSet = this.cube.executeQuery(this.selectAttributeMap, aggregation, whereClause);
            if (resultSet.isBeforeFirst() && resultSet.isAfterLast()) {
                JOptionPane.showMessageDialog(null, Local.getString("QueryProcessingError"));
                return;
            }
            this.resultSetTableModel = new CachingResultSetTableModel(resultSet);
            this.resultTable.setModel(this.resultSetTableModel);
            if (this.viewMapCheck.isSelected()) {
                for (Attribute attribute : this.queryAttributeMap.keySet()) {
                    if (!attribute.isGeographic()) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    while (resultSet.next()) {
                        list.add(resultSet.getString(attribute.getName()));
                    }
                    this.plotGeographicAttribute(attribute, list);
                }
            }
        }
        catch (SQLException e) {
            System.out.println(Local.getString("RetrievingDataError"));
            return;
        }
    }

    public void openOLAPFrame(Cube cube) {
        if (!cube.wasProcessed()) {
            JOptionPane.showMessageDialog(null, Local.getString("SelectedCubeNotProcessed"));
            return;
        }
        this.cube = cube;
        this.mapPanel.loadData("", this.cube.getSchema().getMap());
        this.mountSchemaTree();
        this.setTitle(Local.getString("DataAnalysisCube") + ": " + this.cube.getName());
        this.setVisible(true);
    }

    public void mountSchemaTree() {
        this.rootNode.removeAllChildren();
        if (this.cube == null) {
            return;
        }
        this.dimensionMap = this.cube.getDimensions();
        DefaultMutableTreeNode dimensionRootNode = new DefaultMutableTreeNode(Local.getString("Dimensions"));
        Iterator iterator = this.dimensionMap.keySet().iterator();
        while (iterator.hasNext()) {
            net.sf.postgeoolap.model.Dimension dimension = (net.sf.postgeoolap.model.Dimension)this.dimensionMap.get(iterator.next());
            DefaultMutableTreeNode currentDimensionNode = new DefaultMutableTreeNode(dimension);
            Map tempAttributeMap = dimension.getAttributeList();
            Iterator iterator2 = tempAttributeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)tempAttributeMap.get(iterator2.next());
                currentDimensionNode.add(new DefaultMutableTreeNode(attribute));
                if (!this.attributeMap.keySet().contains(attribute.getName())) {
                    this.attributeMap.put(attribute.getName(), attribute);
                    continue;
                }
                JOptionPane.showMessageDialog(null, Local.getString("AttributesHavingSameName"));
                this.rootNode.removeAllChildren();
                return;
            }
            dimensionRootNode.add(currentDimensionNode);
        }
        this.rootNode.add(dimensionRootNode);
        this.dimensionTreeModel.reload();
    }

    private void dimensionTreeDoubleClick() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.dimensionTree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        if (selectedNode.getUserObject() instanceof Attribute) {
            Attribute attribute = (Attribute)selectedNode.getUserObject();
            this.queryAttributeMap.put(attribute.getName(), attribute);
            this.selectAttributeMap.put(attribute.getName(), attribute);
            this.columnTableModel.addColumn(attribute.getName());
        }
    }

    private void newQuery() {
        this.attributeMap.clear();
        this.selectAttributeMap.clear();
        this.whereString = "";
        this.queryCriteriaArea.setText("");
        this.columnTableModel.clear();
        this.resultTable.setModel(this.columnTableModel);
    }

    private void showPopupMenu(MouseEvent e) {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.dimensionTree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            this.criteriaItem.setEnabled(false);
        } else {
            this.criteriaItem.setEnabled(selectedNode.getUserObject() instanceof Attribute);
        }
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void criteriaItemClick() {
        String newWhere;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.dimensionTree.getLastSelectedPathComponent();
        this.attribute = (Attribute)selectedNode.getUserObject();
        String dimensionName = this.attribute.getTable().getName();
        net.sf.postgeoolap.model.Dimension dimension = (net.sf.postgeoolap.model.Dimension)this.dimensionMap.get(dimensionName);
        if (dimension.getType().equals("NonAggregable")) {
            JOptionPane.showMessageDialog(null, Local.getString("OnlyAggregableDimensions"));
            return;
        }
        if (this.attribute.isGeographic()) {
            GeographicalCriteriaDialog geographicCriteriaFrame = new GeographicalCriteriaDialog();
            newWhere = geographicCriteriaFrame.addWhereClause(this.attribute, this.whereString, this.dimensionMap, this.cube.getSchema().getSrid());
        } else {
            CriteriaDialog criteriaFrame = new CriteriaDialog();
            newWhere = criteriaFrame.addWhereClause(this.attribute, this.whereString);
        }
        if ("".equals(newWhere) || newWhere == null) {
            return;
        }
        if (!"".equals(this.whereString) && this.whereString != null) {
            this.whereString = this.whereString + "\n";
        }
        this.whereString = this.whereString + newWhere;
        this.queryCriteriaArea.setText(this.whereString);
        this.queryAttributeMap.put(this.attribute.getName(), this.attribute);
        this.columnTableModel.addColumn(this.attribute.getName());
    }

    private void whereItemClick() {
        String newWhere = JOptionPane.showInputDialog(null, (Object)Local.getString("EnterWhereClause"));
        if (!"".equals(newWhere) && newWhere != null && JOptionPane.showConfirmDialog(null, Local.getString("ReplaceWhereClausePt1") + "\n" + this.whereString + "\n" + Local.getString("ReplaceWhereClausePt2") + "\n" + newWhere + "?", "PostGeoOLAP", 0) == 0) {
            this.whereString = newWhere;
            this.queryCriteriaArea.setText(this.whereString);
        }
    }

    private void plotGeographicAttribute(Attribute attribute, List list) {
        this.mapPanel.plotAttribute(attribute, list);
    }
}

