/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import net.sf.postgeoolap.gui.HierarchyTableModel;
import net.sf.postgeoolap.gui.OkCancelDialog;
import net.sf.postgeoolap.locale.Local;
import net.sf.postgeoolap.model.Attribute;
import net.sf.postgeoolap.model.Cube;
import net.sf.postgeoolap.model.Dimension;

public class HierarchySelectionDialog
extends OkCancelDialog {
    private Dimension dimension;
    private JTextArea explainArea;
    private JTable hierarchyTable;
    private HierarchyTableModel hierarchyTableModel;
    private JScrollPane scroll;

    public HierarchySelectionDialog() {
        super(Local.getString("SelectHierarchy"));
        this.guiMount();
    }

    protected void initialize() {
        super.initialize();
        this.explainArea = new JTextArea(Local.getString("SelectHierarchyText"), 4, 40);
        this.hierarchyTable = new JTable(new HierarchyTableModel(new TreeMap()));
        this.scroll = new JScrollPane(this.hierarchyTable, 20, 30);
    }

    protected void build() {
        JPanel panel = this.getPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.explainArea.setLineWrap(true);
        this.explainArea.setWrapStyleWord(true);
        this.explainArea.setBackground(panel.getBackground());
        this.explainArea.setFont(this.hierarchyTable.getFont());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 3, 10);
        panel.add((Component)this.explainArea, gbc);
        this.hierarchyTable.setCellSelectionEnabled(true);
        this.hierarchyTable.setEditingColumn(1);
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 10, 10, 10);
        panel.add((Component)this.scroll, gbc);
        this.pack();
    }

    protected void okAction(ActionEvent e) {
        if (Attribute.saveAttributeSet(this.hierarchyTableModel.getMap())) {
            JOptionPane.showMessageDialog(null, Local.getString("HierarchyRecordedSuccessfully"));
        } else {
            JOptionPane.showMessageDialog(null, Local.getString("HierarchyRecordingError"));
        }
        this.setVisible(false);
        this.dispose();
    }

    protected void cancelAction() {
        this.setVisible(false);
        this.dispose();
    }

    public void selectDimensionLevel(Cube cube, Dimension dimension) {
        this.dimension = dimension;
        Map attributeMap = Attribute.getAttributeSet(this.dimension);
        this.hierarchyTableModel = new HierarchyTableModel(attributeMap);
        this.setTitle(Local.getString("SelectHierarchy") + " - " + Local.getString("Dimension") + ": " + this.dimension.getName());
        this.hierarchyTable.setModel(this.hierarchyTableModel);
        this.setVisible(true);
    }
}

