/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.locale;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Local {
    private static Locale locale;
    private static ResourceBundle resources;

    public static void setLocale(String language, String country) {
        locale = new Locale(language, country);
        Local.loadResources();
    }

    private static void initialize() {
        locale = Locale.getDefault();
        Local.loadResources();
    }

    private static void loadResources() {
        try {
            resources = ResourceBundle.getBundle("net.sf.postgeoolap.locale.Resources", locale);
        }
        catch (MissingResourceException e) {
            resources = ResourceBundle.getBundle("net.sf.postgeoolap.locale.Resources", Locale.ENGLISH);
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    public static String getString(String key) {
        if (locale == null) {
            Local.initialize();
        }
        return resources.getString(key);
    }

    public static Object getObject(String key) {
        if (locale == null) {
            Local.initialize();
        }
        return resources.getObject(key);
    }
}

