/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import net.sf.postgeoolap.connect.DBConnection;
import net.sf.postgeoolap.gui.OutputProgress;
import net.sf.postgeoolap.locale.Local;
import net.sf.postgeoolap.model.Aggregation;
import net.sf.postgeoolap.model.Attribute;
import net.sf.postgeoolap.model.Dimension;
import net.sf.postgeoolap.model.Schema;

public class Cube {
    private int code;
    private String name;
    private Schema schema;
    private Map aggregationsCache;
    private long minimumAggregation;
    public static final int MAX_LEVEL = 9;

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Map getDimensions() {
        return Dimension.getDimensionList(this);
    }

    public Map getAggregations() {
        return Aggregation.getAggregationList(this);
    }

    public Map getAggregationsCache() {
        return this.aggregationsCache == null ? this.getAggregations() : this.aggregationsCache;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getMinimumAggregation() {
        return this.minimumAggregation;
    }

    public void retrieve(Schema schema, long code) {
        String sql = "SELECT * FROM cubo WHERE cubecode = " + code;
        this.retrieveSQL(schema, sql);
    }

    public void retrieve(Schema schema, String name) {
        String sql = "SELECT * FROM cubo WHERE name = '" + name + "'";
        this.retrieveSQL(schema, sql);
    }

    private void retrieveSQL(Schema schema, String sql) {
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                this.code = resultSet.getInt("cubecode");
                this.name = resultSet.getString("name");
                this.schema = schema;
                this.minimumAggregation = resultSet.getLong("MinimumAggregation");
            }
            resultSet.close();
        }
        catch (SQLException e) {
            System.out.println(Local.getString("CubeRetrievingError"));
            e.printStackTrace(System.err);
        }
    }

    public boolean create(Schema schema, String name) {
        return this.create(schema, name, 0L);
    }

    public boolean create(Schema schema, String name, long minimumAggregation) {
        String sql = "INSERT INTO cubo (name, schemacode, minimumaggregation) VALUES ('" + name + "', " + schema.getCode() + ", " + minimumAggregation + ")";
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            System.err.println(Local.getString("CubeRecordingError"));
            e.printStackTrace(System.err);
            return false;
        }
        this.retrieve(schema, name);
        return true;
    }

    public boolean delete() {
        String sql = "DELETE FROM cubo WHERE cubecode = " + this.getCode();
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            statement.execute(sql);
            return true;
        }
        catch (SQLException e) {
            System.err.println(Local.getString("CubeDeletingError"));
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static Map getCubeList(Schema schema) {
        String sql = "SELECT * FROM cubo WHERE schemacode = " + schema.getCode();
        TreeMap<String, Cube> map = new TreeMap<String, Cube>();
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                Cube cube = new Cube();
                cube.code = resultSet.getInt(1);
                cube.name = resultSet.getString(2);
                cube.minimumAggregation = resultSet.getLong(4);
                cube.schema = schema;
                map.put(cube.getName(), cube);
            }
            resultSet.close();
            return map;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public boolean addDimension(String dimensionName, String dimensionType, String dimensionSQL, String dimensionClause, long tableCode) {
        Dimension dimension = new Dimension();
        return dimension.create(this, dimensionName, dimensionType, dimensionSQL, dimensionClause, tableCode);
    }

    public Dimension getFactDimension() {
        Map dimensionMap = this.getDimensions();
        Iterator iterator = dimensionMap.keySet().iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)dimensionMap.get((String)iterator.next());
            if (!dimension.getType().equals("Fact")) continue;
            return dimension;
        }
        return null;
    }

    public ArrayList getNonFactDimensions() {
        Map dimensions = this.getDimensions();
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        Iterator iterator = dimensions.keySet().iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)dimensions.get((String)iterator.next());
            if (!dimension.getType().equals("Dimension")) continue;
            arrayList.add(dimension);
        }
        return arrayList;
    }

    public Aggregation queryNavigator(Map attributeCollection, boolean cache) {
        Map aggregationCollection = cache ? this.getAggregationsCache() : this.getAggregations();
        Aggregation baseAggregation = null;
        Iterator iterator = aggregationCollection.keySet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute;
            Attribute attrib2;
            Aggregation aggregation = (Aggregation)aggregationCollection.get((String)iterator.next());
            if (aggregation.isBasic()) {
                baseAggregation = aggregation;
                continue;
            }
            ArrayList<Attribute> matchList = new ArrayList<Attribute>();
            Map attributeMap = aggregation.getAttributes();
            Iterator iterator2 = attributeCollection.keySet().iterator();
            while (iterator2.hasNext() && (attrib2 = (Attribute)attributeMap.get((attribute = (Attribute)attributeCollection.get(iterator2.next())).getName())) != null) {
                matchList.add(attrib2);
                if (matchList.size() != attributeCollection.size()) continue;
                return aggregation;
            }
        }
        return baseAggregation;
    }

    public boolean wasProcessed() {
        return this.getAggregations().size() > 0;
    }

    public ResultSet executeQuery(Map attributeMap, Aggregation aggregation, String whereClause) throws SQLException {
        Attribute attribute;
        Iterator iterator;
        int aggregableQuantity = 0;
        String sql = "SELECT ";
        String attributeName = "";
        if (aggregation.isBasic()) {
            iterator = attributeMap.keySet().iterator();
            while (iterator.hasNext()) {
                attribute = (Attribute)attributeMap.get(iterator.next());
                if (attribute.getAggregationType().equals("R")) {
                    attributeName = attribute.getTable().getName() + "." + attribute.getName();
                } else if (attribute.getAggregationType().equals("S")) {
                    attributeName = "SUM(" + attribute.getTable().getName() + "." + attribute.getName() + ") AS SUM_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("C")) {
                    attributeName = "COUNT(" + attribute.getTable().getName() + "." + attribute.getName() + ") AS COUNT_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("A")) {
                    attributeName = "AVG(" + attribute.getTable().getName() + "." + attribute.getName() + ") AS AVG_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("M")) {
                    attributeName = "MAX(" + attribute.getTable().getName() + "." + attribute.getName() + ") AS MAX_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("I")) {
                    attributeName = "MIN(" + attribute.getTable().getName() + "." + attribute.getName() + ") AS MIN_" + attribute.getName();
                }
                if (!sql.endsWith("SELECT ")) {
                    sql = sql + ", ";
                }
                sql = sql + attributeName;
                if (!attribute.getAggregationType().equals("R")) continue;
                ++aggregableQuantity;
            }
        } else {
            iterator = attributeMap.keySet().iterator();
            while (iterator.hasNext()) {
                attribute = (Attribute)attributeMap.get(iterator.next());
                if (attribute.getAggregationType().equals("R")) {
                    attributeName = aggregation.getName() + "." + attribute.getName();
                } else if (attribute.getAggregationType().equals("S")) {
                    attributeName = "SUM(" + aggregation.getName() + "." + attribute.getName() + ") AS SUM_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("C")) {
                    attributeName = "COUNT(" + aggregation.getName() + "." + attribute.getName() + ") AS COUNT_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("A")) {
                    attributeName = "AVG(" + aggregation.getName() + "." + attribute.getName() + ") AS AVG_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("M")) {
                    attributeName = "MAX(" + aggregation.getName() + "." + attribute.getName() + ") AS MAX_" + attribute.getName();
                } else if (attribute.getAggregationType().equals("I")) {
                    attributeName = "MIN(" + aggregation.getName() + "." + attribute.getName() + ") AS MIN_" + attribute.getName();
                }
                if (!sql.endsWith("SELECT ")) {
                    sql = sql + ", ";
                }
                sql = sql + attributeName;
                if (!attribute.getAggregationType().equals("R")) continue;
                ++aggregableQuantity;
            }
        }
        sql = aggregation.isBasic() ? sql + " " + aggregation.getSQLBase() : sql + " FROM " + aggregation.getName();
        if (whereClause != null && !whereClause.equals("")) {
            sql = aggregation.isBasic() ? sql + " AND (" + whereClause : sql + " WHERE (" + whereClause;
            sql = sql + ")";
        }
        if (aggregableQuantity > 0) {
            sql = sql + " GROUP BY ";
            if (aggregation.isBasic()) {
                iterator = attributeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    attribute = (Attribute)attributeMap.get(iterator.next());
                    if (!attribute.getAggregationType().equals("R")) continue;
                    if (!sql.endsWith("GROUP BY ")) {
                        sql = sql + ", ";
                    }
                    sql = sql + attribute.getTable().getName() + "." + attribute.getName();
                }
            } else {
                iterator = attributeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    attribute = (Attribute)attributeMap.get(iterator.next());
                    if (!attribute.getAggregationType().equals("R")) continue;
                    if (!sql.endsWith("GROUP BY ")) {
                        sql = sql + ", ";
                    }
                    sql = sql + aggregation.getName() + "." + attribute.getName();
                }
            }
        }
        Statement statement = DBConnection.getPostGreSQLConnection().createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        return resultSet;
    }

    public void process(OutputProgress output) {
        output.addString(Local.getString("DeletingPreExistingAggregations"));
        Map aggregationMap = this.getAggregations();
        Iterator iterator = aggregationMap.keySet().iterator();
        while (iterator.hasNext()) {
            Aggregation aggregation = (Aggregation)aggregationMap.get((String)iterator.next());
            if (aggregation.deleteCubeAggregation(this)) continue;
            output.addString(Local.getString("DeletingAggregationError"));
        }
        output.addString(Local.getString("AgregationsDeleted"));
        output.addString(Local.getString("GeneratingBaseAggregation"));
        if (!Aggregation.createBasicAggregation(this)) {
            output.addString(Local.getString("BasicAggregationCreatingError"));
            return;
        }
        ArrayList dimensionList = this.getNonFactDimensions();
        int dimensionCount = dimensionList.size();
        output.addString(Local.getString("CurrentCubeHas") + " " + dimensionCount + " " + Local.getString("dimensions"));
        if (dimensionCount < 2) {
            output.addString(Local.getString("LessThanTwoDimensions"));
            return;
        }
        Dimension _d = this.getFactDimension();
        Map map = _d.getFactAggregableAttributes();
        ArrayList<Attribute> factAttributeList = new ArrayList<Attribute>();
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)map.get((String)iterator.next());
            factAttributeList.add(attribute);
        }
        Stack stackList = new Stack();
        Dimension dimension1 = (Dimension)dimensionList.get(0);
        System.out.println("A dimensao 1 e (pelo codigo): " + dimension1.getTableCode());
        int levelNumber = dimension1.getMinimumHierarchicalRank();
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(0));
        stackList.add(stack);
        for (int i = levelNumber; i <= 9; ++i) {
            stack = new Stack();
            stack.push(new Integer(i));
            stackList.add(stack);
        }
        while (stackList.size() != 0) {
            int j;
            int i;
            Stack activeStack = (Stack)stackList.pop();
            if (activeStack.size() == dimensionCount) {
                Attribute attribute;
                int i2;
                boolean canProcess = false;
                String sortingName = "";
                for (i = 0; i < activeStack.size() - 1; ++i) {
                    if ((Integer)activeStack.get(i) == 9) continue;
                    canProcess = true;
                    break;
                }
                if (!canProcess) continue;
                TreeMap<String, Attribute> attributeMap = new TreeMap<String, Attribute>();
                String aggregationName = "";
                for (i2 = 0; i2 < factAttributeList.size(); ++i2) {
                    attribute = (Attribute)factAttributeList.get(i2);
                    attributeMap.put(attribute.getName(), attribute);
                }
                for (i2 = 0; i2 < activeStack.size(); ++i2) {
                    Dimension posDimension = (Dimension)dimensionList.get(i2);
                    int pos = (Integer)activeStack.get(i2);
                    sortingName = sortingName + Integer.toString(pos).trim();
                    map = posDimension.getAttributesByLevel(pos);
                    iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        attribute = (Attribute)map.get((String)iterator.next());
                        attributeMap.put(attribute.getName(), attribute);
                    }
                }
                int sorting = Integer.parseInt(sortingName);
                aggregationName = this.getName() + sortingName;
                output.addString(Local.getString("CheckingCostBenefitRelation") + " " + aggregationName + "...");
                Aggregation referenceAggregation = this.verifyAggregationCost(attributeMap);
                if (!referenceAggregation.getName().equals("")) {
                    output.addString(Local.getString("CreatingAggregation") + " " + aggregationName);
                    Aggregation aggregation = new Aggregation();
                    if (!aggregation.create(aggregationName, attributeMap, this, sorting)) {
                        output.addString(Local.getString("CreationOfAggregation") + " " + aggregationName + " " + Local.getString("failed"));
                        return;
                    }
                    output.addString(Local.getString("Aggregation") + " " + aggregationName + " " + Local.getString("CreatedSuccessfully"));
                    output.addString(Local.getString("CopyingDataToAggregation"));
                    if (aggregation.loadData(referenceAggregation)) {
                        output.addString(Local.getString("DataCopiedTo") + " " + aggregation.getName() + " " + Local.getString("successfully"));
                    } else {
                        output.addString(Local.getString("CopyOfDataToAggregation") + " " + aggregation.getName() + " " + Local.getString("failed"));
                    }
                    output.addString(Local.getString("CreatingIndexesToAggregation") + " " + aggregation.getName());
                    if (aggregation.createIndexes()) {
                        output.addString(Local.getString("IndexesCreatedTo") + " " + aggregation.getName() + " " + Local.getString("successfully"));
                    } else {
                        output.addString(Local.getString("CreatingOfIndexesToAggregation"));
                    }
                    String optimize = "VACUUM ANALYZE " + aggregation.getName();
                    output.addString(Local.getString("UpdatingStatisticsForAggregation") + " " + aggregation.getName());
                    try {
                        Statement statement = DBConnection.getPostGreSQLConnection().createStatement();
                        statement.execute(optimize);
                    }
                    catch (SQLException e) {
                        System.err.println(Local.getString("StatisticsUpdatingError"));
                        e.printStackTrace(System.err);
                    }
                    output.addString(Local.getString("StatisticsSuccessfullyUpdated"));
                    continue;
                }
                output.addString(Local.getString("LowCostBenefitRelation") + " " + aggregationName);
                continue;
            }
            int nextDimension = activeStack.size();
            Dimension activeDimension = (Dimension)dimensionList.get(nextDimension);
            for (i = levelNumber = activeDimension.getMinimumHierarchicalRank(); i <= 9; ++i) {
                Stack s = new Stack();
                for (j = 0; j < activeStack.size(); ++j) {
                    s.push(activeStack.get(j));
                }
                s.push(new Integer(i));
                stackList.add(s);
            }
            Stack stackTemp = new Stack();
            for (j = 0; j < activeStack.size(); ++j) {
                stackTemp.push(activeStack.get(j));
            }
            stackTemp.push(new Integer(0));
            stackList.add(stackTemp);
        }
        output.addString(Local.getString("EndOfCubeProcessing"));
    }

    public Aggregation verifyAggregationCost(Map map) {
        Aggregation aggregation = this.queryNavigator(map, false);
        Dimension dimension = null;
        String factName = "";
        String sql = "";
        int tupleCount = 0;
        if (aggregation.isBasic()) {
            dimension = this.getFactDimension();
            factName = dimension.getName();
            sql = "SELECT COUNT(*) FROM " + factName;
        } else {
            sql = "SELECT COUNT(*) FROM " + aggregation.getName();
        }
        try {
            Statement statement = DBConnection.getPostGreSQLConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            tupleCount = resultSet.getInt(1);
            resultSet.close();
        }
        catch (SQLException e) {
            System.out.println(Local.getString("UnknownSQLException"));
            e.printStackTrace(System.err);
        }
        if ((long)tupleCount <= this.minimumAggregation) {
            return new Aggregation();
        }
        return aggregation;
    }

    public String toString() {
        return this.getName();
    }
}

