/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class WKTWriter
implements JUMPWriter {
    private com.vividsolutions.jts.io.WKTWriter wktWriter = new com.vividsolutions.jts.io.WKTWriter();

    public void write(FeatureCollection featureCollection, DriverProperties dp) throws IllegalParametersException, Exception {
        String outputFname = dp.getProperty("File");
        if (outputFname == null) {
            outputFname = dp.getProperty("DefaultValue");
        }
        if (outputFname == null) {
            throw new IllegalParametersException("call to WKTWrite.write() has DataProperties w/o a OutputFile specified");
        }
        FileWriter w = new FileWriter(outputFname);
        this.write(featureCollection, w);
        ((Writer)w).close();
    }

    public void write(FeatureCollection featureCollection, Writer writer) throws IOException {
        Iterator i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            this.wktWriter.writeFormatted(feature.getGeometry(), writer);
            if (!i.hasNext()) continue;
            writer.write("\n\n");
        }
    }
}

