/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.ColumnBasedTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class LayerTableModel
extends ColumnBasedTableModel {
    private Layer layer;
    private ArrayList features = new ArrayList();
    private String sortedColumnName = null;
    private boolean sortAscending = false;
    private ColumnBasedTableModel.Column fidColumn = new MyColumn("FID", class$java$lang$Integer == null ? (class$java$lang$Integer = LayerTableModel.class$("java.lang.Integer")) : class$java$lang$Integer){

        protected Object getValue(Feature feature) {
            return new Integer(feature.getID());
        }

        protected void setValue(Object value, Feature feature) {
            Assert.shouldNeverReachHere();
        }
    };
    private ColumnBasedTableModel.Column buttonColumn = new MyColumn(" ", null){

        protected Object getValue(Feature feature) {
            return null;
        }

        protected void setValue(Object value, Feature feature) {
            Assert.shouldNeverReachHere();
        }
    };
    private FeatureSchema schema;
    private LayerListener layerListener = new LayerListener(){

        public void categoryChanged(CategoryEvent e) {
        }

        public void featuresChanged(FeatureEvent e) {
            if (e.getLayer() != LayerTableModel.this.getLayer()) {
                return;
            }
            if (e.getType() == FeatureEventType.DELETED) {
                LayerTableModel.this.removeAll(e.getFeatures());
            }
            if (e.getType() == FeatureEventType.ATTRIBUTES_MODIFIED) {
                Iterator i = e.getFeatures().iterator();
                while (i.hasNext()) {
                    Feature feature = (Feature)i.next();
                    int row = LayerTableModel.this.getFeatures().indexOf(feature);
                    if (row == -1) continue;
                    LayerTableModel.this.fireTableChanged(new TableModelEvent(LayerTableModel.this, row, row));
                }
            }
        }

        public void layerChanged(LayerEvent e) {
            if (e.getLayerable() != LayerTableModel.this.getLayer()) {
                return;
            }
            if (e.getType() == LayerEventType.METADATA_CHANGED && !LayerTableModel.this.schema.equals(LayerTableModel.this.layer.getFeatureCollectionWrapper().getFeatureSchema(), true)) {
                LayerTableModel.this.initColumns(LayerTableModel.this.layer);
                LayerTableModel.this.fireTableChanged(new TableModelEvent(LayerTableModel.this, -1));
            }
        }
    };
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public LayerTableModel(Layer layer) {
        this.layer = layer;
        layer.getLayerManager().addLayerListener(this.layerListener);
        this.initColumns(layer);
    }

    private void initColumns(final Layer layer) {
        this.schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(this.buttonColumn);
        columns.add(this.fidColumn);
        for (int i = 0; i < this.schema.getAttributeCount(); ++i) {
            if (this.schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            final int j = i;
            columns.add(new MyColumn(this.schema.getAttributeName(i), this.schema.getAttributeType(i).toJavaClass()){

                protected Object getValue(Feature feature) {
                    Object value = null;
                    try {
                        value = feature.getAttribute(j);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        ex.printStackTrace();
                    }
                    return value;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void setValue(Object value, Feature feature) {
                    Feature oldAttributes = (Feature)feature.clone();
                    Feature newAttributes = (Feature)feature.clone();
                    newAttributes.setAttribute(j, value);
                    layer.getLayerManager().getUndoableEditReceiver().startReceiving();
                    try {
                        UndoableCommand command = new UndoableCommand(this, "Edit " + LayerTableModel.this.schema.getAttributeName(j), feature, newAttributes, oldAttributes){
                            private final /* synthetic */ Feature val$feature;
                            private final /* synthetic */ Feature val$newAttributes;
                            private final /* synthetic */ Feature val$oldAttributes;
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$feature = val$feature;
                                this.val$newAttributes = val$newAttributes;
                                this.val$oldAttributes = val$oldAttributes;
                            }

                            public void execute() {
                                LayerTableModel.access$400(4.access$300(this.this$1), this.val$feature, this.val$newAttributes);
                            }

                            public void unexecute() {
                                LayerTableModel.access$400(4.access$300(this.this$1), this.val$feature, this.val$oldAttributes);
                            }
                        };
                        command.execute();
                        layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
                    }
                    finally {
                        layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
                    }
                }

                static /* synthetic */ LayerTableModel access$300(4 x0) {
                    return x0.LayerTableModel.this;
                }
            });
        }
        this.setColumns(columns);
    }

    private void setAttributesOf(Feature feature, Feature attributes) {
        Feature oldClone = (Feature)feature.clone();
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            feature.setAttribute(i, attributes.getAttribute(i));
        }
        this.layer.getLayerManager().fireFeaturesChanged(Arrays.asList(feature), FeatureEventType.ATTRIBUTES_MODIFIED, this.layer);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Feature getFeature(int row) {
        return (Feature)this.features.get(row);
    }

    public int getRowCount() {
        return this.features.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.layer.isEditable()) {
            return false;
        }
        if (this.getColumn(columnIndex) == this.fidColumn) {
            return false;
        }
        return this.getColumn(columnIndex) != this.buttonColumn;
    }

    public void clear() {
        this.features.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void removeAll(Collection featuresToRemove) {
        Iterator i = featuresToRemove.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            int row = this.features.indexOf(feature);
            if (row == -1) continue;
            this.features.remove(row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }
    }

    public void addAll(Collection newFeatures) {
        int originalFeaturesSize = this.features.size();
        this.features.addAll(newFeatures);
        if (this.sortedColumnName != null) {
            this.sort(this.sortedColumnName, this.sortAscending);
        }
        this.fireTableChanged(new TableModelEvent(this, originalFeaturesSize, this.features.size() - 1, -1, 1));
    }

    public void dispose() {
        this.layer.getLayerManager().removeLayerListener(this.layerListener);
        this.features.clear();
    }

    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public String getSortedColumnName() {
        return this.sortedColumnName;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void sort(String columnName) {
        this.sort(columnName, columnName.equals(this.sortedColumnName) ? !this.sortAscending : true);
    }

    public void sort(String columnName, final boolean ascending) {
        this.sortAscending = ascending;
        this.sortedColumnName = columnName;
        final int column = this.indexOfColumn(columnName);
        Collections.sort(this.features, new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.ascendingCompare(o1, o2) * (ascending ? 1 : -1);
            }

            private int ascendingCompare(Object o1, Object o2) {
                Feature f1 = (Feature)o1;
                Feature f2 = (Feature)o2;
                Comparable attribute1 = (Comparable)((MyColumn)LayerTableModel.this.getColumn(column)).getValue(f1);
                Comparable attribute2 = (Comparable)((MyColumn)LayerTableModel.this.getColumn(column)).getValue(f2);
                if (attribute1 == null) {
                    return -1;
                }
                if (attribute2 == null) {
                    return 1;
                }
                return attribute1.compareTo(attribute2);
            }
        });
    }

    public String getType(int column) {
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new JTable().getDefaultEditor(class$java$util$Date == null ? (class$java$util$Date = LayerTableModel.class$("java.util.Date")) : class$java$util$Date));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$400(LayerTableModel x0, Feature x1, Feature x2) {
        x0.setAttributesOf(x1, x2);
    }

    private abstract class MyColumn
    extends ColumnBasedTableModel.Column {
        public MyColumn(String name, Class dataClass) {
            super(name, dataClass);
        }

        public Object getValueAt(int rowIndex) {
            return this.getValue(LayerTableModel.this.getFeature(rowIndex));
        }

        public void setValueAt(Object value, int rowIndex) {
            this.setValue(value, LayerTableModel.this.getFeature(rowIndex));
        }

        protected abstract Object getValue(Feature var1);

        protected abstract void setValue(Object var1, Feature var2);
    }
}

