/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;

public abstract class CompositeTool
implements CursorTool {
    protected ArrayList cursorTools = new ArrayList();
    private LayerViewPanel panel = null;

    public CompositeTool(CursorTool[] cursorTools) {
        this.cursorTools = new ArrayList<CursorTool>(Arrays.asList(cursorTools));
    }

    public void deactivate() {
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool tool = (CursorTool)i.next();
            tool.deactivate();
        }
    }

    public Cursor getCursor() {
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool cursorTool = (CursorTool)i.next();
            if (cursorTool.getCursor() == Cursor.getDefaultCursor()) continue;
            return cursorTool.getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    public boolean isRightMouseButtonUsed() {
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool cursorTool = (CursorTool)i.next();
            if (!cursorTool.isRightMouseButtonUsed()) continue;
            return true;
        }
        return false;
    }

    protected CursorTool firstCursorTool() {
        return (CursorTool)this.cursorTools.get(0);
    }

    public void activate(LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool tool = (CursorTool)i.next();
            tool.activate(layerViewPanel);
        }
    }

    public CompositeTool add(CursorTool tool) {
        this.cursorTools.add(tool);
        return this;
    }

    public void cancelGesture() {
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool tool = (CursorTool)i.next();
            tool.cancelGesture();
        }
    }

    public Icon getIcon() {
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool tool = (CursorTool)i.next();
            if (tool.getIcon() == null) continue;
            return tool.getIcon();
        }
        return null;
    }

    protected String getName(String delimiter) {
        String name = "";
        for (int i = 0; i < this.cursorTools.size(); ++i) {
            if (i > 0) {
                name = name + " " + delimiter + " ";
            }
            name = name + ((CursorTool)this.cursorTools.get(i)).getName();
        }
        return name;
    }

    public boolean isGestureInProgress() {
        Iterator i = this.cursorTools.iterator();
        while (i.hasNext()) {
            CursorTool tool = (CursorTool)i.next();
            if (!tool.isGestureInProgress()) continue;
            return true;
        }
        return false;
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }
}

