/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public abstract class SelectTool
extends DragTool {
    private String rendererID;
    protected AbstractSelection selection;

    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public void mouseClicked(MouseEvent e) {
        try {
            super.mouseClicked(e);
            this.setViewSource(e.getPoint());
            this.setViewDestination(e.getPoint());
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        if (!this.wasShiftPressed()) {
            this.getPanel().getSelectionManager().clear();
        }
        Map layerToFeaturesInFenceMap = this.getPanel().visibleLayerToFeaturesInFenceMap(EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates()));
        Set layers = layerToFeaturesInFenceMap.keySet();
        if (this.selectedLayersOnly()) {
            layers.retainAll(Arrays.asList(this.getTaskFrame().getLayerNamePanel().getSelectedLayers()));
        }
        Iterator i = layers.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (layer.getName().equals("Fence")) continue;
            boolean originalPanelUpdatesEnabled = this.getPanel().getSelectionManager().arePanelUpdatesEnabled();
            this.getPanel().getSelectionManager().setPanelUpdatesEnabled(false);
            try {
                CollectionMap featureToItemsToSelectMap = this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, false);
                CollectionMap featureToItemsToUnselectMap = this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, true);
                this.selection.selectItems(layer, featureToItemsToSelectMap);
                if (this.wasShiftPressed()) {
                    this.selection.unselectItems(layer, featureToItemsToUnselectMap);
                }
                this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, true);
            }
            finally {
                this.getPanel().getSelectionManager().setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
            }
        }
        this.getPanel().getSelectionManager().updatePanel();
    }

    protected boolean selectedLayersOnly() {
        return this.wasControlPressed();
    }

    protected SelectTool(String rendererID) {
        this.rendererID = rendererID;
    }

    private CollectionMap featureToItemsInFenceMap(Collection features, Layer layer, boolean selected) throws NoninvertibleTransformException {
        CollectionMap featureToSelectedItemsMap = this.selection.getFeatureToSelectedItemCollectionMap(layer);
        CollectionMap featureToItemsInFenceMap = new CollectionMap();
        Iterator i = features.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            Collection selectedItems = featureToSelectedItemsMap.getItems(feature);
            Collection itemsToReturn = this.itemsInFence(feature);
            if (selected) {
                itemsToReturn.retainAll(selectedItems);
            } else {
                itemsToReturn.removeAll(selectedItems);
            }
            featureToItemsInFenceMap.put(feature, itemsToReturn);
        }
        return featureToItemsInFenceMap;
    }

    private Collection itemsInFence(Feature feature) throws NoninvertibleTransformException {
        ArrayList<Geometry> itemsInFence = new ArrayList<Geometry>();
        Geometry fence = EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates());
        Iterator i = this.selection.items(feature.getGeometry()).iterator();
        while (i.hasNext()) {
            Geometry selectedItem = (Geometry)i.next();
            if (!LayerViewPanel.intersects(selectedItem, fence)) continue;
            itemsInFence.add(selectedItem);
        }
        return itemsInFence;
    }

    public Icon getIcon() {
        return null;
    }
}

