/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class MinimumDiameter {
    private final Geometry inputGeom;
    private final boolean isConvex;
    private LineSegment minBaseSeg = new LineSegment();
    private Coordinate minWidthPt = null;
    private int minPtIndex;
    private double minWidth = 0.0;

    public MinimumDiameter(Geometry geometry) {
        this(geometry, false);
    }

    public MinimumDiameter(Geometry geometry, boolean bl) {
        this.inputGeom = geometry;
        this.isConvex = bl;
    }

    public double getLength() {
        this.computeMinimumDiameter();
        return this.minWidth;
    }

    public Coordinate getWidthCoordinate() {
        this.computeMinimumDiameter();
        return this.minWidthPt;
    }

    public LineString getSupportingSegment() {
        this.computeMinimumDiameter();
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{this.minBaseSeg.p0, this.minBaseSeg.p1});
    }

    public LineString getDiameter() {
        this.computeMinimumDiameter();
        if (this.minWidthPt == null) {
            return this.inputGeom.getFactory().createLineString((Coordinate[])null);
        }
        Coordinate coordinate = this.minBaseSeg.project(this.minWidthPt);
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{coordinate, this.minWidthPt});
    }

    private void computeMinimumDiameter() {
        if (this.minWidthPt != null) {
            return;
        }
        if (this.isConvex) {
            this.computeWidthConvex(this.inputGeom);
        } else {
            Geometry geometry = new ConvexHull(this.inputGeom).getConvexHull();
            this.computeWidthConvex(geometry);
        }
    }

    private void computeWidthConvex(Geometry geometry) {
        Coordinate[] coordinateArray = null;
        coordinateArray = geometry instanceof Polygon ? ((Polygon)geometry).getExteriorRing().getCoordinates() : geometry.getCoordinates();
        if (coordinateArray.length == 0) {
            this.minWidth = 0.0;
            this.minWidthPt = null;
            this.minBaseSeg = null;
        } else if (coordinateArray.length == 1) {
            this.minWidth = 0.0;
            this.minWidthPt = coordinateArray[0];
            this.minBaseSeg.p0 = coordinateArray[0];
            this.minBaseSeg.p1 = coordinateArray[0];
        } else if (coordinateArray.length == 2 || coordinateArray.length == 3) {
            this.minWidth = 0.0;
            this.minWidthPt = coordinateArray[0];
            this.minBaseSeg.p0 = coordinateArray[0];
            this.minBaseSeg.p1 = coordinateArray[1];
        } else {
            this.computeConvexRingMinDiameter(coordinateArray);
        }
    }

    private void computeConvexRingMinDiameter(Coordinate[] coordinateArray) {
        this.minWidth = Double.MAX_VALUE;
        int n = 1;
        LineSegment lineSegment = new LineSegment();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            lineSegment.p0 = coordinateArray[i];
            lineSegment.p1 = coordinateArray[i + 1];
            n = this.findMaxPerpDistance(coordinateArray, lineSegment, n);
        }
    }

    private int findMaxPerpDistance(Coordinate[] coordinateArray, LineSegment lineSegment, int n) {
        int n2;
        double d;
        double d2 = d = lineSegment.distancePerpendicular(coordinateArray[n]);
        int n3 = n2 = n;
        while (d2 >= d) {
            d = d2;
            n2 = n3;
            n3 = MinimumDiameter.nextIndex(coordinateArray, n2);
            d2 = lineSegment.distancePerpendicular(coordinateArray[n3]);
        }
        if (d < this.minWidth) {
            this.minPtIndex = n2;
            this.minWidth = d;
            this.minWidthPt = coordinateArray[this.minPtIndex];
            this.minBaseSeg = new LineSegment(lineSegment);
        }
        return n2;
    }

    private static int nextIndex(Coordinate[] coordinateArray, int n) {
        if (++n >= coordinateArray.length) {
            n = 0;
        }
        return n;
    }
}

