/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.algorithm.CentroidLine;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.algorithm.InteriorPointArea;
import com.vividsolutions.jts.algorithm.InteriorPointLine;
import com.vividsolutions.jts.algorithm.InteriorPointPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.operation.relate.RelateOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class Geometry
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 8763622679187376702L;
    protected Envelope envelope;
    private static final Class[] sortedClasses = new Class[]{class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = Geometry.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point, class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = Geometry.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint, class$com$vividsolutions$jts$geom$LineString == null ? (class$com$vividsolutions$jts$geom$LineString = Geometry.class$("com.vividsolutions.jts.geom.LineString")) : class$com$vividsolutions$jts$geom$LineString, class$com$vividsolutions$jts$geom$LinearRing == null ? (class$com$vividsolutions$jts$geom$LinearRing = Geometry.class$("com.vividsolutions.jts.geom.LinearRing")) : class$com$vividsolutions$jts$geom$LinearRing, class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = Geometry.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString, class$com$vividsolutions$jts$geom$Polygon == null ? (class$com$vividsolutions$jts$geom$Polygon = Geometry.class$("com.vividsolutions.jts.geom.Polygon")) : class$com$vividsolutions$jts$geom$Polygon, class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = Geometry.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon, class$com$vividsolutions$jts$geom$GeometryCollection == null ? (class$com$vividsolutions$jts$geom$GeometryCollection = Geometry.class$("com.vividsolutions.jts.geom.GeometryCollection")) : class$com$vividsolutions$jts$geom$GeometryCollection};
    private static final GeometryComponentFilter geometryChangedFilter = new GeometryComponentFilter(){

        public void filter(Geometry geometry) {
            geometry.geometryChangedAction();
        }
    };
    private GeometryFactory factory;
    private static final GeometryFactory INTERNAL_GEOMETRY_FACTORY = new GeometryFactory();
    protected int SRID;
    private Object userData = null;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Point;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LinearRing;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiLineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPolygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$GeometryCollection;

    public Geometry(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.SRID = geometryFactory.getSRID();
    }

    public abstract String getGeometryType();

    protected static boolean hasNonEmptyElements(Geometry[] geometryArray) {
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasNullElements(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    public int getSRID() {
        return this.SRID;
    }

    public void setSRID(int n) {
        this.SRID = n;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public abstract boolean isSimple();

    public boolean isValid() {
        IsValidOp isValidOp = new IsValidOp(this.toInternalGeometry(this));
        return isValidOp.isValid();
    }

    public abstract boolean isEmpty();

    public double distance(Geometry geometry) {
        return DistanceOp.distance(this.toInternalGeometry(this), this.toInternalGeometry(geometry));
    }

    public boolean isWithinDistance(Geometry geometry, double d) {
        double d2 = this.getEnvelopeInternal().distance(geometry.getEnvelopeInternal());
        if (d2 > d) {
            return false;
        }
        double d3 = this.distance(geometry);
        return !(d3 > d);
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    public Point getCentroid() {
        if (this.isEmpty()) {
            return null;
        }
        Coordinate coordinate = null;
        int n = this.getDimension();
        if (n == 0) {
            CentroidPoint centroidPoint = new CentroidPoint();
            centroidPoint.add(this.toInternalGeometry(this));
            coordinate = centroidPoint.getCentroid();
        } else if (n == 1) {
            CentroidLine centroidLine = new CentroidLine();
            centroidLine.add(this.toInternalGeometry(this));
            coordinate = centroidLine.getCentroid();
        } else {
            CentroidArea centroidArea = new CentroidArea();
            centroidArea.add(this.toInternalGeometry(this));
            coordinate = centroidArea.getCentroid();
        }
        return this.createPointFromInternalCoord(coordinate, this);
    }

    public Point getInteriorPoint() {
        Coordinate coordinate = null;
        int n = this.getDimension();
        if (n == 0) {
            InteriorPointPoint interiorPointPoint = new InteriorPointPoint(this.toInternalGeometry(this));
            coordinate = interiorPointPoint.getInteriorPoint();
        } else if (n == 1) {
            InteriorPointLine interiorPointLine = new InteriorPointLine(this.toInternalGeometry(this));
            coordinate = interiorPointLine.getInteriorPoint();
        } else {
            InteriorPointArea interiorPointArea = new InteriorPointArea(this.toInternalGeometry(this));
            coordinate = interiorPointArea.getInteriorPoint();
        }
        return this.createPointFromInternalCoord(coordinate, this);
    }

    public abstract int getDimension();

    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    public Geometry getEnvelope() {
        return this.getFactory().toGeometry(this.getEnvelopeInternal());
    }

    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        return this.envelope;
    }

    public void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected void geometryChangedAction() {
        this.envelope = null;
    }

    public boolean disjoint(Geometry geometry) {
        return this.relate(geometry).isDisjoint();
    }

    public boolean touches(Geometry geometry) {
        return this.relate(geometry).isTouches(this.getDimension(), geometry.getDimension());
    }

    public boolean intersects(Geometry geometry) {
        return this.relate(geometry).isIntersects();
    }

    public boolean crosses(Geometry geometry) {
        return this.relate(geometry).isCrosses(this.getDimension(), geometry.getDimension());
    }

    public boolean within(Geometry geometry) {
        return this.relate(geometry).isWithin();
    }

    public boolean contains(Geometry geometry) {
        return this.relate(geometry).isContains();
    }

    public boolean overlaps(Geometry geometry) {
        return this.relate(geometry).isOverlaps(this.getDimension(), geometry.getDimension());
    }

    public boolean relate(Geometry geometry, String string) {
        return this.relate(geometry).matches(string);
    }

    public IntersectionMatrix relate(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return RelateOp.relate(this.toInternalGeometry(this), this.toInternalGeometry(geometry));
    }

    public boolean equals(Geometry geometry) {
        return this.relate(geometry).isEquals(this.getDimension(), geometry.getDimension());
    }

    public String toString() {
        return this.toText();
    }

    public String toText() {
        WKTWriter wKTWriter = new WKTWriter();
        return wKTWriter.write(this);
    }

    public Geometry buffer(double d) {
        return this.fromInternalGeometry(BufferOp.bufferOp(this.toInternalGeometry(this), d));
    }

    protected Geometry toInternalGeometry(Geometry geometry) {
        if (DefaultCoordinateSequenceFactory.instance().equals(this.factory.getCoordinateSequenceFactory())) {
            return geometry;
        }
        return INTERNAL_GEOMETRY_FACTORY.createGeometry(geometry);
    }

    protected Geometry fromInternalGeometry(Geometry geometry) {
        if (DefaultCoordinateSequenceFactory.instance().equals(this.factory.getCoordinateSequenceFactory())) {
            return geometry;
        }
        return this.getFactory().createGeometry(geometry);
    }

    public Geometry buffer(double d, int n) {
        return this.fromInternalGeometry(BufferOp.bufferOp(this.toInternalGeometry(this), d, n));
    }

    public Geometry convexHull() {
        return this.fromInternalGeometry(new ConvexHull(this.toInternalGeometry(this)).getConvexHull());
    }

    public Geometry intersection(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return this.fromInternalGeometry(OverlayOp.overlayOp(this.toInternalGeometry(this), this.toInternalGeometry(geometry), 1));
    }

    public Geometry union(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return this.fromInternalGeometry(OverlayOp.overlayOp(this.toInternalGeometry(this), this.toInternalGeometry(geometry), 2));
    }

    public Geometry difference(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return this.fromInternalGeometry(OverlayOp.overlayOp(this.toInternalGeometry(this), this.toInternalGeometry(geometry), 3));
    }

    public Geometry symDifference(Geometry geometry) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(geometry);
        return this.fromInternalGeometry(OverlayOp.overlayOp(this.toInternalGeometry(this), this.toInternalGeometry(geometry), 4));
    }

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsExact(Geometry geometry) {
        return this.equalsExact(geometry, 0.0);
    }

    public abstract void apply(CoordinateFilter var1);

    public abstract void apply(GeometryFilter var1);

    public abstract void apply(GeometryComponentFilter var1);

    public Object clone() {
        try {
            Geometry geometry = (Geometry)super.clone();
            if (geometry.envelope != null) {
                geometry.envelope = new Envelope(geometry.envelope);
            }
            return geometry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public abstract void normalize();

    public int compareTo(Object object) {
        Geometry geometry = (Geometry)object;
        if (this.getClassSortIndex() != geometry.getClassSortIndex()) {
            return this.getClassSortIndex() - geometry.getClassSortIndex();
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (geometry.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(object);
    }

    protected boolean isEquivalentClass(Geometry geometry) {
        return this.getClass().getName().equals(geometry.getClass().getName());
    }

    protected void checkNotGeometryCollection(Geometry geometry) {
        if (geometry.getClass().getName().equals("com.vividsolutions.jts.geom.GeometryCollection")) {
            throw new IllegalArgumentException("This method does not support GeometryCollection arguments");
        }
    }

    protected abstract Envelope computeEnvelopeInternal();

    protected abstract int compareToSameClass(Object var1);

    protected int compare(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)iterator.next();
            int n = comparable2.compareTo(comparable = (Comparable)iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected boolean equal(Coordinate coordinate, Coordinate coordinate2, double d) {
        if (d == 0.0) {
            return coordinate.equals(coordinate2);
        }
        return coordinate.distance(coordinate2) <= d;
    }

    private int getClassSortIndex() {
        for (int i = 0; i < sortedClasses.length; ++i) {
            if (!sortedClasses[i].isInstance(this)) continue;
            return i;
        }
        Assert.shouldNeverReachHere("Class not supported: " + this.getClass());
        return -1;
    }

    private Point createPointFromInternalCoord(Coordinate coordinate, Geometry geometry) {
        geometry.getPrecisionModel().makePrecise(coordinate);
        return geometry.getFactory().createPoint(coordinate);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

