/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.IsSimpleOp;

public class LineString
extends Geometry {
    private static final long serialVersionUID = 3110669828065365560L;
    private CoordinateSequence points;

    public LineString(Coordinate[] coordinateArray, PrecisionModel precisionModel, int n) {
        this(DefaultCoordinateSequenceFactory.instance().create(coordinateArray == null ? new Coordinate[]{} : coordinateArray), new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public LineString(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (coordinateSequence == null) {
            coordinateSequence = geometryFactory.getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (coordinateSequence.size() == 1) {
            throw new IllegalArgumentException("point array must contain 0 or >1 elements");
        }
        this.points = coordinateSequence;
    }

    public Coordinate[] getCoordinates() {
        return this.points.toCoordinateArray();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points;
    }

    public Coordinate getCoordinateN(int n) {
        return this.points.getCoordinate(n);
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points.getCoordinate(0);
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPointN(int n) {
        return this.getFactory().createPoint(this.points.getCoordinate(n));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    public String getGeometryType() {
        return "LineString";
    }

    public double getLength() {
        return CGAlgorithms.length(this.points);
    }

    public boolean isSimple() {
        return new IsSimpleOp().isSimple((LineString)this.toInternalGeometry(this));
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        if (this.isClosed()) {
            return this.getFactory().createMultiPoint((Coordinate[])null);
        }
        return this.getFactory().createMultiPoint(new Point[]{this.getStartPoint(), this.getEndPoint()});
    }

    public boolean isCoordinate(Coordinate coordinate) {
        for (int i = 1; i < this.points.size(); ++i) {
            if (!this.points.getCoordinate(i).equals(coordinate)) continue;
            return true;
        }
        return false;
    }

    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        Coordinate[] coordinateArray = this.points.toCoordinateArray();
        double d = coordinateArray[0].x;
        double d2 = coordinateArray[0].y;
        double d3 = coordinateArray[0].x;
        double d4 = coordinateArray[0].y;
        for (int i = 1; i < coordinateArray.length; ++i) {
            d = d < coordinateArray[i].x ? d : coordinateArray[i].x;
            d3 = d3 > coordinateArray[i].x ? d3 : coordinateArray[i].x;
            d2 = d2 < coordinateArray[i].y ? d2 : coordinateArray[i].y;
            d4 = d4 > coordinateArray[i].y ? d4 : coordinateArray[i].y;
        }
        return new Envelope(d, d3, d2, d4);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        LineString lineString = (LineString)geometry;
        if (this.points.size() != lineString.points.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            if (this.equal(this.points.getCoordinate(i), lineString.points.getCoordinate(i), d)) continue;
            return false;
        }
        return true;
    }

    public void apply(CoordinateFilter coordinateFilter) {
        for (int i = 0; i < this.points.size(); ++i) {
            coordinateFilter.filter(this.points.getCoordinate(i));
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    public Object clone() {
        LineString lineString = (LineString)super.clone();
        lineString.points = (CoordinateSequence)this.points.clone();
        return lineString;
    }

    public void normalize() {
        for (int i = 0; i < this.points.size() / 2; ++i) {
            int n = this.points.size() - 1 - i;
            if (this.points.getCoordinate(i).equals(this.points.getCoordinate(n))) continue;
            if (this.points.getCoordinate(i).compareTo(this.points.getCoordinate(n)) > 0) {
                CoordinateArrays.reverse(this.getCoordinates());
            }
            return;
        }
    }

    protected boolean isEquivalentClass(Geometry geometry) {
        return geometry instanceof LineString;
    }

    protected int compareToSameClass(Object object) {
        int n;
        LineString lineString = (LineString)object;
        int n2 = 0;
        for (n = 0; n2 < this.points.size() && n < lineString.points.size(); ++n2, ++n) {
            int n3 = this.points.getCoordinate(n2).compareTo(lineString.points.getCoordinate(n));
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 < this.points.size()) {
            return 1;
        }
        if (n < lineString.points.size()) {
            return -1;
        }
        return 0;
    }
}

