/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;

public class EdgeEnd
implements Comparable {
    protected Edge edge;
    protected Label label;
    private Node node;
    private Coordinate p0;
    private Coordinate p1;
    private double dx;
    private double dy;
    private int quadrant;

    protected EdgeEnd(Edge edge) {
        this.edge = edge;
    }

    public EdgeEnd(Edge edge, Coordinate coordinate, Coordinate coordinate2) {
        this(edge, coordinate, coordinate2, null);
    }

    public EdgeEnd(Edge edge, Coordinate coordinate, Coordinate coordinate2, Label label) {
        this(edge);
        this.init(coordinate, coordinate2);
        this.label = label;
    }

    protected void init(Coordinate coordinate, Coordinate coordinate2) {
        this.p0 = coordinate;
        this.p1 = coordinate2;
        this.dx = coordinate2.x - coordinate.x;
        this.dy = coordinate2.y - coordinate.y;
        this.quadrant = Quadrant.quadrant(this.dx, this.dy);
        Assert.isTrue(this.dx != 0.0 || this.dy != 0.0, "EdgeEnd with identical endpoints found");
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Label getLabel() {
        return this.label;
    }

    public Coordinate getCoordinate() {
        return this.p0;
    }

    public Coordinate getDirectedCoordinate() {
        return this.p1;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public int compareTo(Object object) {
        EdgeEnd edgeEnd = (EdgeEnd)object;
        return this.compareDirection(edgeEnd);
    }

    public int compareDirection(EdgeEnd edgeEnd) {
        if (this.dx == edgeEnd.dx && this.dy == edgeEnd.dy) {
            return 0;
        }
        if (this.quadrant > edgeEnd.quadrant) {
            return 1;
        }
        if (this.quadrant < edgeEnd.quadrant) {
            return -1;
        }
        return CGAlgorithms.computeOrientation(edgeEnd.p0, edgeEnd.p1, this.p1);
    }

    public void computeLabel() {
    }

    public void print(PrintStream printStream) {
        double d = Math.atan2(this.dy, this.dx);
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        printStream.print("  " + string2 + ": " + this.p0 + " - " + this.p1 + " " + this.quadrant + ":" + d + "   " + this.label);
    }
}

