/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.chain;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;

public class MonotoneChain {
    private Coordinate[] pts;
    private int start;
    private int end;
    private Envelope env = null;
    private Object context = null;
    private int id;

    public MonotoneChain(Coordinate[] coordinateArray, int n, int n2, Object object) {
        this.pts = coordinateArray;
        this.start = n;
        this.end = n2;
        this.context = object;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public Object getContext() {
        return this.context;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Coordinate coordinate = this.pts[this.start];
            Coordinate coordinate2 = this.pts[this.end];
            this.env = new Envelope(coordinate, coordinate2);
        }
        return this.env;
    }

    public int getStartIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public void getLineSegment(int n, LineSegment lineSegment) {
        lineSegment.p0 = this.pts[n];
        lineSegment.p1 = this.pts[n + 1];
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[this.end - this.start + 1];
        int n = 0;
        for (int i = this.start; i <= this.end; ++i) {
            coordinateArray[n++] = this.pts[i];
        }
        return coordinateArray;
    }

    public void select(Envelope envelope, MonotoneChainSelectAction monotoneChainSelectAction) {
        this.computeSelect(envelope, this.start, this.end, monotoneChainSelectAction);
    }

    private void computeSelect(Envelope envelope, int n, int n2, MonotoneChainSelectAction monotoneChainSelectAction) {
        Coordinate coordinate = this.pts[n];
        Coordinate coordinate2 = this.pts[n2];
        monotoneChainSelectAction.tempEnv1.init(coordinate, coordinate2);
        if (n2 - n == 1) {
            monotoneChainSelectAction.select(this, n);
            return;
        }
        if (!envelope.intersects(monotoneChainSelectAction.tempEnv1)) {
            return;
        }
        int n3 = (n + n2) / 2;
        if (n < n3) {
            this.computeSelect(envelope, n, n3, monotoneChainSelectAction);
        }
        if (n3 < n2) {
            this.computeSelect(envelope, n3, n2, monotoneChainSelectAction);
        }
    }

    public void computeOverlaps(MonotoneChain monotoneChain, MonotoneChainOverlapAction monotoneChainOverlapAction) {
        this.computeOverlaps(this.start, this.end, monotoneChain, monotoneChain.start, monotoneChain.end, monotoneChainOverlapAction);
    }

    private void computeOverlaps(int n, int n2, MonotoneChain monotoneChain, int n3, int n4, MonotoneChainOverlapAction monotoneChainOverlapAction) {
        Coordinate coordinate = this.pts[n];
        Coordinate coordinate2 = this.pts[n2];
        Coordinate coordinate3 = monotoneChain.pts[n3];
        Coordinate coordinate4 = monotoneChain.pts[n4];
        if (n2 - n == 1 && n4 - n3 == 1) {
            monotoneChainOverlapAction.overlap(this, n, monotoneChain, n3);
            return;
        }
        monotoneChainOverlapAction.tempEnv1.init(coordinate, coordinate2);
        monotoneChainOverlapAction.tempEnv2.init(coordinate3, coordinate4);
        if (!monotoneChainOverlapAction.tempEnv1.intersects(monotoneChainOverlapAction.tempEnv2)) {
            return;
        }
        int n5 = (n + n2) / 2;
        int n6 = (n3 + n4) / 2;
        if (n < n5) {
            if (n3 < n6) {
                this.computeOverlaps(n, n5, monotoneChain, n3, n6, monotoneChainOverlapAction);
            }
            if (n6 < n4) {
                this.computeOverlaps(n, n5, monotoneChain, n6, n4, monotoneChainOverlapAction);
            }
        }
        if (n5 < n2) {
            if (n3 < n6) {
                this.computeOverlaps(n5, n2, monotoneChain, n3, n6, monotoneChainOverlapAction);
            }
            if (n6 < n4) {
                this.computeOverlaps(n5, n2, monotoneChain, n6, n4, monotoneChainOverlapAction);
            }
        }
    }
}

