/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class WKTReader {
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;

    public WKTReader() {
        this(new GeometryFactory());
    }

    public WKTReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String string) throws ParseException {
        StringReader stringReader = new StringReader(string);
        try {
            Geometry geometry = this.read(stringReader);
            return geometry;
        }
        finally {
            stringReader.close();
        }
    }

    public Geometry read(Reader reader) throws ParseException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        try {
            return this.readGeometryTaggedText(streamTokenizer);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    private Coordinate[] getCoordinates(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextEmptyOrOpener(streamTokenizer);
        if (string.equals("EMPTY")) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(this.getPreciseCoordinate(streamTokenizer));
        string = this.getNextCloserOrComma(streamTokenizer);
        while (string.equals(",")) {
            arrayList.add(this.getPreciseCoordinate(streamTokenizer));
            string = this.getNextCloserOrComma(streamTokenizer);
        }
        Coordinate[] coordinateArray = new Coordinate[arrayList.size()];
        return arrayList.toArray(coordinateArray);
    }

    private Coordinate getPreciseCoordinate(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.getNextNumber(streamTokenizer);
        coordinate.y = this.getNextNumber(streamTokenizer);
        if (this.isNumberNext(streamTokenizer)) {
            coordinate.z = this.getNextNumber(streamTokenizer);
        }
        this.precisionModel.makePrecise(coordinate);
        return coordinate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNumberNext(StreamTokenizer streamTokenizer) throws IOException {
        try {
            boolean bl = streamTokenizer.nextToken() == -2;
            return bl;
        }
        finally {
            streamTokenizer.pushBack();
        }
    }

    private double getNextNumber(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        int n = streamTokenizer.nextToken();
        switch (n) {
            case -1: {
                throw new ParseException("Expected number but encountered end of stream");
            }
            case 10: {
                throw new ParseException("Expected number but encountered end of line");
            }
            case -2: {
                return streamTokenizer.nval;
            }
            case -3: {
                throw new ParseException("Expected number but encountered word: " + streamTokenizer.sval);
            }
            case 40: {
                throw new ParseException("Expected number but encountered '('");
            }
            case 41: {
                throw new ParseException("Expected number but encountered ')'");
            }
            case 44: {
                throw new ParseException("Expected number but encountered ','");
            }
        }
        Assert.shouldNeverReachHere("Encountered unexpected StreamTokenizer type: " + n);
        return 0.0;
    }

    private String getNextEmptyOrOpener(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextWord(streamTokenizer);
        if (string.equals("EMPTY") || string.equals("(")) {
            return string;
        }
        throw new ParseException("Expected 'EMPTY' or '(' but encountered '" + string + "'");
    }

    private String getNextCloserOrComma(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextWord(streamTokenizer);
        if (string.equals(",") || string.equals(")")) {
            return string;
        }
        throw new ParseException("Expected ')' or ',' but encountered '" + string + "'");
    }

    private String getNextCloser(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextWord(streamTokenizer);
        if (string.equals(")")) {
            return string;
        }
        throw new ParseException("Expected ')' but encountered '" + string + "'");
    }

    private String getNextWord(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        int n = streamTokenizer.nextToken();
        switch (n) {
            case -1: {
                throw new ParseException("Expected word but encountered end of stream");
            }
            case 10: {
                throw new ParseException("Expected word but encountered end of line");
            }
            case -2: {
                throw new ParseException("Expected word but encountered number: " + streamTokenizer.nval);
            }
            case -3: {
                return streamTokenizer.sval.toUpperCase();
            }
            case 40: {
                return "(";
            }
            case 41: {
                return ")";
            }
            case 44: {
                return ",";
            }
        }
        Assert.shouldNeverReachHere("Encountered unexpected StreamTokenizer type: " + n);
        return null;
    }

    private Geometry readGeometryTaggedText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextWord(streamTokenizer);
        if (string.equals("POINT")) {
            return this.readPointText(streamTokenizer);
        }
        if (string.equals("LINESTRING")) {
            return this.readLineStringText(streamTokenizer);
        }
        if (string.equals("LINEARRING")) {
            return this.readLinearRingText(streamTokenizer);
        }
        if (string.equals("POLYGON")) {
            return this.readPolygonText(streamTokenizer);
        }
        if (string.equals("MULTIPOINT")) {
            return this.readMultiPointText(streamTokenizer);
        }
        if (string.equals("MULTILINESTRING")) {
            return this.readMultiLineStringText(streamTokenizer);
        }
        if (string.equals("MULTIPOLYGON")) {
            return this.readMultiPolygonText(streamTokenizer);
        }
        if (string.equals("GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText(streamTokenizer);
        }
        throw new ParseException("Unknown type: " + string);
    }

    private Point readPointText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextEmptyOrOpener(streamTokenizer);
        if (string.equals("EMPTY")) {
            return this.geometryFactory.createPoint((Coordinate)null);
        }
        Point point = this.geometryFactory.createPoint(this.getPreciseCoordinate(streamTokenizer));
        this.getNextCloser(streamTokenizer);
        return point;
    }

    private LineString readLineStringText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        return this.geometryFactory.createLineString(this.getCoordinates(streamTokenizer));
    }

    private LinearRing readLinearRingText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinates(streamTokenizer));
    }

    private MultiPoint readMultiPointText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        return this.geometryFactory.createMultiPoint(this.toPoints(this.getCoordinates(streamTokenizer)));
    }

    private Point[] toPoints(Coordinate[] coordinateArray) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < coordinateArray.length; ++i) {
            arrayList.add(this.geometryFactory.createPoint(coordinateArray[i]));
        }
        return arrayList.toArray(new Point[0]);
    }

    private Polygon readPolygonText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        LinearRing[] linearRingArray;
        String string = this.getNextEmptyOrOpener(streamTokenizer);
        if (string.equals("EMPTY")) {
            return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        ArrayList<LinearRing[]> arrayList = new ArrayList<LinearRing[]>();
        LinearRing linearRing = this.readLinearRingText(streamTokenizer);
        string = this.getNextCloserOrComma(streamTokenizer);
        while (string.equals(",")) {
            linearRingArray = this.readLinearRingText(streamTokenizer);
            arrayList.add(linearRingArray);
            string = this.getNextCloserOrComma(streamTokenizer);
        }
        linearRingArray = new LinearRing[arrayList.size()];
        return this.geometryFactory.createPolygon(linearRing, arrayList.toArray(linearRingArray));
    }

    private MultiLineString readMultiLineStringText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextEmptyOrOpener(streamTokenizer);
        if (string.equals("EMPTY")) {
            return this.geometryFactory.createMultiLineString(new LineString[0]);
        }
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        LineString lineString = this.readLineStringText(streamTokenizer);
        arrayList.add(lineString);
        string = this.getNextCloserOrComma(streamTokenizer);
        while (string.equals(",")) {
            lineString = this.readLineStringText(streamTokenizer);
            arrayList.add(lineString);
            string = this.getNextCloserOrComma(streamTokenizer);
        }
        LineString[] lineStringArray = new LineString[arrayList.size()];
        return this.geometryFactory.createMultiLineString(arrayList.toArray(lineStringArray));
    }

    private MultiPolygon readMultiPolygonText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextEmptyOrOpener(streamTokenizer);
        if (string.equals("EMPTY")) {
            return this.geometryFactory.createMultiPolygon(new Polygon[0]);
        }
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        Polygon polygon = this.readPolygonText(streamTokenizer);
        arrayList.add(polygon);
        string = this.getNextCloserOrComma(streamTokenizer);
        while (string.equals(",")) {
            polygon = this.readPolygonText(streamTokenizer);
            arrayList.add(polygon);
            string = this.getNextCloserOrComma(streamTokenizer);
        }
        Polygon[] polygonArray = new Polygon[arrayList.size()];
        return this.geometryFactory.createMultiPolygon(arrayList.toArray(polygonArray));
    }

    private GeometryCollection readGeometryCollectionText(StreamTokenizer streamTokenizer) throws IOException, ParseException {
        String string = this.getNextEmptyOrOpener(streamTokenizer);
        if (string.equals("EMPTY")) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        Geometry geometry = this.readGeometryTaggedText(streamTokenizer);
        arrayList.add(geometry);
        string = this.getNextCloserOrComma(streamTokenizer);
        while (string.equals(",")) {
            geometry = this.readGeometryTaggedText(streamTokenizer);
            arrayList.add(geometry);
            string = this.getNextCloserOrComma(streamTokenizer);
        }
        Geometry[] geometryArray = new Geometry[arrayList.size()];
        return this.geometryFactory.createGeometryCollection(arrayList.toArray(geometryArray));
    }
}

