/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SubgraphDepthLocater {
    private Collection subgraphs;
    private LineSegment seg = new LineSegment();
    private CGAlgorithms cga = new RobustCGAlgorithms();

    public SubgraphDepthLocater(List list) {
        this.subgraphs = list;
    }

    public int getDepth(Coordinate coordinate) {
        List list = this.findStabbedSegments(coordinate);
        if (list.size() == 0) {
            return 0;
        }
        Collections.sort(list);
        DepthSegment depthSegment = (DepthSegment)list.get(0);
        return depthSegment.leftDepth;
    }

    private List findStabbedSegments(Coordinate coordinate) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.subgraphs.iterator();
        while (iterator.hasNext()) {
            BufferSubgraph bufferSubgraph = (BufferSubgraph)iterator.next();
            this.findStabbedSegments(coordinate, bufferSubgraph.getDirectedEdges(), arrayList);
        }
        return arrayList;
    }

    private void findStabbedSegments(Coordinate coordinate, List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isForward()) continue;
            this.findStabbedSegments(coordinate, directedEdge, list2);
        }
    }

    private void findStabbedSegments(Coordinate coordinate, DirectedEdge directedEdge, List list) {
        Coordinate[] coordinateArray = directedEdge.getEdge().getCoordinates();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            double d;
            this.seg.p0 = coordinateArray[i];
            this.seg.p1 = coordinateArray[i + 1];
            if (this.seg.p0.y > this.seg.p1.y) {
                this.seg.reverse();
            }
            if ((d = Math.max(this.seg.p0.x, this.seg.p1.x)) < coordinate.x || this.seg.isHorizontal() || coordinate.y < this.seg.p0.y || coordinate.y > this.seg.p1.y) continue;
            if (CGAlgorithms.computeOrientation(this.seg.p0, this.seg.p1, coordinate) == -1) continue;
            int n = directedEdge.getDepth(1);
            if (!this.seg.p0.equals(coordinateArray[i])) {
                n = directedEdge.getDepth(2);
            }
            DepthSegment depthSegment = new DepthSegment(this.seg, n);
            list.add(depthSegment);
        }
    }

    private class DepthSegment
    implements Comparable {
        private LineSegment upwardSeg;
        private int leftDepth;

        public DepthSegment(LineSegment lineSegment, int n) {
            this.upwardSeg = new LineSegment(lineSegment);
            this.leftDepth = n;
        }

        public int compareTo(Object object) {
            DepthSegment depthSegment = (DepthSegment)object;
            int n = this.upwardSeg.orientationIndex(depthSegment.upwardSeg);
            if (n == 0) {
                n = -1 * depthSegment.upwardSeg.orientationIndex(this.upwardSeg);
            }
            if (n != 0) {
                return n;
            }
            return this.compareX(this.upwardSeg, depthSegment.upwardSeg);
        }

        private int compareX(LineSegment lineSegment, LineSegment lineSegment2) {
            int n = lineSegment.p0.compareTo(lineSegment2.p0);
            if (n != 0) {
                return n;
            }
            return lineSegment.p1.compareTo(lineSegment2.p1);
        }
    }
}

