/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Polygonizer {
    private LineStringAdder lineStringAdder = new LineStringAdder();
    protected PolygonizeGraph graph;
    protected Collection dangles = new ArrayList();
    protected List cutEdges = new ArrayList();
    protected List invalidRingLines = new ArrayList();
    protected List holeList = null;
    protected List shellList = null;
    protected List polyList = null;

    public void add(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Geometry geometry = (Geometry)iterator.next();
            this.add(geometry);
        }
    }

    public void add(Geometry geometry) {
        geometry.apply(this.lineStringAdder);
    }

    private void add(LineString lineString) {
        if (this.graph == null) {
            this.graph = new PolygonizeGraph(lineString.getFactory());
        }
        this.graph.addEdge(lineString);
    }

    public Collection getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    public Collection getDangles() {
        this.polygonize();
        return this.dangles;
    }

    public Collection getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    public Collection getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    private void polygonize() {
        if (this.polyList != null) {
            return;
        }
        this.dangles = this.graph.deleteDangles();
        this.cutEdges = this.graph.deleteCutEdges();
        List list = this.graph.getEdgeRings();
        ArrayList arrayList = new ArrayList();
        this.invalidRingLines = new ArrayList();
        this.findValidRings(list, arrayList, this.invalidRingLines);
        this.findShellsAndHoles(arrayList);
        Polygonizer.assignHolesToShells(this.holeList, this.shellList);
        this.polyList = new ArrayList();
        Iterator iterator = this.shellList.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            this.polyList.add(edgeRing.getPolygon());
        }
    }

    private void findValidRings(List list, List list2, List list3) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            if (edgeRing.isValid()) {
                list2.add(edgeRing);
                continue;
            }
            list3.add(edgeRing.getLineString());
        }
    }

    private void findShellsAndHoles(List list) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            if (edgeRing.isHole()) {
                this.holeList.add(edgeRing);
                continue;
            }
            this.shellList.add(edgeRing);
        }
    }

    private static void assignHolesToShells(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            Polygonizer.assignHoleToShell(edgeRing, list2);
        }
    }

    private static void assignHoleToShell(EdgeRing edgeRing, List list) {
        EdgeRing edgeRing2 = EdgeRing.findEdgeRingContaining(edgeRing, list);
        if (edgeRing2 != null) {
            edgeRing2.addHole(edgeRing.getRing());
        }
    }

    private class LineStringAdder
    implements GeometryComponentFilter {
        private LineStringAdder() {
        }

        public void filter(Geometry geometry) {
            if (geometry instanceof LineString) {
                Polygonizer.this.add((LineString)geometry);
            }
        }
    }
}

