/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class SimpleNestedRingTester {
    private final CGAlgorithms cga = new CGAlgorithms();
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Coordinate nestedPt;

    public SimpleNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing linearRing = (LinearRing)this.rings.get(i);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            for (int j = 0; j < this.rings.size(); ++j) {
                LinearRing linearRing2 = (LinearRing)this.rings.get(j);
                Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
                if (linearRing == linearRing2 || !linearRing.getEnvelopeInternal().intersects(linearRing2.getEnvelopeInternal())) continue;
                Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, this.graph);
                Assert.isTrue(coordinate != null, "Unable to find a ring point not a node of the search ring");
                boolean bl = CGAlgorithms.isPointInRing(coordinate, coordinateArray2);
                if (!bl) continue;
                this.nestedPt = coordinate;
                return false;
            }
        }
        return true;
    }
}

