/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.commandline.CommandLine;
import com.vividsolutions.jump.util.commandline.OptionSpec;
import com.vividsolutions.jump.util.commandline.ParseException;
import com.vividsolutions.jump.workbench.JUMPConfiguration;
import com.vividsolutions.jump.workbench.JUMPWorkbenchContext;
import com.vividsolutions.jump.workbench.Setup;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.WorkbenchPropertiesFile;
import com.vividsolutions.jump.workbench.driver.DriverManager;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.SplashPanel;
import com.vividsolutions.jump.workbench.ui.SplashWindow;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;

public class JUMPWorkbench {
    private static ImageIcon splashImage;
    private static final ImageIcon APP_ICON;
    public static final String VERSION_TEXT = "1.1.2";
    public static final String PROPERTIES_OPTION = "properties";
    public static final String PLUG_IN_DIRECTORY_OPTION = "plug-in-directory";
    private static Class progressMonitorClass;
    private CommandLine commandLine;
    private WorkbenchContext context = new JUMPWorkbenchContext(this);
    private WorkbenchFrame frame;
    private DriverManager driverManager = new DriverManager(this.frame);
    private WorkbenchProperties dummyProperties;
    private WorkbenchProperties properties = this.dummyProperties = new WorkbenchProperties(){

        public List getPlugInClasses() {
            return new ArrayList();
        }

        public List getInputDriverClasses() {
            return new ArrayList();
        }

        public List getOutputDriverClasses() {
            return new ArrayList();
        }

        public List getConfigurationClasses() {
            return new ArrayList();
        }
    };
    private PlugInManager plugInManager;
    private Blackboard blackboard = new Blackboard();
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$JUMPWorkbench$SingleLineProgressMonitor;

    public static ImageIcon splashImage() {
        if (splashImage == null) {
            splashImage = IconLoader.icon("splash.png");
        }
        return splashImage;
    }

    public JUMPWorkbench(String title, String[] args, ImageIcon icon, final JWindow s, TaskMonitor monitor) throws Exception {
        this.frame = new WorkbenchFrame(title, icon, this.context);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                s.setVisible(false);
            }
        });
        this.parseCommandLine(args);
        if (this.commandLine.hasOption(PROPERTIES_OPTION)) {
            File propertiesFile = new File(this.commandLine.getOption(PROPERTIES_OPTION).getArg(0));
            if (propertiesFile.exists()) {
                this.properties = new WorkbenchPropertiesFile(propertiesFile, this.frame);
            } else {
                System.out.println("JUMP: Warning: Properties file does not exist: " + propertiesFile);
            }
        }
        File extensionsDirectory = null;
        if (this.commandLine.hasOption(PLUG_IN_DIRECTORY_OPTION)) {
            extensionsDirectory = new File(this.commandLine.getOption(PLUG_IN_DIRECTORY_OPTION).getArg(0));
            if (!extensionsDirectory.exists()) {
                System.out.println("JUMP: Warning: Extensions directory does not exist: " + extensionsDirectory);
                extensionsDirectory = null;
            }
        } else {
            extensionsDirectory = new File("../lib/ext");
            if (!extensionsDirectory.exists()) {
                extensionsDirectory = null;
            }
        }
        this.plugInManager = new PlugInManager(this.context, extensionsDirectory, monitor);
        this.driverManager.loadDrivers(this.properties);
    }

    public static void main(String[] args) {
        try {
            JUMPWorkbench.initLookAndFeel();
            ProgressMonitor progressMonitor = (ProgressMonitor)progressMonitorClass.newInstance();
            SplashPanel splashPanel = new SplashPanel(JUMPWorkbench.splashImage(), "Version 1.1.2");
            splashPanel.add((Component)progressMonitor, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 10), 0, 0));
            JUMPWorkbench.main(args, "JUMP Workbench", new JUMPConfiguration(), splashPanel, progressMonitor);
        }
        catch (Throwable t) {
            WorkbenchFrame.handleThrowable(t, null);
        }
    }

    public static void main(String[] args, String title, Setup setup, JComponent splashComponent, TaskMonitor taskMonitor) {
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            JUMPWorkbench.initLookAndFeel();
            SplashWindow splashWindow = new SplashWindow(splashComponent);
            splashWindow.setVisible(true);
            JUMPWorkbench workbench = new JUMPWorkbench(title, args, APP_ICON, splashWindow, taskMonitor);
            setup.setup(workbench.context);
            workbench.context.getWorkbench().getPlugInManager().load();
            workbench.getFrame().setVisible(true);
        }
        catch (Throwable t) {
            WorkbenchFrame.handleThrowable(t, null);
        }
    }

    private static void initLookAndFeel() throws Exception {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        if (UIManager.getLookAndFeel() != null && UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            return;
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public DriverManager getDriverManager() {
        return this.driverManager;
    }

    public WorkbenchProperties getProperties() {
        return this.properties;
    }

    public WorkbenchFrame getFrame() {
        return this.frame;
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    private void parseCommandLine(String[] args) throws WorkbenchException {
        this.commandLine = new CommandLine('-');
        this.commandLine.addOptionSpec(new OptionSpec(PROPERTIES_OPTION, 1));
        this.commandLine.addOptionSpec(new OptionSpec(PLUG_IN_DIRECTORY_OPTION, 1));
        try {
            this.commandLine.parse(args);
        }
        catch (ParseException e) {
            throw new WorkbenchException("A problem occurred parsing the command line: " + e.toString());
        }
    }

    public PlugInManager getPlugInManager() {
        return this.plugInManager;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        APP_ICON = IconLoader.icon("app-icon.gif");
        progressMonitorClass = class$com$vividsolutions$jump$workbench$JUMPWorkbench$SingleLineProgressMonitor == null ? (class$com$vividsolutions$jump$workbench$JUMPWorkbench$SingleLineProgressMonitor = JUMPWorkbench.class$("com.vividsolutions.jump.workbench.JUMPWorkbench$SingleLineProgressMonitor")) : class$com$vividsolutions$jump$workbench$JUMPWorkbench$SingleLineProgressMonitor;
    }

    private static class HorizontallyScrollingProgressMonitor
    extends ProgressMonitor {
        private static final String BUFFER = "   ";

        public HorizontallyScrollingProgressMonitor() {
            super(new JLabel(" "));
            ((JLabel)this.getComponent()).setFont(((JLabel)this.getComponent()).getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(4);
        }

        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(BUFFER + s + ((JLabel)this.getComponent()).getText());
        }
    }

    private static class SingleLineProgressMonitor
    extends ProgressMonitor {
        public SingleLineProgressMonitor() {
            super(new JLabel(" "));
            ((JLabel)this.getComponent()).setFont(((JLabel)this.getComponent()).getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(2);
        }

        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(s);
        }
    }

    private static class VerticallyScrollingProgressMonitor
    extends ProgressMonitor {
        private static int ROWS = 3;
        private JLabel[] labels;

        public VerticallyScrollingProgressMonitor() {
            super(new JPanel(new GridLayout(ROWS, 1)));
            JPanel panel = (JPanel)this.getComponent();
            panel.setOpaque(false);
            this.labels = new JLabel[ROWS];
            for (int i = 0; i < ROWS; ++i) {
                this.labels[i] = new JLabel(" ");
                this.labels[i].setFont(this.labels[i].getFont().deriveFont(1));
                panel.add(this.labels[i]);
            }
        }

        protected void addText(String s) {
            for (int i = 0; i < ROWS - 1; ++i) {
                this.labels[i].setText(this.labels[i + 1].getText());
            }
            this.labels[ROWS - 1].setText(s);
        }
    }

    private static abstract class ProgressMonitor
    extends JPanel
    implements TaskMonitor {
        private Component component;

        public ProgressMonitor(Component component) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setOpaque(false);
        }

        protected Component getComponent() {
            return this.component;
        }

        protected abstract void addText(String var1);

        public void report(String description) {
            this.addText(description);
        }

        public void report(int itemsDone, int totalItems, String itemDescription) {
            this.addText(itemsDone + " / " + totalItems + " " + itemDescription);
        }

        public void report(Exception exception) {
            this.addText(StringUtil.toFriendlyName(exception.getClass().getName()));
        }

        public void allowCancellationRequests() {
        }

        public boolean isCancelRequested() {
            return false;
        }
    }
}

