/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.driver;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.driver.AbstractDriver;
import com.vividsolutions.jump.workbench.driver.AbstractInputDriver;
import com.vividsolutions.jump.workbench.driver.AbstractOutputDriver;
import com.vividsolutions.jump.workbench.ui.BasicFileDriverPanel;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DriverManager {
    private ArrayList inputDrivers = new ArrayList();
    private ArrayList outputDrivers = new ArrayList();
    private List builtInInputDriverClasses = Arrays.asList(class$com$vividsolutions$jump$workbench$driver$FMEFileInputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$FMEFileInputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.FMEFileInputDriver")) : class$com$vividsolutions$jump$workbench$driver$FMEFileInputDriver, class$com$vividsolutions$jump$workbench$driver$GMLFileInputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$GMLFileInputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.GMLFileInputDriver")) : class$com$vividsolutions$jump$workbench$driver$GMLFileInputDriver, class$com$vividsolutions$jump$workbench$driver$JMLFileInputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$JMLFileInputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.JMLFileInputDriver")) : class$com$vividsolutions$jump$workbench$driver$JMLFileInputDriver, class$com$vividsolutions$jump$workbench$driver$ShapeFileInputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$ShapeFileInputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.ShapeFileInputDriver")) : class$com$vividsolutions$jump$workbench$driver$ShapeFileInputDriver, class$com$vividsolutions$jump$workbench$driver$WKTFileInputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$WKTFileInputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.WKTFileInputDriver")) : class$com$vividsolutions$jump$workbench$driver$WKTFileInputDriver);
    private List builtInOutputDriverClasses = Arrays.asList(class$com$vividsolutions$jump$workbench$driver$FMEFileOutputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$FMEFileOutputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.FMEFileOutputDriver")) : class$com$vividsolutions$jump$workbench$driver$FMEFileOutputDriver, class$com$vividsolutions$jump$workbench$driver$GMLFileOutputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$GMLFileOutputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.GMLFileOutputDriver")) : class$com$vividsolutions$jump$workbench$driver$GMLFileOutputDriver, class$com$vividsolutions$jump$workbench$driver$JMLFileOutputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$JMLFileOutputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.JMLFileOutputDriver")) : class$com$vividsolutions$jump$workbench$driver$JMLFileOutputDriver, class$com$vividsolutions$jump$workbench$driver$ShapefileOutputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$ShapefileOutputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.ShapefileOutputDriver")) : class$com$vividsolutions$jump$workbench$driver$ShapefileOutputDriver, class$com$vividsolutions$jump$workbench$driver$WKTFileOutputDriver == null ? (class$com$vividsolutions$jump$workbench$driver$WKTFileOutputDriver = DriverManager.class$("com.vividsolutions.jump.workbench.driver.WKTFileOutputDriver")) : class$com$vividsolutions$jump$workbench$driver$WKTFileOutputDriver);
    private BasicFileDriverPanel sharedOpenBasicFileDriverPanel;
    private BasicFileDriverPanel sharedSaveBasicFileDriverPanel;
    private ErrorHandler errorHandler;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$FMEFileInputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$GMLFileInputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$JMLFileInputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$ShapeFileInputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$WKTFileInputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$FMEFileOutputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$GMLFileOutputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$JMLFileOutputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$ShapefileOutputDriver;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$driver$WKTFileOutputDriver;

    public DriverManager(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.sharedOpenBasicFileDriverPanel = new SharedFileDriverPanel("File To Open", errorHandler);
        this.sharedSaveBasicFileDriverPanel = new SharedFileDriverPanel("File To Save", errorHandler);
        this.sharedOpenBasicFileDriverPanel.setFileMustExist(true);
        this.sharedSaveBasicFileDriverPanel.setFileMustExist(false);
    }

    public List getInputDrivers() {
        return this.inputDrivers;
    }

    public List getOutputDrivers() {
        return this.outputDrivers;
    }

    public BasicFileDriverPanel getSharedOpenBasicFileDriverPanel() {
        return this.sharedOpenBasicFileDriverPanel;
    }

    public BasicFileDriverPanel getSharedSaveBasicFileDriverPanel() {
        return this.sharedSaveBasicFileDriverPanel;
    }

    public void loadDrivers(WorkbenchProperties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList newInputDriverClasses = new ArrayList();
        newInputDriverClasses.addAll(this.builtInInputDriverClasses);
        newInputDriverClasses.addAll(properties.getInputDriverClasses());
        this.loadDrivers(newInputDriverClasses, this.inputDrivers);
        ArrayList newOutputDriverClasses = new ArrayList();
        newOutputDriverClasses.addAll(this.builtInOutputDriverClasses);
        newOutputDriverClasses.addAll(properties.getOutputDriverClasses());
        this.loadDrivers(newOutputDriverClasses, this.outputDrivers);
    }

    public void loadInputDriver(AbstractInputDriver driver) {
        driver.initialize(this, this.errorHandler);
        this.inputDrivers.add(driver);
    }

    public void loadOutputDriver(AbstractOutputDriver driver) {
        driver.initialize(this, this.errorHandler);
        this.outputDrivers.add(driver);
    }

    private void loadDrivers(List driverClasses, List drivers) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Iterator i = driverClasses.iterator();
        while (i.hasNext()) {
            Class driverClass = (Class)i.next();
            AbstractDriver driver = (AbstractDriver)driverClass.newInstance();
            driver.initialize(this, this.errorHandler);
            drivers.add(driver);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SharedFileDriverPanel
    extends BasicFileDriverPanel {
        public SharedFileDriverPanel(String description, ErrorHandler errorHandler) {
            super(errorHandler);
            this.fileNamePanel.setUpperDescription(description);
        }

        public void setFileDescription(String description) {
            Assert.shouldNeverReachHere((String)"Panel is shared; thus description cannot be changed");
        }
    }
}

