/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ToolTipWriter {
    private boolean enabled = false;
    private LayerViewPanel panel;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ToolTipWriter(LayerViewPanel panel) {
        this.panel = panel;
    }

    public String write(String template, Point2D mouseLocation) {
        Map layerToSpecifiedFeaturesMap;
        int PIXEL_BUFFER = 2;
        if (!this.enabled) {
            return null;
        }
        try {
            layerToSpecifiedFeaturesMap = SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(this.panel.getLayerManager().iterator(), EnvelopeUtil.expand(new Envelope(this.panel.getViewport().toModelCoordinate(mouseLocation)), (double)PIXEL_BUFFER / this.panel.getViewport().getScale()));
        }
        catch (NoninvertibleTransformException e) {
            return "";
        }
        if (layerToSpecifiedFeaturesMap.isEmpty()) {
            return null;
        }
        if (template == null || template.trim().length() == 0) {
            return this.writeDefaultToolTip(layerToSpecifiedFeaturesMap);
        }
        String toolTip = template;
        Iterator i = this.extractAttributeNames(template).iterator();
        while (i.hasNext()) {
            String attributeName = (String)i.next();
            toolTip = StringUtil.replaceAll(toolTip, "{" + attributeName + "}", this.findValue(attributeName, layerToSpecifiedFeaturesMap));
        }
        return toolTip;
    }

    private String writeDefaultToolTip(Map layerToSpecifiedFeaturesMap) {
        Feature feature = (Feature)((Collection)layerToSpecifiedFeaturesMap.values().iterator().next()).iterator().next();
        String toolTip = "<html>";
        toolTip = toolTip + this.format("FID", "" + feature.getID());
        for (int i = 0; i < Math.min(4, feature.getSchema().getAttributeCount()); ++i) {
            if (feature.getSchema().getAttributeType(i) == AttributeType.GEOMETRY) continue;
            toolTip = toolTip + "<br>" + this.format(feature.getSchema().getAttributeName(i), feature.getAttribute(i));
        }
        toolTip = toolTip + "</html>";
        return toolTip;
    }

    private String format(String name, Object value) {
        return "<b>" + name + ":</b> " + value;
    }

    private String findValue(String attributeName, Map layerToSpecifiedFeaturesMap) {
        Iterator i = layerToSpecifiedFeaturesMap.keySet().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            for (int j = 0; j < layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++j) {
                if ("fid".equalsIgnoreCase(attributeName)) {
                    return "" + ((Feature)((Collection)layerToSpecifiedFeaturesMap.get(layer)).iterator().next()).getID();
                }
                if (!layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(j).equalsIgnoreCase(attributeName)) continue;
                return "" + ((Feature)((Collection)layerToSpecifiedFeaturesMap.get(layer)).iterator().next()).getAttribute(j);
            }
        }
        return "";
    }

    private Set extractAttributeNames(String template) {
        TreeSet<String> attributeNames = new TreeSet<String>();
        String currentAttributeName = "";
        block4: for (int i = 0; i < template.length(); ++i) {
            switch (template.charAt(i)) {
                case '{': {
                    currentAttributeName = "";
                    continue block4;
                }
                case '}': {
                    attributeNames.add(currentAttributeName.trim());
                    currentAttributeName = "";
                    continue block4;
                }
                default: {
                    currentAttributeName = currentAttributeName + template.charAt(i);
                }
            }
        }
        return attributeNames;
    }
}

