/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ValidatingTextField
extends JTextField {
    public static final Validator LONG_VALIDATOR = new Validator(){

        public boolean isValid(String text) {
            try {
                Long.parseLong(text.trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Validator INTEGER_VALIDATOR = new Validator(){

        public boolean isValid(String text) {
            try {
                Integer.parseInt(text.trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Validator DOUBLE_VALIDATOR = new Validator(){

        public boolean isValid(String text) {
            try {
                Double.parseDouble(text.trim() + "0");
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static Cleaner DUMMY_CLEANER = new Cleaner(){

        public String clean(String text) {
            return text;
        }
    };
    public static Cleaner NUMBER_CLEANER = new Cleaner(){

        public String clean(String text) {
            try {
                Double.parseDouble(text.trim());
                return text;
            }
            catch (NumberFormatException e) {
                return "0";
            }
        }
    };
    public static Validator DUMMY_VALIDATOR = new Validator(){

        public boolean isValid(String text) {
            return true;
        }
    };
    private Cleaner cleaner;

    public ValidatingTextField(String text, int columns, Validator validator) {
        this(text, columns, 2, validator, DUMMY_CLEANER);
    }

    public ValidatingTextField(String text, int columns, int horizontalAlignment, Validator validator, Cleaner cleaner) {
        super(text, columns);
        this.cleaner = cleaner;
        this.setHorizontalAlignment(horizontalAlignment);
        ValidatingTextField.installValidationBehavior(this, validator, cleaner);
        this.setText(cleaner.clean(this.getText()));
        this.setMinimumSize(this.getPreferredSize());
    }

    public static void installValidationBehavior(final JTextField textField, final Validator validator, final Cleaner cleaner) {
        textField.setDocument(new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String currentText = this.getText(0, this.getLength());
                String beforeOffset = currentText.substring(0, offs);
                String afterOffset = currentText.substring(offs, currentText.length());
                String proposedResult = beforeOffset + str + afterOffset;
                if (validator.isValid(cleaner.clean(proposedResult))) {
                    super.insertString(offs, str, a);
                }
            }

            public void remove(int offs, int len) throws BadLocationException {
                String currentText = this.getText(0, this.getLength());
                String beforeOffset = currentText.substring(0, offs);
                String afterOffset = currentText.substring(len + offs, currentText.length());
                String proposedResult = beforeOffset + afterOffset;
                if (validator.isValid(cleaner.clean(proposedResult))) {
                    super.remove(offs, len);
                }
            }
        });
        textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                textField.setText(cleaner.clean(textField.getText()));
            }
        });
    }

    public String getText() {
        return this.cleaner.clean(super.getText());
    }

    public double getDouble() {
        return Double.parseDouble(this.getText().trim());
    }

    public int getInteger() {
        return Integer.parseInt(this.getText().trim());
    }

    public static class CompositeCleaner
    implements Cleaner {
        private Cleaner[] cleaners;

        public CompositeCleaner(Cleaner[] cleaners) {
            this.cleaners = cleaners;
        }

        public String clean(String text) {
            String result = text;
            for (int i = 0; i < this.cleaners.length; ++i) {
                result = this.cleaners[i].clean(result);
            }
            return result;
        }
    }

    public static class CompositeValidator
    implements Validator {
        private Validator[] validators;

        public CompositeValidator(Validator[] validators) {
            this.validators = validators;
        }

        public boolean isValid(String text) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (this.validators[i].isValid(text)) continue;
                return false;
            }
            return true;
        }
    }

    public static class MaxIntCleaner
    implements Cleaner {
        private int maximum;

        public MaxIntCleaner(int maximum) {
            this.maximum = maximum;
        }

        public String clean(String text) {
            return "" + Math.min(this.maximum, Integer.parseInt(text));
        }
    }

    public static class BoundedDoubleValidator
    extends CompositeValidator {
        public BoundedDoubleValidator(double min, boolean includeMin, double max, boolean includeMax) {
            super(new Validator[]{DOUBLE_VALIDATOR, includeMin ? new GreaterThanOrEqualValidator(min) : new GreaterThanValidator(min), includeMax ? new LessThanOrEqualValidator(max) : new LessThanValidator(max)});
            Assert.isTrue((min < max ? 1 : 0) != 0);
        }
    }

    public static class BoundedIntValidator
    extends CompositeValidator {
        public BoundedIntValidator(int min, int max) {
            super(new Validator[]{INTEGER_VALIDATOR, new GreaterThanOrEqualValidator(min), new LessThanOrEqualValidator(max)});
            Assert.isTrue((min < max ? 1 : 0) != 0);
        }
    }

    public static class MinIntCleaner
    implements Cleaner {
        private int minimum;

        public MinIntCleaner(int minimum) {
            this.minimum = minimum;
        }

        public String clean(String text) {
            return "" + Math.max(this.minimum, Integer.parseInt(text));
        }
    }

    public static class NumberCleaner
    implements Cleaner {
        private String textToAppend;

        public NumberCleaner(String textToAppend) {
            this.textToAppend = textToAppend;
        }

        public String clean(String text) {
            if (text.trim().length() == 0) {
                return text;
            }
            try {
                Double.parseDouble(text);
                return text;
            }
            catch (NumberFormatException e) {
                return text + this.textToAppend;
            }
        }
    }

    public static class BlankCleaner
    implements Cleaner {
        private String replacement;

        public BlankCleaner(String replacement) {
            this.replacement = replacement;
        }

        public String clean(String text) {
            return text.trim().length() == 0 ? this.replacement : text;
        }
    }

    public static class LessThanOrEqualValidator
    implements Validator {
        private double threshold;

        public LessThanOrEqualValidator(double threshold) {
            this.threshold = threshold;
        }

        public boolean isValid(String text) {
            return Double.parseDouble(text.trim()) <= this.threshold;
        }
    }

    public static class GreaterThanOrEqualValidator
    implements Validator {
        private double threshold;

        public GreaterThanOrEqualValidator(double threshold) {
            this.threshold = threshold;
        }

        public boolean isValid(String text) {
            return Double.parseDouble(text.trim()) >= this.threshold;
        }
    }

    public static class LessThanValidator
    implements Validator {
        private double threshold;

        public LessThanValidator(double threshold) {
            this.threshold = threshold;
        }

        public boolean isValid(String text) {
            return Double.parseDouble(text.trim()) < this.threshold;
        }
    }

    public static class GreaterThanValidator
    implements Validator {
        private double threshold;

        public GreaterThanValidator(double threshold) {
            this.threshold = threshold;
        }

        public boolean isValid(String text) {
            return Double.parseDouble(text.trim()) > this.threshold;
        }
    }

    public static interface Cleaner {
        public String clean(String var1);
    }

    public static interface Validator {
        public boolean isValid(String var1);
    }
}

