/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.OrderedMap;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class RemoveSelectedCategoriesPlugIn
extends AbstractPlugIn {
    private Category pickUnselectedCategory(LayerNamePanel layerNamePanel, LayerManager layerManager) {
        Collection selectedCategories = layerNamePanel.getSelectedCategories();
        Category workingCategory = layerManager.getCategory("Working");
        if (workingCategory != null && !selectedCategories.contains(workingCategory)) {
            return workingCategory;
        }
        Iterator i = layerManager.getCategories().iterator();
        while (i.hasNext()) {
            Category category = (Category)i.next();
            if (selectedCategories.contains(category)) continue;
            return category;
        }
        return null;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.execute(this.toCategorySpecToLayerablesMap(this.toOrderedCategories(context.getLayerNamePanel().getSelectedCategories())), this.pickUnselectedCategory(context.getLayerNamePanel(), context.getLayerManager()), context);
        return true;
    }

    private List toOrderedCategories(Collection unorderedCategories) {
        ArrayList orderedCategories = new ArrayList(unorderedCategories);
        Collections.sort(orderedCategories, new Comparator(){

            public int compare(Object o1, Object o2) {
                Category c1 = (Category)o1;
                Category c2 = (Category)o2;
                return new Integer(c1.getLayerManager().indexOf(c1)).compareTo(new Integer(c2.getLayerManager().indexOf(c2)));
            }
        });
        return orderedCategories;
    }

    private OrderedMap toCategorySpecToLayerablesMap(List selectedCategoriesInOrder) {
        OrderedMap map = new OrderedMap();
        Iterator i = selectedCategoriesInOrder.iterator();
        while (i.hasNext()) {
            Category category = (Category)i.next();
            map.put(new CategorySpec(category.getName(), category.getLayerManager().indexOf(category)), new ArrayList(category.getLayerables()));
        }
        return map;
    }

    private void execute(final OrderedMap originalCategorySpecToLayerablesMap, final Category newCategory, final PlugInContext context) throws Exception {
        this.execute(new UndoableCommand(this.getName()){

            public void execute() {
                Iterator i = originalCategorySpecToLayerablesMap.keyList().iterator();
                while (i.hasNext()) {
                    CategorySpec originalCategorySpec = (CategorySpec)i.next();
                    List layers = (List)originalCategorySpecToLayerablesMap.get(originalCategorySpec);
                    Iterator j = layers.iterator();
                    while (j.hasNext()) {
                        Layerable layerable = (Layerable)j.next();
                        context.getLayerManager().remove(layerable);
                        context.getLayerManager().addLayerable(newCategory.getName(), layerable);
                    }
                    context.getLayerManager().removeIfEmpty(context.getLayerManager().getCategory(originalCategorySpec.name));
                }
            }

            public void unexecute() {
                Iterator i = originalCategorySpecToLayerablesMap.keyList().iterator();
                while (i.hasNext()) {
                    CategorySpec originalCategorySpec = (CategorySpec)i.next();
                    List layers = (List)originalCategorySpecToLayerablesMap.get(originalCategorySpec);
                    Assert.isTrue((null == context.getLayerManager().getCategory(originalCategorySpec.name) ? 1 : 0) != 0);
                    context.getLayerManager().addCategory(originalCategorySpec.name, originalCategorySpec.index);
                    Iterator j = layers.iterator();
                    while (j.hasNext()) {
                        Layerable layerable = (Layerable)j.next();
                        Assert.isTrue((context.getLayerManager().getCategory(layerable) == newCategory ? 1 : 0) != 0);
                        context.getLayerManager().remove(layerable);
                        context.getLayerManager().addLayerable(originalCategorySpec.name, layerable);
                    }
                }
            }
        }, context);
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1)).add(new EnableCheck(){

            public String check(JComponent component) {
                return RemoveSelectedCategoriesPlugIn.this.pickUnselectedCategory(workbenchContext.getLayerNamePanel(), workbenchContext.getLayerManager()) == null ? "At least 1 category must be left unselected" : null;
            }
        });
    }

    private static class CategorySpec {
        private int index;
        private String name;

        public CategorySpec(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }
}

