/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.ImmutableFirstElementList;
import com.vividsolutions.jump.workbench.ui.ColumnBasedTableModel;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class ColorThemingTableModel
extends ColumnBasedTableModel {
    public static final String COLOR_COLUMN_TITLE = "Colour";
    public static final int COLOR_COLUMN = 0;
    public static final int ATTRIBUTE_COLUMN = 1;
    protected List attributeMappings;
    private boolean lastSortAscending = true;
    protected String attributeName;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$renderer$style$BasicStyle;
    static /* synthetic */ Class class$java$lang$Object;

    public ColorThemingTableModel(BasicStyle defaultStyle, String attributeName, Map attributeValueToBasicStyleMap, FeatureSchema schema) {
        this.attributeMappings = new ImmutableFirstElementList(new AttributeMapping(null, defaultStyle));
        this.attributeName = attributeName;
        this.setAttributeValueToBasicStyleMap(attributeValueToBasicStyleMap);
        this.setColumns(this.createColumns(schema));
    }

    public void setAttributeValueToBasicStyleMap(Map map) {
        this.attributeMappings.clear();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object attributeValue = i.next();
            this.attributeMappings.add(new AttributeMapping(attributeValue, (BasicStyle)map.get(attributeValue)));
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void clear() {
        this.attributeMappings.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean containsNullAttributeValues() {
        Iterator i = this.nonDefaultAttributeMappings().iterator();
        while (i.hasNext()) {
            AttributeMapping attributeMapping = (AttributeMapping)i.next();
            if (attributeMapping.getAttributeValue() != null) continue;
            return true;
        }
        return false;
    }

    protected AttributeMapping attributeMapping(int i) {
        return (AttributeMapping)this.attributeMappings.get(i);
    }

    public BasicStyle getDefaultStyle() {
        return this.attributeMapping(0).getBasicStyle();
    }

    public Object findDuplicateAttributeValue() {
        TreeSet<Object> set = new TreeSet<Object>();
        Iterator i = this.nonDefaultAttributeMappings().iterator();
        while (i.hasNext()) {
            AttributeMapping attributeMapping = (AttributeMapping)i.next();
            if (attributeMapping.getAttributeValue() == null) continue;
            if (set.contains(attributeMapping.getAttributeValue())) {
                return attributeMapping.getAttributeValue();
            }
            set.add(attributeMapping.getAttributeValue());
        }
        return null;
    }

    protected List createColumns(final FeatureSchema schema) {
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(new ColumnBasedTableModel.Column(COLOR_COLUMN_TITLE, class$com$vividsolutions$jump$workbench$ui$renderer$style$BasicStyle == null ? (class$com$vividsolutions$jump$workbench$ui$renderer$style$BasicStyle = ColorThemingTableModel.class$("com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle")) : class$com$vividsolutions$jump$workbench$ui$renderer$style$BasicStyle){

            public Object getValueAt(int rowIndex) {
                return ColorThemingTableModel.this.attributeMapping(rowIndex).getBasicStyle();
            }

            public void setValueAt(Object value, int rowIndex) {
                ColorThemingTableModel.this.attributeMapping(rowIndex).setBasicStyle((BasicStyle)value);
                ColorThemingTableModel.this.fireTableChanged(new TableModelEvent(ColorThemingTableModel.this, rowIndex));
            }
        });
        columns.add(new ColumnBasedTableModel.Column("Attribute Value", null){

            public Class getDataClass() {
                Class clazz = ColorThemingTableModel.this.attributeName == null || !schema.hasAttribute(ColorThemingTableModel.this.attributeName) ? (class$java$lang$Object == null ? (class$java$lang$Object = ColorThemingTableModel.class$("java.lang.Object")) : class$java$lang$Object) : schema.getAttributeType(ColorThemingTableModel.this.attributeName).toJavaClass();
                return clazz;
            }

            public Object getValueAt(int rowIndex) {
                return ColorThemingTableModel.this.attributeMapping(rowIndex).getAttributeValue();
            }

            public void setValueAt(Object value, int rowIndex) {
                ColorThemingTableModel.this.attributeMapping(rowIndex).setAttributeValue(value);
                ColorThemingTableModel.this.fireTableChanged(new AttributeValueTableModelEvent(ColorThemingTableModel.this, rowIndex));
            }
        });
        return columns;
    }

    public void apply(ColorScheme colorScheme, boolean skipDefaultAttributeMapping) {
        Iterator i = (skipDefaultAttributeMapping ? this.nonDefaultAttributeMappings() : this.attributeMappings).iterator();
        while (i.hasNext()) {
            AttributeMapping attributeMapping = (AttributeMapping)i.next();
            attributeMapping.setBasicStyle(new BasicStyle(colorScheme.next()));
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int getRowCount() {
        return this.attributeMappings.size();
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Map getAttributeValueToBasicStyleMap() {
        TreeMap<Object, BasicStyle> attributeValueToBasicStyleMap = new TreeMap<Object, BasicStyle>();
        Iterator i = this.nonDefaultAttributeMappings().iterator();
        while (i.hasNext()) {
            AttributeMapping attributeMapping = (AttributeMapping)i.next();
            attributeValueToBasicStyleMap.put(attributeMapping.getAttributeValue(), attributeMapping.getBasicStyle());
        }
        return attributeValueToBasicStyleMap;
    }

    public boolean wasLastSortAscending() {
        return this.lastSortAscending;
    }

    public void sort() {
        this.sort(!this.lastSortAscending);
    }

    public void sort(boolean ascending) {
        if (ascending) {
            Collections.sort(this.nonDefaultAttributeMappings());
        } else {
            Collections.sort(this.nonDefaultAttributeMappings(), Collections.reverseOrder());
        }
        this.lastSortAscending = ascending;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void removeAttributeValues(int[] rows) {
        Iterator i = CollectionUtil.reverseSortedSet(rows).iterator();
        while (i.hasNext()) {
            Integer row = (Integer)i.next();
            this.attributeMappings.remove(row);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }
    }

    public int insertAttributeValue(int row, ColorScheme colorScheme) {
        this.attributeMappings.add(row, new AttributeMapping(null, new BasicStyle(colorScheme.next())));
        this.fireTableChanged(new TableModelEvent(this, row, row, -1, 1));
        return row;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex != 0 || columnIndex != 1;
    }

    protected List nonDefaultAttributeMappings() {
        return this.attributeMappings.subList(1, this.attributeMappings.size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AttributeValueTableModelEvent
    extends TableModelEvent {
        public AttributeValueTableModelEvent(TableModel source, int row) {
            super(source, row);
        }
    }

    protected static class AttributeMapping
    implements Comparable {
        private Object attributeValue;
        private BasicStyle basicStyle;

        public AttributeMapping(Object attributeValue, BasicStyle basicStyle) {
            this.attributeValue = attributeValue;
            this.basicStyle = basicStyle;
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public BasicStyle getBasicStyle() {
            return this.basicStyle;
        }

        public int compareTo(Object o) {
            AttributeMapping other = (AttributeMapping)o;
            if (this.attributeValue == null) {
                return -1;
            }
            if (other.attributeValue == null) {
                return 1;
            }
            return ((Comparable)this.attributeValue).compareTo((Comparable)other.attributeValue);
        }

        public void setAttributeValue(Object object) {
            this.attributeValue = object;
        }

        public void setBasicStyle(BasicStyle style) {
            this.basicStyle = style;
        }
    }
}

