/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.connect;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;
import net.sf.postgeoolap.connect.MetadataServer;
import net.sf.postgeoolap.locale.Local;
import net.sf.postgeoolap.model.Schema;

public class DBConnection {
    private static Connection postGreSQLConnection = null;
    private static Connection metaDataConnection = null;

    public static Connection getPostGreSQLConnection() {
        if (postGreSQLConnection == null) {
            JOptionPane.showMessageDialog(null, Local.getString("SchemaConnectionError"));
        }
        return postGreSQLConnection;
    }

    public static boolean configPostGreSQLConnection(Schema schema) {
        Connection connection;
        String userName = schema.getUser();
        String password = schema.getPassword();
        String dbServer = schema.getServer();
        String dbName = schema.getName();
        String database = "jdbc:postgresql://" + dbServer + ":5432/" + dbName;
        try {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(database, userName, password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.err);
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return false;
        }
        postGreSQLConnection = connection;
        return true;
    }

    public static boolean checkPostGreSQLConnection(Schema schema) {
        String userName = schema.getUser();
        String password = schema.getPassword();
        String dbServer = schema.getServer();
        String dbName = schema.getName();
        String database = "jdbc:postgresql://" + dbServer + ":5432/" + dbName;
        try {
            Class.forName("org.postgresql.Driver");
            DriverManager.getConnection(database, userName, password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.err);
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static Connection getMetadataConnection() {
        if (metaDataConnection == null) {
            Connection connection;
            try {
                Class.forName("org.postgresql.Driver");
                MetadataServer metadata = new MetadataServer();
                String location = metadata.getServerLocation();
                String database = metadata.getDatabaseName();
                String user = metadata.getUserName();
                String password = metadata.getPassword();
                connection = DriverManager.getConnection("jdbc:postgresql://" + location + ":5432/" + database, user, password);
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(null, Local.getString("CouldNotLoadAccessDriver"));
                e.printStackTrace(System.err);
                return null;
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(null, Local.getString("CouldNotConnectMetadataDatabase"));
                e.printStackTrace(System.err);
                return null;
            }
            metaDataConnection = connection;
        }
        return metaDataConnection;
    }

    public static void clearMetadata() {
        String sql = "DELETE FROM cubo  WHERE cubecode NOT IN     (SELECT cubecode FROM dimension)";
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void closeConnections() {
        DBConnection.closeConnection(metaDataConnection);
        DBConnection.closeConnection(postGreSQLConnection);
    }

    private static void closeConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

