/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.gui;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MeasureTool;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import net.sf.postgeoolap.locale.Local;
import net.sf.postgeoolap.model.Attribute;

public class MapPanel
extends JPanel
implements LayerViewPanelContext {
    private ErrorHandler errorHandler;
    private WorkbenchToolBar toolBar;
    private JPanel toolBarPanel;
    private LayerManager layerManager;
    private LayerViewPanel layerViewPanel;
    private TreeLayerNamePanel layerNamePanel;
    private JLabel statusLabel;
    private String mapName;

    public MapPanel(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.initialize();
        this.buildPanel();
    }

    public void initialize() {
        this.layerManager = new LayerManager();
        this.layerViewPanel = new LayerViewPanel(this.layerManager, (LayerViewPanelContext)this);
        this.layerNamePanel = new TreeLayerNamePanel((LayerManagerProxy)this.layerViewPanel, (TreeModel)new LayerTreeModel((LayerManagerProxy)this.layerViewPanel), this.layerViewPanel.getRenderingManager(), new HashMap());
        this.toolBar = new WorkbenchToolBar(new LayerViewPanelProxy(){

            public LayerViewPanel getLayerViewPanel() {
                return MapPanel.this.layerViewPanel;
            }
        });
        this.toolBar.setFloatable(false);
        this.layerViewPanel.addListener(new LayerViewPanelListener(){

            public void painted(Graphics graphics) {
            }

            public void selectionChanged() {
            }

            public void cursorPositionChanged(String x, String y) {
                MapPanel.this.setStatusMessage("(" + x + ", " + y + ")");
            }
        });
        this.statusLabel = new JLabel(" ");
    }

    private void buildPanel() {
        this.toolBar.setOrientation(1);
        this.toolBarPanel = new JPanel();
        this.toolBarPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.toolBarPanel.add((Component)this.toolBar);
        this.setLayout(new BorderLayout());
        JPanel statusPanel = new JPanel();
        statusPanel.add(this.statusLabel);
        this.layerViewPanel.setPreferredSize(new Dimension(300, 200));
        this.layerViewPanel.setSize(new Dimension(300, 200));
        this.add((Component)this.toolBarPanel, "West");
        this.add((Component)this.layerViewPanel, "Center");
        this.add((Component)statusPanel, "South");
    }

    public void initJUMP() throws Exception {
        this.toolBar.addCursorTool("Zoom In/Out", (CursorTool)new ZoomTool());
        this.toolBar.addCursorTool("Pan", (CursorTool)new PanTool());
        this.toolBar.addCursorTool("Measure", (CursorTool)new MeasureTool());
        this.loadData();
    }

    private void loadData() throws Exception {
        this.removeAllCategories(this.layerManager);
    }

    public void loadData(String title, String input) {
        this.removeAllCategories(this.layerManager);
    }

    public void removeAllCategories(LayerManager layerManager) {
        for (Category category : layerManager.getCategories()) {
            layerManager.removeIfEmpty(category);
        }
    }

    public File toFile(String fileName) {
        String parent = "net/sf/postgeoolap/gui";
        return new File(parent, fileName);
    }

    public void setStatusMessage(String message) {
        this.statusLabel.setText(message == null || message.length() == 0 ? " " : message);
    }

    public void warnUser(String warning) {
        this.setStatusMessage(warning);
    }

    public void handleThrowable(Throwable t) {
        this.errorHandler.handleThrowable(t);
    }

    public TreeLayerNamePanel getLayerNamePanel() {
        return this.layerNamePanel;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void repaintMap() {
        this.layerViewPanel.repaint();
    }

    public void plotAttribute(Attribute attribute, List list) {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute(attribute.getName(), AttributeType.GEOMETRY);
        FeatureDataset featureCollection = new FeatureDataset(featureSchema);
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BasicFeature feature = new BasicFeature(featureCollection.getFeatureSchema());
                feature.setAttribute(attribute.getName(), (Object)new WKTReader().read((String)iterator.next()));
                featureCollection.add((Feature)feature);
            }
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, Local.getString("WKTParsingError"));
        }
        this.layerManager.addLayer(attribute.getName(), attribute.getName(), (FeatureCollection)featureCollection);
    }
}

