/*
 * Decompiled with CFR 0.152.
 */
package net.sf.postgeoolap.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.postgeoolap.connect.DBConnection;
import net.sf.postgeoolap.locale.Local;
import net.sf.postgeoolap.model.Attribute;
import net.sf.postgeoolap.model.Cube;
import net.sf.postgeoolap.model.Dimension;

public class Aggregation {
    private int code;
    private String name;
    private boolean base;
    private String sqlBase;
    private Cube cube;
    private int sorting;
    private Map attributes = new TreeMap();

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBasic() {
        return this.base;
    }

    public String getSQLBase() {
        return this.sqlBase;
    }

    public Cube getCube() {
        return this.cube;
    }

    public int getSorting() {
        return this.sorting;
    }

    public Map getAttributes() {
        if (this.attributes.size() == 0) {
            this.attributes = Attribute.getAttributeAggegationList(this);
        }
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public static Map getAggregationList(Cube cube) {
        String sql = "SELECT * FROM aggregation  WHERE cubecode = " + cube.getCode() + "  ORDER BY sorting";
        TreeMap<String, Aggregation> map = new TreeMap<String, Aggregation>();
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                Aggregation aggregation = new Aggregation();
                aggregation.code = resultSet.getInt(1);
                aggregation.name = resultSet.getString(2);
                aggregation.base = resultSet.getString(3).equals("S");
                aggregation.sqlBase = resultSet.getString(4);
                aggregation.sorting = resultSet.getInt(6);
                aggregation.cube = cube;
                map.put(aggregation.name, aggregation);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("UnknownSQLException"));
            return null;
        }
        return map;
    }

    public void retrieve(Cube cube, String name) {
        this.retrieve(cube, name, 0L);
    }

    public void retrieve(Cube cube, String name, long code) {
        String sql = code != 0L ? "SELECT * FROM aggregation  WHERE aggregationcode = " + code : "SELECT * FROM aggregation  WHERE name = '" + name + "'" + "    AND cubecode = " + cube.getCode();
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                this.code = resultSet.getInt(1);
                this.name = resultSet.getString(2);
                this.base = resultSet.getString(3).equals("S");
                this.sqlBase = resultSet.getString(4);
                this.sorting = resultSet.getInt(6);
                this.cube = cube;
            }
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("UnknownSQLException"));
        }
    }

    public static boolean createBasicAggregation(Cube cube) {
        Dimension dimension;
        String orderName = "";
        Map dimensionMap = cube.getDimensions();
        int dimensionQuantity = dimensionMap.size() - 1;
        String name = cube.getName() + "Base";
        for (int i = 1; i <= dimensionQuantity; ++i) {
            orderName = orderName + "9";
        }
        int order = Integer.parseInt(orderName);
        String sqlBase = "FROM ";
        for (String key : dimensionMap.keySet()) {
            dimension = (Dimension)dimensionMap.get(key);
            if (!sqlBase.equals("FROM ")) {
                sqlBase = sqlBase + ", ";
            }
            sqlBase = sqlBase + "\"" + dimension.getName() + "\"";
        }
        sqlBase = sqlBase + " WHERE ";
        for (String key : dimensionMap.keySet()) {
            dimension = (Dimension)dimensionMap.get(key);
            if (dimension.getType().equals("Fact")) continue;
            if (!sqlBase.endsWith("WHERE ")) {
                sqlBase = sqlBase + " AND ";
            }
            sqlBase = sqlBase + dimension.getClause();
        }
        return Aggregation.save(name, true, sqlBase, cube.getCode(), order);
    }

    private static boolean save(String name, boolean base, String sqlAgreg, int cubeCode, int order) {
        String sql = sqlAgreg.equals("") ? "INSERT INTO aggregation   (name, base, cubecode, sorting)   VALUES ('" + name + "', '" + (base ? "S" : "N") + "', " + cubeCode + ", " + order + ")" : "INSERT INTO aggregation   (name, base, sqlbase, cubecode, sorting)   VALUES ('" + name + "', '" + (base ? "S" : "N") + "', '" + sqlAgreg + "', " + cubeCode + ", " + order + ")";
        try {
            Statement statement = DBConnection.getMetadataConnection().createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("UnknownSQLException"));
            return false;
        }
        return true;
    }

    public boolean deleteCubeAggregation(Cube cube) {
        Statement statement;
        String sql = "DROP TABLE \"" + this.getName() + "\"";
        try {
            statement = DBConnection.getPostGreSQLConnection().createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("UnknownSQLException"));
        }
        sql = "DELETE FROM aggregation WHERE aggregationcode = " + this.getCode();
        try {
            statement = DBConnection.getMetadataConnection().createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("UnknownSQLException"));
            return false;
        }
        return true;
    }

    public boolean create(String aggregationName, Map attributeMap, Cube cube, int sorting) {
        Statement statement;
        Attribute attribute = new Attribute();
        String sql = "CREATE TABLE " + aggregationName + " (";
        Iterator iterator = attributeMap.keySet().iterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)attributeMap.get(iterator.next());
            String attributeName = attribute.getName();
            String attributeType = attribute.getType().equals("char") || attribute.getType().equals("varchar") ? "varchar(255)" : attribute.getType();
            if (sql.charAt(sql.length() - 1) != '(') {
                sql = sql + ", ";
            }
            sql = sql + attributeName + " " + attributeType;
        }
        sql = sql + " )";
        try {
            statement = DBConnection.getPostGreSQLConnection().createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("PGAggregationGenerationError"));
        }
        iterator = attributeMap.keySet().iterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)attributeMap.get(iterator.next());
            if (!attribute.isGeographic()) continue;
            sql = "SELECT addgeometrycolumn('" + cube.getSchema().getName() + "', '" + aggregationName.toLowerCase() + "', '" + attribute.getName() + "', '" + cube.getSchema().getSrid() + "', '" + attribute.getType().toUpperCase() + "', 2)";
            try {
                Statement statement2 = DBConnection.getPostGreSQLConnection().createStatement();
                statement2.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace(System.err);
                System.err.println(Local.getString("AddingGeographicFieldError"));
                return false;
            }
        }
        if (!Aggregation.save(aggregationName, false, "", cube.getCode(), sorting)) {
            return false;
        }
        this.retrieve(cube, aggregationName);
        try {
            statement = DBConnection.getMetadataConnection().createStatement();
            Iterator iterator2 = attributeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                attribute = (Attribute)attributeMap.get(iterator2.next());
                sql = "INSERT INTO aggregationitem (aggregationcode, attributecode) VALUES (" + this.getCode() + ", " + attribute.getCode() + ")";
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("AggregationItemRecordingError"));
            return false;
        }
        return true;
    }

    public boolean loadData(Aggregation referenceAggregation) {
        Attribute attribute;
        String attributeName;
        int aggregableQuantity = 0;
        Map attributeMap = this.getAttributes();
        String sql = "INSERT INTO " + this.getName() + " (";
        Iterator iterator = attributeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)attributeMap.get((String)iterator.next());
            if (sql.charAt(sql.length() - 1) != '(') {
                sql = sql + ", ";
            }
            sql = sql + attribute2.getName();
            if (!attribute2.getAggregationType().equals("R")) continue;
            ++aggregableQuantity;
        }
        sql = sql + ") (SELECT ";
        if (referenceAggregation.isBasic()) {
            attributeName = "";
            iterator = attributeMap.keySet().iterator();
            while (iterator.hasNext()) {
                attribute = (Attribute)attributeMap.get((String)iterator.next());
                if (attribute.getAggregationType().equals("R")) {
                    attributeName = attribute.getTable().getName() + "." + attribute.getName();
                } else if (attribute.getAggregationType().equals("S")) {
                    attributeName = "sum(" + attribute.getTable().getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("C")) {
                    attributeName = "count(" + attribute.getTable().getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("A")) {
                    attributeName = "avg(" + attribute.getTable().getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("M")) {
                    attributeName = "max(" + attribute.getTable().getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("I")) {
                    attributeName = "min(" + attribute.getTable().getName() + "." + attribute.getName() + ")";
                }
                if (!sql.substring(sql.length() - 7).equals("SELECT ")) {
                    sql = sql + ", ";
                }
                sql = sql + attributeName;
            }
        } else {
            attributeName = "";
            iterator = attributeMap.keySet().iterator();
            while (iterator.hasNext()) {
                attribute = (Attribute)attributeMap.get((String)iterator.next());
                if (attribute.getAggregationType().equals("R")) {
                    attributeName = referenceAggregation.getName() + "." + attribute.getName();
                } else if (attribute.getAggregationType().equals("S")) {
                    attributeName = "sum(" + referenceAggregation.getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("C")) {
                    attributeName = "count(" + referenceAggregation.getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("A")) {
                    attributeName = "avg(" + referenceAggregation.getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("M")) {
                    attributeName = "max(" + referenceAggregation.getName() + "." + attribute.getName() + ")";
                } else if (attribute.getAggregationType().equals("I")) {
                    attributeName = "min(" + referenceAggregation.getName() + "." + attribute.getName() + ")";
                }
                if (!sql.substring(sql.length() - 7).equals("SELECT ")) {
                    sql = sql + ", ";
                }
                sql = sql + attributeName;
            }
        }
        sql = sql + " FROM ";
        if (!referenceAggregation.isBasic()) {
            sql = sql + referenceAggregation.getName();
        } else {
            Map dimensionMap = this.getAggregationDimensionCollection();
            iterator = dimensionMap.keySet().iterator();
            while (iterator.hasNext()) {
                Dimension dimension = (Dimension)dimensionMap.get((String)iterator.next());
                if (!sql.substring(sql.length() - 5).equals("FROM ")) {
                    sql = sql + ", ";
                }
                sql = sql + dimension.getName();
            }
            int nonFactDimensionNumber = dimensionMap.size() - 1;
            if (nonFactDimensionNumber > 0) {
                sql = sql + " WHERE ";
                iterator = dimensionMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Dimension dimension = (Dimension)dimensionMap.get((String)iterator.next());
                    if (!sql.substring(sql.length() - 6).equals("WHERE ")) {
                        sql = sql + " AND ";
                    }
                    sql = sql + dimension.getClause();
                }
            }
            sql = sql.substring(0, sql.length() - 9);
        }
        if (aggregableQuantity > 0) {
            sql = sql + " GROUP BY ";
            iterator = attributeMap.keySet().iterator();
            while (iterator.hasNext()) {
                attribute = (Attribute)attributeMap.get((String)iterator.next());
                if (!attribute.getAggregationType().equals("R")) continue;
                if (!referenceAggregation.isBasic()) {
                    if (!sql.substring(sql.length() - 9).equals("GROUP BY ")) {
                        sql = sql + ", ";
                    }
                    sql = sql + referenceAggregation.getName() + "." + attribute.getName();
                    continue;
                }
                if (!sql.substring(sql.length() - 9).equals("GROUP BY ")) {
                    sql = sql + ", ";
                }
                sql = sql + attribute.getTable().getName() + "." + attribute.getName();
            }
        }
        sql = sql + ")";
        try {
            Statement statement = DBConnection.getPostGreSQLConnection().createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            System.err.println(Local.getString("AggregationInsertDataError"));
            return false;
        }
        return true;
    }

    public Map getAggregationDimensionCollection() {
        return Dimension.getAggregationDimensions(this);
    }

    public boolean createIndexes() {
        boolean combinedIndexes = false;
        TreeMap<String, Dimension> factlessDimensionMap = new TreeMap<String, Dimension>();
        Map dimensionMap = this.getAggregationDimensionCollection();
        Iterator iterator = dimensionMap.keySet().iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)dimensionMap.get((String)iterator.next());
            if (!dimension.getType().equals("Dimension")) continue;
            factlessDimensionMap.put(dimension.getName(), dimension);
        }
        if (factlessDimensionMap.size() == 0) {
            return false;
        }
        int i = 1;
        int j = 1;
        iterator = factlessDimensionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String sql;
            Dimension dimension = (Dimension)factlessDimensionMap.get((String)iterator.next());
            Map attributeMap = dimension.getAggregationDimensionAttributes(this);
            String fieldNames = "";
            String totalFieldNames = "";
            j = 1;
            Iterator iterator2 = attributeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)attributeMap.get((String)iterator2.next());
                if (!attribute.isGeographic()) {
                    if (combinedIndexes) {
                        if (!fieldNames.equals("")) {
                            fieldNames = fieldNames + ", ";
                        }
                        fieldNames = fieldNames + attribute.getName();
                        if (!totalFieldNames.equals("")) {
                            totalFieldNames = totalFieldNames + ", ";
                        }
                        totalFieldNames = totalFieldNames + attribute.getName();
                    } else {
                        sql = "CREATE INDEX ix" + this.getName() + i + j + "  ON " + this.getName() + " (" + attribute.getName() + ")";
                        if (!this.createPostGreSQLIndex(sql)) {
                            return false;
                        }
                    }
                } else {
                    sql = "CREATE INDEX " + this.getName() + attribute.getName() + "ixgeo" + "  ON " + this.getName() + "  USING GIST (" + attribute.getName() + " GIST_GEOMETRY_OPS)";
                    if (!this.createPostGreSQLIndex(sql)) {
                        return false;
                    }
                }
                ++j;
            }
            if (combinedIndexes) {
                String indexName = this.getName() + i;
                sql = "CREATE INDEX " + indexName + "  ON " + this.getName() + " (" + fieldNames + ")";
                if (!this.createPostGreSQLIndex(sql)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean createPostGreSQLIndex(String sqlIndex) {
        try {
            DBConnection.getPostGreSQLConnection().createStatement().execute(sqlIndex);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.err.println(Local.getString("CreatingPostGreSQLIndexError"));
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }
}

